/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.transformer;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.TransformerCoupling;
import org.patryk3211.powergrid.electricity.transformer.TransformerCoilParameters;
import org.patryk3211.powergrid.electricity.transformer.TransformerSoundInstance;
import org.patryk3211.powergrid.electricity.transformer.TransformerVolumeProvider;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public abstract class TransformerBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation,
TransformerVolumeProvider {
    protected TransformerCoilParameters primaryCoil;
    protected TransformerCoilParameters secondaryCoil;
    protected ElectricWire primaryStray;
    protected ElectricWire mutualInductance;
    protected TransformerCoupling coupling;
    public float lastCurrent;
    private boolean hasSoundSource;

    public TransformerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    public abstract double coreAl();

    public abstract double couplingFactor();

    public void tick() {
        float power = 0.0f;
        this.lastCurrent = 0.0f;
        if (this.primaryStray != null && this.primaryStray.isConverged()) {
            float I1 = this.primaryStray.current();
            double P12 = (double)(I1 * I1) * this.primaryStray.getResistance();
            power = (float)((double)power + P12);
            this.lastCurrent += Math.abs(I1);
        }
        if (this.mutualInductance != null && this.mutualInductance.isConverged()) {
            float I3 = this.mutualInductance.current();
            double P32 = (double)(I3 * I3) * this.mutualInductance.getResistance();
            power = (float)((double)power + P32);
            this.lastCurrent += Math.abs(I3);
        }
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyTickPower(power);
        }
        super.tick();
        if (this.field_11863.field_9236) {
            this.tickAudio();
        }
    }

    @Override
    public float getVolume() {
        float volume = this.lastCurrent / 80.0f;
        return class_3532.method_15363((float)(volume * volume), (float)0.0f, (float)0.333f);
    }

    @Environment(value=EnvType.CLIENT)
    protected void tickAudio() {
        if (!this.hasSoundSource && this.getVolume() > 0.0f) {
            class_310.method_1551().method_1483().method_4873((class_1113)new TransformerSoundInstance(this));
            this.hasSoundSource = true;
        } else if (this.hasSoundSource && this.getVolume() <= 0.0f) {
            this.hasSoundSource = false;
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        boolean rebuild = false;
        if (tag.method_10545("Primary")) {
            class_2487 primary = tag.method_10562("Primary");
            rebuild |= this.primaryCoil.readNbt(primary);
        } else if (this.primaryCoil != null) {
            rebuild |= this.primaryCoil.clear();
        }
        if (tag.method_10545("Secondary")) {
            class_2487 secondary = tag.method_10562("Secondary");
            rebuild |= this.secondaryCoil.readNbt(secondary);
        } else if (this.primaryCoil != null) {
            rebuild |= this.secondaryCoil.clear();
        }
        if (rebuild) {
            this.electricBehaviour.rebuildCircuit();
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.primaryCoil != null && this.primaryCoil.isDefined()) {
            class_2487 primary = new class_2487();
            this.primaryCoil.writeNbt(primary);
            tag.method_10566("Primary", (class_2520)primary);
        }
        if (this.secondaryCoil != null && this.secondaryCoil.isDefined()) {
            class_2487 secondary = new class_2487();
            this.secondaryCoil.writeNbt(secondary);
            tag.method_10566("Secondary", (class_2520)secondary);
        }
    }

    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        if (this.primaryCoil != null && this.primaryCoil.isDefined()) {
            class_2487 primary = new class_2487();
            this.primaryCoil.writeNbt(primary);
            tag.method_10566("Primary", (class_2520)primary);
        }
        if (this.secondaryCoil != null && this.secondaryCoil.isDefined()) {
            class_2487 secondary = new class_2487();
            this.secondaryCoil.writeNbt(secondary);
            tag.method_10566("Secondary", (class_2520)secondary);
        }
    }

    public ItemRequirement getRequiredItems(class_2680 state) {
        int count = 0;
        if (this.primaryCoil != null) {
            count += this.primaryCoil.getTurns();
        }
        if (this.secondaryCoil != null) {
            count += this.secondaryCoil.getTurns();
        }
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        while (count > 0) {
            stacks.add(ModdedItems.WIRE.asStack(Math.min(count, 64)));
            count -= 64;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    public boolean isTerminalUsed(int index) {
        if (this.primaryCoil.isDefined() && (this.primaryCoil.getTerminal1() == index || this.primaryCoil.getTerminal2() == index)) {
            return true;
        }
        return this.secondaryCoil.isDefined() && (this.secondaryCoil.getTerminal1() == index || this.secondaryCoil.getTerminal2() == index);
    }

    public void makePrimary(int terminal1, int terminal2, int turns, class_1792 item) {
        this.primaryCoil.set(terminal1, terminal2, turns, item);
        this.electricBehaviour.rebuildCircuit();
        this.notifyUpdate();
    }

    public boolean hasPrimary() {
        return this.primaryCoil.isDefined();
    }

    public TransformerCoilParameters getPrimary() {
        return this.primaryCoil;
    }

    public void makeSecondary(int terminal1, int terminal2, int turns, class_1792 item) {
        this.secondaryCoil.set(terminal1, terminal2, turns, item);
        this.electricBehaviour.rebuildCircuit();
        this.notifyUpdate();
    }

    public boolean hasSecondary() {
        return this.secondaryCoil.isDefined();
    }

    public TransformerCoilParameters getSecondary() {
        return this.secondaryCoil;
    }

    public void removeSecondary() {
        this.secondaryCoil.clear();
        this.electricBehaviour.rebuildCircuit();
        this.notifyUpdate();
    }

    public void removePrimary() {
        this.primaryCoil.clear();
        this.electricBehaviour.rebuildCircuit();
        this.notifyUpdate();
    }

    public void updateCoilBlockState() {
    }

    public static float mutualMultiplier() {
        return ModdedConfigs.server().electricity.transformerMutualInductanceMultiplier.getF();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        if (this.primaryCoil == null) {
            this.primaryCoil = new TransformerCoilParameters();
            this.secondaryCoil = new TransformerCoilParameters();
        }
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.updateCoilBlockState();
        }
        double coreAl = this.coreAl();
        double couplingFactor = this.couplingFactor();
        int primaryTurns = this.primaryCoil.getTurns();
        int secondaryTurns = this.secondaryCoil.getTurns();
        builder.setTerminalCount(4);
        double primaryInductance = (double)(primaryTurns * primaryTurns) * coreAl;
        double secondaryInductance = (double)(secondaryTurns * secondaryTurns) * coreAl;
        if (this.primaryCoil.isDefined() && this.secondaryCoil.isDefined()) {
            TransformerCoilParameters secondaryCoil;
            boolean flipped = primaryTurns > secondaryTurns;
            TransformerCoilParameters primaryCoil = flipped ? this.secondaryCoil : this.primaryCoil;
            TransformerCoilParameters transformerCoilParameters = secondaryCoil = flipped ? this.primaryCoil : this.secondaryCoil;
            if (flipped) {
                int b = primaryTurns;
                primaryTurns = secondaryTurns;
                secondaryTurns = b;
                double b2 = primaryInductance;
                primaryInductance = secondaryInductance;
                secondaryInductance = b2;
            }
            float ratio = (float)secondaryTurns / (float)primaryTurns;
            double mutualInductance = couplingFactor * primaryInductance;
            float primaryStray = (float)(primaryInductance - mutualInductance);
            float secondaryStray = (float)(secondaryInductance - (double)(ratio * ratio) * mutualInductance);
            FloatingNode Tnode = builder.addInternalNode();
            FloatingNode P12 = builder.terminalNode(primaryCoil.getTerminal1());
            FloatingNode P2 = builder.terminalNode(primaryCoil.getTerminal2());
            this.primaryStray = builder.connect(primaryStray, P12, Tnode);
            this.mutualInductance = builder.connect((float)mutualInductance * TransformerBlockEntity.mutualMultiplier(), Tnode, P2);
            this.coupling = builder.couple(ratio, secondaryStray * ratio * ratio, Tnode, P2, builder.terminalNode(secondaryCoil.getTerminal1()), builder.terminalNode(secondaryCoil.getTerminal2()));
        } else if (this.primaryCoil.isDefined()) {
            this.primaryStray = builder.connect((float)primaryInductance * TransformerBlockEntity.mutualMultiplier(), builder.terminalNode(this.primaryCoil.getTerminal1()), builder.terminalNode(this.primaryCoil.getTerminal2()));
            this.mutualInductance = null;
            this.coupling = null;
        } else if (this.secondaryCoil.isDefined()) {
            this.primaryStray = builder.connect((float)secondaryInductance * TransformerBlockEntity.mutualMultiplier(), builder.terminalNode(this.secondaryCoil.getTerminal1()), builder.terminalNode(this.secondaryCoil.getTerminal2()));
            this.mutualInductance = null;
            this.coupling = null;
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!isPlayerSneaking) {
            return false;
        }
        Lang.builder().translate("gui.transformer.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.transformer.ratio", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        int primaryTurns = this.primaryCoil.getTurns();
        int secondaryTurns = this.secondaryCoil.getTurns();
        int largestCommonDenominator = 1;
        if (primaryTurns > 0 && secondaryTurns > 0) {
            for (int i = 2; i <= Math.max(primaryTurns, secondaryTurns); ++i) {
                if (primaryTurns % i != 0 || secondaryTurns % i != 0) continue;
                largestCommonDenominator = i;
            }
        }
        LangBuilder n1 = Lang.number(primaryTurns / largestCommonDenominator);
        LangBuilder n2 = Lang.number(secondaryTurns / largestCommonDenominator);
        LangBuilder ratio = n1.add(class_2561.method_30163((String)":")).add(n2);
        ratio.style(class_124.field_1075).forGoggles(tooltip, 1);
        if (this.primaryStray != null && this.mutualInductance != null) {
            float primary = (float)this.primaryStray.getResistance();
            float secondary = this.coupling.getResistance();
            if (primaryTurns > secondaryTurns) {
                float r = primary;
                primary = secondary;
                secondary = r;
            }
            Lang.builder().translate("gui.transformer.primary_stray", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            Unit.RESISTANCE.formatWithPrefixes(primary).style(class_124.field_1075).forGoggles(tooltip, 1);
            Lang.builder().translate("gui.transformer.secondary_stray", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            Unit.RESISTANCE.formatWithPrefixes(secondary).style(class_124.field_1075).forGoggles(tooltip, 1);
            Lang.builder().translate("gui.transformer.parallel_resistance", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            Unit.RESISTANCE.formatWithPrefixes(this.mutualInductance.getResistance()).style(class_124.field_1075).forGoggles(tooltip, 1);
        } else if (this.primaryStray != null) {
            Lang.builder().translate("gui.transformer.parallel_resistance", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            Unit.RESISTANCE.formatWithPrefixes(this.primaryStray.getResistance()).style(class_124.field_1075).forGoggles(tooltip, 1);
        }
        return true;
    }
}

