/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireEntity;

public class BlockWireEndpoint
implements IWireEndpoint {
    private class_2338 pos;
    private int terminal;

    public BlockWireEndpoint() {
        this(null, 0);
    }

    public BlockWireEndpoint(class_2338 pos, int terminal) {
        this.pos = pos;
        this.terminal = terminal;
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.BLOCK;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public int getTerminal() {
        return this.terminal;
    }

    @Override
    public void read(class_2487 nbt) {
        int[] posArr = nbt.method_10561("Pos");
        this.pos = new class_2338(posArr[0], posArr[1], posArr[2]);
        this.terminal = nbt.method_10550("Terminal");
    }

    @Override
    public void write(class_2487 nbt) {
        nbt.method_10539("Pos", new int[]{this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260()});
        nbt.method_10569("Terminal", this.terminal);
    }

    public IElectric getElectricBlock(class_1937 world) {
        if (!world.method_8393(class_4076.method_18675((int)this.pos.method_10263()), class_4076.method_18675((int)this.pos.method_10260()))) {
            return null;
        }
        return IElectric.getAt(world, this.pos);
    }

    public ElectricBehaviour getElectricBehaviour(class_1937 world) {
        if (!world.method_8393(class_4076.method_18675((int)this.pos.method_10263()), class_4076.method_18675((int)this.pos.method_10260()))) {
            return null;
        }
        IElectric electric = this.getElectricBlock(world);
        if (electric == null) {
            return null;
        }
        class_2680 state = world.method_8320(this.pos);
        return electric.getBehaviour(world, this.pos, state);
    }

    @Override
    @NotNull
    public class_243 getExactPosition(class_1937 world) {
        return IElectric.getTerminalPos(world, this.pos, this.terminal);
    }

    @Override
    public OwnedFloatingNode getNode(class_1937 world) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            WorldNetworks global = GlobalElectricNetworks.getWorldNetworks(world);
            return global.globalExternalNodes.get(this);
        }
        return behaviour.getTerminal(this.terminal);
    }

    @Override
    public void joinNetwork(class_1937 world, ElectricalNetwork network) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            OwnedFloatingNode node = GlobalElectricNetworks.getWorldNetworks((class_1937)world).globalExternalNodes.get(this);
            if (node != null) {
                network.addNode((INode)node);
            }
            return;
        }
        behaviour.joinNetwork(network);
    }

    @Override
    public boolean isValid(class_1937 world) {
        if (!world.method_8393(class_4076.method_18675((int)this.pos.method_10263()), class_4076.method_18675((int)this.pos.method_10260()))) {
            return false;
        }
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            return false;
        }
        return behaviour.hasTerminal(this.terminal);
    }

    @Override
    public <T extends BaseWireEntity> boolean canAcceptType(Class<T> clazz) {
        return WireEntity.class.isAssignableFrom(clazz);
    }

    @Override
    public void assignWireEntity(BaseWireEntity entity) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(entity.method_37908());
        if (behaviour == null) {
            return;
        }
        behaviour.addConnection(this, entity);
    }

    @Override
    public void removeWireEntity(BaseWireEntity entity) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(entity.method_37908());
        if (behaviour == null) {
            return;
        }
        behaviour.removeConnection(this, entity);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockWireEndpoint) {
            BlockWireEndpoint other = (BlockWireEndpoint)obj;
            return this.pos.equals((Object)other.pos) && this.terminal == other.terminal;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.terminal);
    }

    public String toString() {
        return String.format("Block(pos=%s, n=%d)", this.pos, this.terminal);
    }

    public ITerminalPlacement getTerminalPlacement(class_1937 world) {
        IElectric electric = this.getElectricBlock(world);
        class_2680 state = world.method_8320(this.pos);
        return electric.terminal(state, this.terminal);
    }

    @Override
    public IWireEndpoint makeOffset(class_2338 offset) {
        return new BlockWireEndpoint(this.pos.method_10081((class_2382)offset), this.terminal);
    }
}

