/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.Collection;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.BakedCircuit;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;

public class CircuitBoardEndpoint
implements IWireEndpoint {
    private class_2338 pos;
    private int x;
    private int y;

    public CircuitBoardEndpoint() {
        this(null, 0, 0);
    }

    public CircuitBoardEndpoint(class_2338 pos, int x, int y) {
        this.pos = pos;
        this.x = x;
        this.y = y;
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.CIRCUIT_BOARD;
    }

    @Override
    public void read(class_2487 nbt) {
        int[] posArr = nbt.method_10561("Pos");
        this.pos = new class_2338(posArr[0], posArr[1], posArr[2]);
        this.x = nbt.method_10571("X");
        this.y = nbt.method_10571("Y");
    }

    @Override
    public void write(class_2487 nbt) {
        nbt.method_10539("Pos", new int[]{this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260()});
        nbt.method_10567("X", (byte)this.x);
        nbt.method_10567("Y", (byte)this.y);
    }

    @Override
    @NotNull
    public class_243 getExactPosition(class_1937 world) {
        class_243 pos = new class_243((double)(((float)this.x + 0.5f) / 16.0f), 0.125, (double)(((float)this.y + 0.5f) / 16.0f));
        class_2680 state = world.method_8320(this.pos);
        pos = VecHelper.rotateCentered((class_243)pos, (double)CircuitBoardBlock.getAngleX(state), (class_2350.class_2351)class_2350.class_2351.field_11048);
        pos = VecHelper.rotateCentered((class_243)pos, (double)CircuitBoardBlock.getAngleY(state), (class_2350.class_2351)class_2350.class_2351.field_11052);
        return pos.method_1031((double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260());
    }

    @Override
    public boolean isValid(class_1937 world) {
        Optional opt = world.method_35230(this.pos, (class_2591)ModdedBlockEntities.CIRCUIT_BOARD.get());
        return opt.map(be -> be.getSchematic().front().get(this.x, this.y)).orElse(false);
    }

    public IElectricNode getGenericNode(class_1937 world) {
        Optional opt = world.method_35230(this.pos, (class_2591)ModdedBlockEntities.CIRCUIT_BOARD.get());
        return opt.map(be -> {
            BakedCircuit baked = be.getBaked();
            if (baked == null) {
                return null;
            }
            Collection<CircuitSchematic.Node> bundle = be.getSchematic().flood(CircuitSchematic.Layer.FRONT, this.x, this.y, new CircuitSchematic.VisitMap());
            if (bundle.isEmpty()) {
                return null;
            }
            CircuitSchematic.Node node = bundle.iterator().next();
            return baked.getNode(node);
        }).orElse(null);
    }
}

