/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import net.minecraft.class_243;
import net.minecraft.class_5819;

public class CurveParameters {
    private final double a;
    private final double b;
    private final double c;
    private final class_243 normal;
    private final float dx;
    private float dy;
    private final float L;
    public final class_243 cross1;
    public final class_243 cross2;
    public final float thickness;

    public CurveParameters(class_243 t1, class_243 t2, double horizontalCoefficient, double verticalCoefficient, double thickness) {
        class_243 direction = new class_243(t2.field_1352 - t1.field_1352, 0.0, t2.field_1350 - t1.field_1350);
        double dy = t2.field_1351 - t1.field_1351;
        this.dx = (float)direction.method_1033();
        this.normal = direction.method_1029();
        this.thickness = (float)thickness;
        if (this.dx > 0.0f) {
            this.L = (float)Math.sqrt((double)(this.dx * this.dx) * horizontalCoefficient + dy * dy * verticalCoefficient);
            double r = Math.sqrt((double)(this.L * this.L) - dy * dy) / (double)this.dx;
            double A = r < 3.0 ? Math.sqrt(6.0 * (r - 1.0)) : Math.log(2.0 * r) + Math.log(Math.log(2.0 * r));
            for (int i = 0; i < 5; ++i) {
                double top = Math.sinh(A) - r * A;
                double bot = Math.cosh(A) - r;
                A -= top / bot;
            }
            this.a = (double)this.dx / (2.0 * A);
            double z = dy / (double)this.L;
            this.b = -this.a * 0.5 * Math.log((1.0 + z) / (1.0 - z));
            this.c = 0.5 * (dy - (double)this.L / Math.tanh(A));
        } else {
            this.a = 0.0;
            this.b = 0.0;
            this.c = 0.0;
            this.L = (float)dy;
            this.dy = (float)dy;
        }
        direction = new class_243(t2.field_1352 - t1.field_1352, t2.field_1351 - t1.field_1351, t2.field_1350 - t1.field_1350);
        class_243 v1 = new class_243(1.0 - direction.field_1352, 1.0 - direction.field_1351, 1.0 - direction.field_1350);
        this.cross1 = v1.method_1036(direction).method_1029().method_1021(thickness * 0.5);
        this.cross2 = this.cross1.method_1036(direction).method_1029().method_1021(thickness * 0.5);
    }

    public float apply(float x) {
        return (float)(this.a * Math.cosh(((double)x - this.b) / this.a) + this.c);
    }

    public void runForSegments(ISegmentConsumer consumer) {
        this.runForSegments((float x1, float y1, float z1, float x2, float y2, float z2, float offset, float length, boolean first, boolean last) -> consumer.apply(x1, y1, z1, x2, y2, z2, offset, length));
    }

    public void runForSegments(IMarkedSegmentConsumer consumer) {
        int segmentCount = Math.max((int)Math.round((double)this.L / 0.5), 5);
        if (this.dx > 0.0f) {
            float prevX = -this.dx / 2.0f;
            float prevY = this.apply(prevX);
            float offset = 0.0f;
            for (int i = 1; i <= segmentCount; ++i) {
                float x = ((float)i / (float)segmentCount - 0.5f) * this.dx;
                float y = this.apply(x);
                float dx = x - prevX;
                float dy = y - prevY;
                float length = (float)Math.sqrt(dx * dx + dy * dy);
                consumer.apply((float)this.normal.field_1352 * prevX, prevY, (float)this.normal.field_1350 * prevX, (float)this.normal.field_1352 * x, y, (float)this.normal.field_1350 * x, offset, length, i == 1, i == segmentCount);
                offset += length;
                prevX = x;
                prevY = y;
            }
        } else {
            float prevY = 0.0f;
            float offset = 0.0f;
            for (int i = 1; i <= segmentCount; ++i) {
                float y = (float)i / (float)segmentCount * this.dy;
                float dy = y - prevY;
                consumer.apply(0.0f, prevY, 0.0f, 0.0f, y, 0.0f, offset, dy, i == 1, i == segmentCount);
                offset += dy;
                prevY = y;
            }
        }
    }

    public void runForPoints(int pointCount, IPointConsumer consumer) {
        if (this.dx > 0.0f) {
            for (int i = 0; i < pointCount; ++i) {
                float localX = ((float)i / (float)pointCount - 0.5f) * this.dx;
                consumer.apply((float)((double)localX * this.normal.field_1352), this.apply(localX), (float)((double)localX * this.normal.field_1350));
            }
        } else {
            for (int i = 0; i < pointCount; ++i) {
                float y = (float)i / (float)pointCount * this.dy;
                consumer.apply(0.0f, y, 0.0f);
            }
        }
    }

    public class_243 getRandomPoint(class_5819 random) {
        if (this.dx > 0.0f) {
            float x = random.method_43057() * this.dx - this.dx / 2.0f;
            float y = this.apply(x);
            return new class_243(this.normal.field_1352 * (double)x, (double)y, this.normal.field_1350 * (double)x);
        }
        float y = random.method_43057() * this.dy;
        return new class_243(0.0, (double)y, 0.0);
    }

    public float getCurveSpan() {
        return this.dx > 0.0f ? this.dx : this.dy;
    }

    public class_243 getNormal() {
        return this.normal;
    }

    public double findClosestPoint(double x1, double y1) {
        double x = x1;
        for (int i = 0; i < 5; ++i) {
            double z = (x - this.b) / this.a;
            double xCosh = Math.cosh(z);
            double xSinh = Math.sinh(z);
            double fval = 2.0 * ((this.a * xCosh + this.c - y1) * xSinh + x - x1);
            double fdval = 4.0 * xCosh * xCosh + 2.0 / this.a * xCosh * (this.c - y1);
            x -= fval / fdval;
        }
        return x;
    }

    public boolean isVertical() {
        return this.dx == 0.0f;
    }

    public static interface ISegmentConsumer {
        public void apply(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);
    }

    public static interface IMarkedSegmentConsumer {
        public void apply(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, boolean var9, boolean var10);
    }

    public static interface IPointConsumer {
        public void apply(float var1, float var2, float var3);
    }
}

