/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.JunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;

public class DeferredJunctionWireEndpoint
implements IWireEndpoint {
    private class_2338 entityPos;
    private UUID entityId;
    private int segmentIndex;
    private int segmentPoint;

    public DeferredJunctionWireEndpoint() {
    }

    public DeferredJunctionWireEndpoint(BlockWireEntity entity, int segmentIndex, int segmentPoint) {
        this.entityPos = entity.method_24515();
        this.entityId = entity.method_5667();
        this.segmentIndex = segmentIndex;
        this.segmentPoint = segmentPoint;
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.DEFERRED_JUNCTION;
    }

    @Override
    public void read(class_2487 nbt) {
        int[] posArray = nbt.method_10561("Pos");
        this.entityPos = new class_2338(posArray[0], posArray[1], posArray[2]);
        this.entityId = nbt.method_25926("Id");
        this.segmentIndex = nbt.method_10550("Index");
        this.segmentPoint = nbt.method_10550("Point");
    }

    @Override
    public void write(class_2487 nbt) {
        nbt.method_10539("Pos", new int[]{this.entityPos.method_10263(), this.entityPos.method_10264(), this.entityPos.method_10260()});
        nbt.method_25927("Id", this.entityId);
        nbt.method_10569("Index", this.segmentIndex);
        nbt.method_10569("Point", this.segmentPoint);
    }

    @Nullable
    public BlockWireEntity getEntity(class_1937 world) {
        List entities = world.method_8390(BlockWireEntity.class, new class_238(this.entityPos), e -> this.entityId.equals(e.method_5667()));
        if (entities.isEmpty()) {
            return null;
        }
        return (BlockWireEntity)entities.get(0);
    }

    @Override
    @NotNull
    public class_243 getExactPosition(class_1937 world) {
        BlockWireEntity wire = this.getEntity(world);
        if (wire == null) {
            return this.entityPos.method_46558();
        }
        if (this.segmentIndex >= wire.segments.size()) {
            this.segmentIndex = wire.segments.size() - 1;
        }
        BlockWireEntity.Point segment = wire.segments.get(this.segmentIndex);
        return segment.start.method_43206(segment.direction, (double)((float)this.segmentPoint / 16.0f));
    }

    @Nullable
    public JunctionWireEndpoint resolve(class_1937 world) {
        BlockWireEntity entity = this.getEntity(world);
        if (entity == null) {
            return null;
        }
        return entity.split(this.segmentIndex, this.segmentPoint);
    }

    @Override
    public <T extends BaseWireEntity> boolean canAcceptType(Class<T> clazz) {
        return BlockWireEntity.class.isAssignableFrom(clazz);
    }
}

