/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.electricity.wire.CurveParameters;
import org.patryk3211.powergrid.electricity.wire.HangingWireEntity;

@Environment(value=EnvType.CLIENT)
public class HangingWireRenderer
extends class_897<HangingWireEntity> {
    public static final boolean RAINBOW_WIRES = false;
    public static final double SEGMENT_SIZE = 0.5;

    public HangingWireRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @NotNull
    public class_2960 getTextureLocation(HangingWireEntity entity) {
        return entity.getWireItem().getWireTexture();
    }

    public void render(HangingWireEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (entity.renderParams == null) {
            return;
        }
        if (entity.isOverheated()) {
            return;
        }
        class_4588 buffer = class_310.method_1517() ? vertexConsumers.getBuffer(class_1921.method_23576((class_2960)this.getTextureLocation(entity))) : vertexConsumers.getBuffer(class_1921.method_23578((class_2960)this.getTextureLocation(entity)));
        assert (entity.renderParams instanceof CurveParameters);
        CurveParameters rp = (CurveParameters)entity.renderParams;
        float thicknessOffset = (float)entity.method_5628() / 16.0f;
        int color = entity.getColor() | 0xFF000000;
        class_243 pos = entity.method_19538();
        class_1937 world = entity.method_37908();
        rp.runForSegments((x1, y1, z1, x2, y2, z2, offset, length) -> {
            class_2338 blockPos = class_2338.method_49637((double)((double)(x1 + x2) * 0.5 + pos.field_1352), (double)((double)(y1 + y2) * 0.5 + pos.field_1351), (double)((double)(z1 + z2) * 0.5 + pos.field_1350));
            int sky = world.method_8314(class_1944.field_9284, blockPos);
            int block = world.method_8314(class_1944.field_9282, blockPos);
            HangingWireRenderer.renderSegment(matrices, buffer, x1, y1, z1, x2, y2, z2, rp.cross1, rp.cross2, class_765.method_23687((int)block, (int)sky), color, rp.thickness, thicknessOffset, length, offset);
        });
    }

    public static void renderFromPositions(class_4587 matrices, class_4588 buffer, class_243 t1, class_243 t2, double horizontalCoefficient, double verticalCoefficient, double thickness, int light, int color) {
        float x = (float)(t1.field_1352 + t2.field_1352) * 0.5f;
        float y = (float)t1.field_1351;
        float z = (float)(t1.field_1350 + t2.field_1350) * 0.5f;
        CurveParameters curve = new CurveParameters(t1, t2, horizontalCoefficient, verticalCoefficient, thickness);
        curve.runForSegments((x1, y1, z1, x2, y2, z2, offset, length) -> HangingWireRenderer.renderSegment(matrices, buffer, x1 + x, y1 + y, z1 + z, x2 + x, y2 + y, z2 + z, curve.cross1, curve.cross2, light, color, curve.thickness, 0.0f, length, offset));
    }

    public static void renderFromPositions(class_4587 matrices, class_4588 buffer, class_243 t1, class_243 t2, double horizontalCoefficient, double verticalCoefficient, double thickness, class_1920 lightProvider, int color) {
        float x = (float)(t1.field_1352 + t2.field_1352) * 0.5f;
        float y = (float)t1.field_1351;
        float z = (float)(t1.field_1350 + t2.field_1350) * 0.5f;
        CurveParameters curve = new CurveParameters(t1, t2, horizontalCoefficient, verticalCoefficient, thickness);
        curve.runForSegments((x1, y1, z1, x2, y2, z2, offset, length) -> {
            class_2338 blockPos = class_2338.method_49637((double)((double)(x1 + x2) * 0.5 + (double)x), (double)((double)(y1 + y2) * 0.5 + (double)y), (double)((double)(z1 + z2) * 0.5 + (double)z));
            int sky = lightProvider.method_8314(class_1944.field_9284, blockPos);
            int block = lightProvider.method_8314(class_1944.field_9282, blockPos);
            HangingWireRenderer.renderSegment(matrices, buffer, x1 + x, y1 + y, z1 + z, x2 + x, y2 + y, z2 + z, curve.cross1, curve.cross2, class_765.method_23687((int)block, (int)sky), color, curve.thickness, 0.0f, length, offset);
        });
    }

    public static void renderSegment(class_4587 ms, class_4588 buffer, float x1, float y1, float z1, float x2, float y2, float z2, class_243 cross1, class_243 cross2, int light, int color, float thickness, float thicknessOffset, float uvLength, float lengthOffset) {
        if (!class_310.method_1517()) {
            HangingWireRenderer.quad(ms.method_23760(), buffer, light, color, (double)x1 + cross1.field_1352, (double)y1 + cross1.field_1351, (double)z1 + cross1.field_1350, (double)x1 - cross1.field_1352, (double)y1 - cross1.field_1351, (double)z1 - cross1.field_1350, (double)x2 + cross1.field_1352, (double)y2 + cross1.field_1351, (double)z2 + cross1.field_1350, (double)x2 - cross1.field_1352, (double)y2 - cross1.field_1351, (double)z2 - cross1.field_1350, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.method_23760(), buffer, light, color, (double)x1 + cross2.field_1352, (double)y1 + cross2.field_1351, (double)z1 + cross2.field_1350, (double)x1 - cross2.field_1352, (double)y1 - cross2.field_1351, (double)z1 - cross2.field_1350, (double)x2 + cross2.field_1352, (double)y2 + cross2.field_1351, (double)z2 + cross2.field_1350, (double)x2 - cross2.field_1352, (double)y2 - cross2.field_1351, (double)z2 - cross2.field_1350, thickness, thicknessOffset, uvLength, lengthOffset);
        } else {
            HangingWireRenderer.quad(ms.method_23760(), buffer, light, color, (double)x1 + cross1.field_1352, (double)y1 + cross1.field_1351, (double)z1 + cross1.field_1350, (double)x1 - cross2.field_1352, (double)y1 - cross2.field_1351, (double)z1 - cross2.field_1350, (double)x2 + cross1.field_1352, (double)y2 + cross1.field_1351, (double)z2 + cross1.field_1350, (double)x2 - cross2.field_1352, (double)y2 - cross2.field_1351, (double)z2 - cross2.field_1350, cross1.field_1352 - cross2.field_1352, cross1.field_1351 - cross2.field_1351, cross1.field_1350 - cross2.field_1350, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.method_23760(), buffer, light, color, (double)x1 - cross1.field_1352, (double)y1 - cross1.field_1351, (double)z1 - cross1.field_1350, (double)x1 + cross2.field_1352, (double)y1 + cross2.field_1351, (double)z1 + cross2.field_1350, (double)x2 - cross1.field_1352, (double)y2 - cross1.field_1351, (double)z2 - cross1.field_1350, (double)x2 + cross2.field_1352, (double)y2 + cross2.field_1351, (double)z2 + cross2.field_1350, cross2.field_1352 - cross1.field_1352, cross2.field_1351 - cross1.field_1351, cross2.field_1350 - cross1.field_1350, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.method_23760(), buffer, light, color, (double)x1 + cross2.field_1352, (double)y1 + cross2.field_1351, (double)z1 + cross2.field_1350, (double)x1 + cross1.field_1352, (double)y1 + cross1.field_1351, (double)z1 + cross1.field_1350, (double)x2 + cross2.field_1352, (double)y2 + cross2.field_1351, (double)z2 + cross2.field_1350, (double)x2 + cross1.field_1352, (double)y2 + cross1.field_1351, (double)z2 + cross1.field_1350, cross1.field_1352 + cross2.field_1352, cross1.field_1351 + cross2.field_1351, cross1.field_1350 + cross2.field_1350, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.method_23760(), buffer, light, color, (double)x1 - cross2.field_1352, (double)y1 - cross2.field_1351, (double)z1 - cross2.field_1350, (double)x1 - cross1.field_1352, (double)y1 - cross1.field_1351, (double)z1 - cross1.field_1350, (double)x2 - cross2.field_1352, (double)y2 - cross2.field_1351, (double)z2 - cross2.field_1350, (double)x2 - cross1.field_1352, (double)y2 - cross1.field_1351, (double)z2 - cross1.field_1350, -cross1.field_1352 - cross2.field_1352, -cross1.field_1351 - cross2.field_1351, -cross1.field_1350 - cross2.field_1350, thickness, thicknessOffset, uvLength, lengthOffset);
            HangingWireRenderer.quad(ms.method_23760(), buffer, light, color, (double)x1 + cross1.field_1352, (double)y1 + cross1.field_1351, (double)z1 + cross1.field_1350, (double)x1 + cross2.field_1352, (double)y1 + cross2.field_1351, (double)z1 + cross2.field_1350, (double)x1 - cross2.field_1352, (double)y1 - cross2.field_1351, (double)z1 - cross2.field_1350, (double)x1 - cross1.field_1352, (double)y1 - cross1.field_1351, (double)z1 - cross1.field_1350, x1 - x2, y1 - y2, z1 - z2, thickness, thicknessOffset, thickness, thicknessOffset);
            HangingWireRenderer.quad(ms.method_23760(), buffer, light, color, (double)x2 + cross1.field_1352, (double)y2 + cross1.field_1351, (double)z2 + cross1.field_1350, (double)x2 + cross2.field_1352, (double)y2 + cross2.field_1351, (double)z2 + cross2.field_1350, (double)x2 - cross2.field_1352, (double)y2 - cross2.field_1351, (double)z2 - cross2.field_1350, (double)x2 - cross1.field_1352, (double)y2 - cross1.field_1351, (double)z2 - cross1.field_1350, x2 - x1, y2 - y1, z2 - z1, thickness, thicknessOffset, thickness, thicknessOffset);
        }
    }

    public static void quad(class_4587.class_4665 matrix, class_4588 buffer, int light, int color, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, float thickness, float thicknessOffset, float uvLength, float lengthOffset) {
        buffer.method_22918(matrix.method_23761(), (float)x1, (float)y1, (float)z1).method_39415(color).method_22913(lengthOffset, thicknessOffset).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(matrix.method_23761(), (float)x2, (float)y2, (float)z2).method_39415(color).method_22913(lengthOffset, thicknessOffset + thickness).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(matrix.method_23761(), (float)x4, (float)y4, (float)z4).method_39415(color).method_22913(lengthOffset + uvLength, thicknessOffset + thickness).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(matrix.method_23761(), (float)x3, (float)y3, (float)z3).method_39415(color).method_22913(lengthOffset + uvLength, thicknessOffset).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
    }

    public static void quad(class_4587.class_4665 matrix, class_4588 buffer, int light, int color, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, double nX, double nY, double nZ, float thickness, float thicknessOffset, float uvLength, float lengthOffset) {
        double nLen = Math.sqrt(nX * nX + nY * nY + nZ * nZ);
        buffer.method_22918(matrix.method_23761(), (float)x1, (float)y1, (float)z1).method_39415(color).method_22913(lengthOffset, thicknessOffset).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix.method_23762(), (float)(nX /= nLen), (float)(nY /= nLen), (float)(nZ /= nLen)).method_1344();
        buffer.method_22918(matrix.method_23761(), (float)x2, (float)y2, (float)z2).method_39415(color).method_22913(lengthOffset, thicknessOffset + thickness).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix.method_23762(), (float)nX, (float)nY, (float)nZ).method_1344();
        buffer.method_22918(matrix.method_23761(), (float)x4, (float)y4, (float)z4).method_39415(color).method_22913(lengthOffset + uvLength, thicknessOffset + thickness).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix.method_23762(), (float)nX, (float)nY, (float)nZ).method_1344();
        buffer.method_22918(matrix.method_23761(), (float)x3, (float)y3, (float)z3).method_39415(color).method_22913(lengthOffset + uvLength, thicknessOffset).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix.method_23762(), (float)nX, (float)nY, (float)nZ).method_1344();
    }
}

