/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllSpecialTextures;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.createmod.catnip.theme.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntityEndpoint;
import org.patryk3211.powergrid.electricity.wire.BlockWireRenderer;
import org.patryk3211.powergrid.electricity.wire.HangingWireRenderer;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.electricity.wire.powercord.CordItem;
import org.patryk3211.powergrid.electricity.wire.powercord.CordRenderer;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;
import org.patryk3211.powergrid.utility.BlockTrace;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlacementOverlay;

@Environment(value=EnvType.CLIENT)
public class WirePreview {
    private static final boolean DEBUG_BLOCK_TRACING = false;
    public static final Object outlineSlot = new Object();

    @Nullable
    public static class_1799 getUsedWireStack(class_1657 player) {
        class_1799 stack1 = player.method_6047();
        class_1799 stack2 = player.method_6079();
        if (stack1 != null && stack1.method_7909() instanceof IWire && stack1.method_7985()) {
            return stack1;
        }
        if (stack2 != null && stack2.method_7909() instanceof IWire && stack2.method_7985()) {
            return stack2;
        }
        return null;
    }

    private static void renderCord(SuperRenderTypeBuffer buffer, class_4587 matrixStack, class_638 world, class_746 player, class_239 target, class_1799 wireStack) {
        IWireEndpoint endpoint = WireEndpointType.deserialize(wireStack.method_7969());
        if (!(endpoint instanceof ICordEndpoint)) {
            return;
        }
        ICordEndpoint cordEndpoint = (ICordEndpoint)endpoint;
        CordRenderer.renderPreview(cordEndpoint, player.method_30951(AnimationTickHolder.getPartialTicks()), matrixStack, (class_4597)buffer, (class_1937)world, (CordItem)wireStack.method_7909(), -12501967);
    }

    public static void render(SuperRenderTypeBuffer buffer, class_4587 matrixStack, class_638 world, class_746 player, class_239 target) {
        boolean isBlockWire;
        BlockWireEntityEndpoint bwe;
        BlockWireEntity entity;
        class_1799 wireStack = WirePreview.getUsedWireStack((class_1657)player);
        if (wireStack == null) {
            return;
        }
        class_1792 class_17922 = wireStack.method_7909();
        if (!(class_17922 instanceof WireItem)) {
            return;
        }
        WireItem wireItem = (WireItem)class_17922;
        if (wireStack.method_7909() instanceof CordItem) {
            WirePreview.renderCord(buffer, matrixStack, world, player, target, wireStack);
            return;
        }
        if (target.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_2487 tag = wireStack.method_7969();
        class_4588 consumer = buffer.getBuffer(class_1921.method_23580((class_2960)wireItem.getWireTexture()));
        float thickness = wireItem.getWireThickness();
        IWireEndpoint endpoint = WireEndpointType.deserialize(tag);
        if (endpoint == null) {
            return;
        }
        class_243 currentPos = endpoint.getExactPosition((class_1937)world);
        class_2350 continueDir = null;
        if (endpoint instanceof BlockWireEntityEndpoint && (entity = (bwe = (BlockWireEntityEndpoint)endpoint).getEntity((class_1937)world)) != null) {
            List<BlockWireEntity.Point> segments = entity.segments;
            if (segments.isEmpty()) {
                return;
            }
            if (bwe.getEnd()) {
                BlockWireEntity.Point last = segments.get(segments.size() - 1);
                continueDir = last.direction;
            } else {
                BlockWireEntity.Point first = segments.get(0);
                continueDir = first.direction.method_10153();
            }
        }
        class_243 hitPoint = target.method_17784();
        ITerminalPlacement hitTerminal = null;
        if (target.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos;
            ITerminalPlacement terminal;
            class_3965 blockTarget = (class_3965)target;
            class_2680 state = world.method_8320(blockTarget.method_17777());
            IElectric electric = IElectric.getAt((class_1937)world, blockTarget.method_17777());
            if (electric != null && (terminal = electric.terminalAt(state, hitPoint.method_1023((double)(pos = blockTarget.method_17777()).method_10263(), (double)pos.method_10264(), (double)pos.method_10260()))) != null) {
                hitPoint = terminal.getOrigin().method_1031((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                hitTerminal = terminal;
            }
        }
        float length = 0.0f;
        boolean bl = isBlockWire = endpoint.type() != WireEndpointType.BLOCK;
        if (isBlockWire || hitTerminal == null) {
            BlockTrace.TraceResult points;
            Pair<BlockTrace.TraceState, BlockTrace.TraceResult> output = BlockTrace.findPathWithState((class_1937)world, currentPos = BlockTrace.alignPosition(currentPos), hitPoint, hitTerminal, continueDir);
            if (output != null && (points = (BlockTrace.TraceResult)output.getSecond()) != null) {
                for (BlockWireEntity.Point p : points.points()) {
                    class_243 nextPos = currentPos.method_1019(p.vector());
                    int color = points.reachedTarget() ? -2136277078 : -2130728278;
                    BlockWireRenderer.renderSegment(matrixStack, consumer, 0xF000F0, color, currentPos, p.direction, thickness, p.length(), 0);
                    currentPos = nextPos;
                    length += p.length();
                }
            }
        } else {
            length = (float)currentPos.method_1022(hitPoint);
            int color = length < wireItem.getMaximumLength() ? -2136277078 : -2130728278;
            HangingWireRenderer.renderFromPositions(matrixStack, consumer, currentPos, hitPoint, 1.01, 1.2, (double)thickness, 0xF000F0, color);
        }
        if (!player.method_7337()) {
            int requiredItemCount = Math.max(Math.round(length), 1);
            PlacementOverlay.setItemRequirement(wireStack.method_7909(), requiredItemCount, wireStack.method_7947() >= requiredItemCount);
        }
    }

    public static class_2561 distanceOverlay(class_1657 player) {
        class_1799 wireStack = WirePreview.getUsedWireStack(player);
        if (wireStack == null) {
            return null;
        }
        class_1792 class_17922 = wireStack.method_7909();
        if (!(class_17922 instanceof WireItem)) {
            return null;
        }
        WireItem wire = (WireItem)class_17922;
        class_2487 tag = wireStack.method_7969();
        IWireEndpoint endpoint = WireEndpointType.deserialize(tag);
        if (endpoint == null) {
            return null;
        }
        class_243 currentPos = endpoint.getExactPosition(player.method_37908());
        class_239 target = class_310.method_1551().field_1765;
        if (target == null || target.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_243 hitPoint = target.method_17784();
        double distance = hitPoint.method_1022(currentPos);
        return Lang.translate("gui.endpoint_distance", new Object[0]).add(Lang.numberConstant(distance).style(distance < (double)wire.getMaximumLength() ? class_124.field_1060 : class_124.field_1061)).style(class_124.field_1068).component();
    }

    public static void notifyOfBlock(class_2338 pos) {
        Outliner.getInstance().showAABB(outlineSlot, new class_238(pos), 50).colored(Color.RED.brighter()).withFaceTexture((BindableTexture)AllSpecialTextures.CHECKERED).lineWidth(0.05f);
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)AllSoundEvents.DENY.getMainEvent(), (float)1.0f));
    }
}

