/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire.powercord;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ISocketElectric;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.electricity.wire.powercord.CordEntity;
import org.patryk3211.powergrid.electricity.wire.powercord.IAcceptCord;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordPlacementHandler;
import org.patryk3211.powergrid.electricity.wire.powercord.SplitCordEndpoint;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class CordItem
extends WireItem {
    public static final List<ICordPlacementHandler> PLACEMENT_HANDLERS = new ArrayList<ICordPlacementHandler>();

    public CordItem(class_1792.class_1793 settings) {
        super(settings);
    }

    private static class_1269 connect(ICordEndpoint endpoint1, ICordEndpoint endpoint2, class_1838 context) {
        class_1937 level = context.method_8045();
        if (!endpoint1.isValid(level) || !endpoint2.isValid(level)) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_failed", new Object[0]).style(class_124.field_1061).component());
            PowerGrid.LOGGER.error("Connection failed, at least one endpoint is not valid");
            return class_1269.field_5814;
        }
        OwnedFloatingNode node1 = endpoint1.getEndpoint1().getNode(level);
        OwnedFloatingNode node2 = endpoint2.getEndpoint1().getNode(level);
        if (node1 == null || node2 == null || node1 == node2) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_failed", new Object[0]).style(class_124.field_1061).component());
            PowerGrid.LOGGER.error("Connection failed, nodes: ({}, {})", (Object)node1, (Object)node2);
            return class_1269.field_5814;
        }
        node1 = endpoint1.getEndpoint2().getNode(level);
        node2 = endpoint2.getEndpoint2().getNode(level);
        if (node1 == null || node2 == null || node1 == node2) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_failed", new Object[0]).style(class_124.field_1061).component());
            PowerGrid.LOGGER.error("Connection failed, nodes: ({}, {})", (Object)node1, (Object)node2);
            return class_1269.field_5814;
        }
        IWireEndpoint e11 = endpoint1.getEndpoint1();
        IWireEndpoint e21 = endpoint2.getEndpoint1();
        if (e11 instanceof BlockWireEndpoint) {
            BlockWireEndpoint be1 = (BlockWireEndpoint)e11;
            if (e21 instanceof BlockWireEndpoint) {
                BlockWireEndpoint be2 = (BlockWireEndpoint)e21;
                ElectricBehaviour behaviour1 = be1.getElectricBehaviour(level);
                ElectricBehaviour behaviour2 = be2.getElectricBehaviour(level);
                if (behaviour1.hasConnection(be1, be2) || behaviour2.hasConnection(be2, be1)) {
                    IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_exists", new Object[0]).style(class_124.field_1061).component());
                    return class_1269.field_5814;
                }
            }
        }
        IWireEndpoint e12 = endpoint1.getEndpoint2();
        IWireEndpoint e22 = endpoint2.getEndpoint2();
        if (e12 instanceof BlockWireEndpoint) {
            BlockWireEndpoint be1 = (BlockWireEndpoint)e12;
            if (e22 instanceof BlockWireEndpoint) {
                BlockWireEndpoint be2 = (BlockWireEndpoint)e22;
                ElectricBehaviour behaviour1 = be1.getElectricBehaviour(level);
                ElectricBehaviour behaviour2 = be2.getElectricBehaviour(level);
                if (behaviour1.hasConnection(be1, be2) || behaviour2.hasConnection(be2, be1)) {
                    IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_exists", new Object[0]).style(class_124.field_1061).component());
                    return class_1269.field_5814;
                }
            }
        }
        class_243 terminal1Pos = endpoint1.getExactPosition(level);
        class_243 terminal2Pos = endpoint2.getExactPosition(level);
        class_1799 stack = context.method_8041();
        assert (stack.method_7909() instanceof IWire);
        IWire item = (IWire)stack.method_7909();
        class_2487 tag = stack.method_7969();
        assert (tag != null);
        float distance = (float)terminal1Pos.method_1022(terminal2Pos);
        if (distance > item.getMaximumLength()) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_too_long", new Object[0]).style(class_124.field_1061).component());
            return class_1269.field_5814;
        }
        int requiredItemCount = Math.max(Math.round(distance), 1);
        if (!PlayerUtilities.hasEnoughItems(context.method_8036(), stack, requiredItemCount)) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_missing_items", new Object[0]).style(class_124.field_1061).component());
            return class_1269.field_5814;
        }
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_3218 serverWorld = (class_3218)level;
        CordEntity entity = CordEntity.create((class_1937)serverWorld, endpoint1, endpoint2, new class_1799(stack.method_41409(), requiredItemCount), null);
        if (context.method_8036() != null) {
            class_1792 class_17922;
            class_1799 offItem = context.method_8036().method_6079();
            if (item.canBeColored() && (class_17922 = offItem.method_7909()) instanceof class_1769) {
                class_1769 dye = (class_1769)class_17922;
                entity.setColor(dye.method_7802());
            }
        }
        if (!serverWorld.method_30736((class_1297)entity)) {
            PowerGrid.LOGGER.error("Failed to spawn new connection wire entity.");
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_failed", new Object[0]).style(class_124.field_1061).component());
            return class_1269.field_5814;
        }
        if (context.method_8036() == null || !context.method_8036().method_7337()) {
            stack.method_7934(requiredItemCount);
        }
        return class_1269.field_5812;
    }

    private static class_1269 addEndpoint(class_1838 context, ICordEndpoint endpoint) {
        class_1799 stack = context.method_8041();
        IWireEndpoint firstPoint = WireEndpointType.deserialize(stack.method_7969());
        if (firstPoint == null) {
            stack.method_7980(endpoint.serialize());
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.cord_next", new Object[0]).style(class_124.field_1080).component());
            return class_1269.field_5812;
        }
        if (firstPoint instanceof ICordEndpoint) {
            ICordEndpoint firstCordPoint = (ICordEndpoint)firstPoint;
            class_1269 result = CordItem.connect(firstCordPoint, endpoint, context);
            stack.method_7980(null);
            return result;
        }
        IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_failed", new Object[0]).style(class_124.field_1061).component());
        stack.method_7980(null);
        return class_1269.field_5814;
    }

    @Override
    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_2680 state = context.method_8045().method_8320(context.method_8037());
        IElectric electric = IElectric.getAt(context.method_8045(), context.method_8037());
        if (electric != null) {
            class_1799 stack = context.method_8041();
            class_2338 pos = context.method_8037();
            int terminal = electric.terminalIndexAt(state, context.method_17698().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
            if (terminal >= 0) {
                if (stack.method_7985() && stack.method_7969().method_10545("Half")) {
                    IWireEndpoint endpointHalf = WireEndpointType.deserialize(stack.method_7941("Half"));
                    if (!(endpointHalf instanceof BlockWireEndpoint)) {
                        return class_1269.field_5814;
                    }
                    BlockWireEndpoint bwe = (BlockWireEndpoint)endpointHalf;
                    BlockWireEndpoint endpoint2 = new BlockWireEndpoint(pos, terminal);
                    class_243 p1 = endpointHalf.getExactPosition(context.method_8045());
                    class_243 p2 = endpoint2.getExactPosition(context.method_8045());
                    if (p1.method_1025(p2) > 4.0) {
                        IElectric.sendMessage(context, (class_2561)Lang.translate("message.split_cord_too_far", new Object[0]).style(class_124.field_1061).component());
                        return class_1269.field_5814;
                    }
                    SplitCordEndpoint splitEndpoint = new SplitCordEndpoint(bwe, endpoint2);
                    return CordItem.addEndpoint(context, splitEndpoint);
                }
                BlockWireEndpoint endpoint = new BlockWireEndpoint(pos, terminal);
                class_2487 tag = endpoint.serialize();
                stack.method_7948().method_10566("Half", (class_2520)tag);
                IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_next", new Object[0]).style(class_124.field_1080).component());
                return class_1269.field_5812;
            }
        }
        for (ICordPlacementHandler handler : PLACEMENT_HANDLERS) {
            class_1271<ICordEndpoint> result = handler.place(state, context);
            if (result.method_5467() == class_1269.field_5811) continue;
            if (result.method_5467().method_23665()) {
                return CordItem.addEndpoint(context, (ICordEndpoint)result.method_5466());
            }
            return result.method_5467();
        }
        return class_1269.field_5811;
    }

    static {
        PLACEMENT_HANDLERS.add(new ISocketElectric.Handler());
        PLACEMENT_HANDLERS.add(new IAcceptCord.Handler());
    }
}

