/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire.powercord;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ISocketElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.powercord.CordEntity;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;

public class SocketEndpoint
implements ICordEndpoint {
    private class_2338 pos;

    public SocketEndpoint() {
        this(null);
    }

    public SocketEndpoint(class_2338 pos) {
        this.pos = pos;
    }

    @Override
    public IWireEndpoint makeOffset(class_2338 offset) {
        return new SocketEndpoint(this.pos.method_10081((class_2382)offset));
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.SOCKET;
    }

    @Nullable
    public ISocketElectric getSocketBlock(class_1937 world) {
        if (!world.method_8393(class_4076.method_18675((int)this.pos.method_10263()), class_4076.method_18675((int)this.pos.method_10260()))) {
            return null;
        }
        return ISocketElectric.getAt(world, this.pos);
    }

    @Nullable
    public ElectricBehaviour getElectricBehaviour(class_1937 world) {
        if (!world.method_8393(class_4076.method_18675((int)this.pos.method_10263()), class_4076.method_18675((int)this.pos.method_10260()))) {
            return null;
        }
        return (ElectricBehaviour)BlockEntityBehaviour.get((class_1922)world, (class_2338)this.pos, ElectricBehaviour.TYPE);
    }

    @NotNull
    public class_2350 getFacing(class_1937 world) {
        class_2680 state = world.method_8320(this.pos);
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            return (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        }
        return class_2350.field_11043;
    }

    @Override
    public void read(class_2487 nbt) {
        this.pos = class_2512.method_10691((class_2487)nbt.method_10562("Pos"));
    }

    @Override
    public void write(class_2487 nbt) {
        nbt.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)this.pos));
    }

    @Override
    @NotNull
    public class_243 getExactPosition(class_1937 world) {
        ISocketElectric socketed = this.getSocketBlock(world);
        if (socketed == null) {
            return class_243.method_24953((class_2382)this.pos);
        }
        ITerminalPlacement placement = socketed.socket(world.method_8320(this.pos));
        class_243 origin = placement.getOrigin();
        return new class_243((double)this.pos.method_10263() + origin.field_1352, (double)this.pos.method_10264() + origin.field_1351, (double)this.pos.method_10260() + origin.field_1350).method_43206(this.getFacing(world), -0.1875);
    }

    @Override
    public BlockWireEndpoint getEndpoint1() {
        return new BlockWireEndpoint(this.pos, 0);
    }

    @Override
    public BlockWireEndpoint getEndpoint2() {
        return new BlockWireEndpoint(this.pos, 1);
    }

    @Override
    public boolean isValid(class_1937 world) {
        if (!world.method_8393(class_4076.method_18675((int)this.pos.method_10263()), class_4076.method_18675((int)this.pos.method_10260()))) {
            return false;
        }
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            return false;
        }
        return behaviour.hasTerminal(0) && behaviour.hasTerminal(1);
    }

    public class_2338 getPosition() {
        return this.pos;
    }

    public boolean hasConnection(class_1937 world) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            return false;
        }
        Set<BaseWireEntity> connections1 = behaviour.getConnections().get(this.getEndpoint1());
        Set<BaseWireEntity> connections2 = behaviour.getConnections().get(this.getEndpoint2());
        if (connections1 == null || connections2 == null) {
            return false;
        }
        for (BaseWireEntity wire : connections2) {
            if (!(wire instanceof CordEntity) || !connections1.contains(wire) || !this.equals(wire.getEndpoint1()) && !this.equals(wire.getEndpoint2())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SocketEndpoint) {
            SocketEndpoint other = (SocketEndpoint)obj;
            return Objects.equals(this.pos, other.pos);
        }
        return false;
    }
}

