/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.thermometer;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.equipment.thermometer.ThermometerBlock;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class ThermometerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public float maxState;
    public float maxTemperature;
    public float dialTarget;
    public float prevDialState;
    public float dialState;
    public int redstoneOutput;

    public ThermometerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    private float temperature() {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)ThermometerBlock.FACING);
        ThermalBehaviour thermal = (ThermalBehaviour)BlockEntityBehaviour.get((class_1922)this.field_11863, (class_2338)this.field_11867.method_10093(facing), ThermalBehaviour.TYPE);
        if (thermal != null) {
            return thermal.getTemperature();
        }
        return 22.0f;
    }

    public void tick() {
        super.tick();
        float temperature = this.temperature();
        if (temperature > this.maxTemperature) {
            this.maxTemperature = temperature;
        }
        this.dialTarget = class_3532.method_15363((float)((temperature - 22.0f) / 153.0f), (float)0.0f, (float)1.125f);
        if (!Float.isNaN(this.dialTarget)) {
            int newOutput;
            this.prevDialState = this.dialState;
            this.dialState += (this.dialTarget - this.dialState) * 0.125f;
            if (this.dialState > 1.0f && this.field_11863.field_9229.method_43057() < 0.5f) {
                this.dialState -= (this.dialState - 1.0f) * this.field_11863.field_9229.method_43057();
            }
            if (this.maxState < this.dialState) {
                this.maxState = this.dialState;
                this.method_5431();
            }
            if ((newOutput = class_3532.method_15375((float)class_3532.method_15363((float)(this.dialTarget * 15.0f), (float)0.0f, (float)15.0f))) != this.redstoneOutput) {
                this.redstoneOutput = newOutput;
                this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
            }
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void resetMax() {
        this.maxState = this.dialState;
        this.maxTemperature = this.temperature();
        this.method_5431();
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10548("Max", this.maxTemperature);
        tag.method_10548("MaxState", this.maxState);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.maxTemperature = tag.method_10583("Max");
        this.maxState = tag.method_10583("MaxState");
    }

    private class_124 color(float temperature) {
        class_124 color = class_124.field_1060;
        if (temperature > 150.0f) {
            color = class_124.field_1061;
        } else if (temperature > 125.0f) {
            color = class_124.field_1054;
        }
        return color;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"gui.gauge.info_header", (Object[])new Object[0]).forGoggles(tooltip);
        Lang.translate("gui.thermometer.title", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        float temperature = this.temperature();
        LangBuilder temperatureText = Lang.numberConstant(temperature);
        if (temperature > 175.0f) {
            temperatureText = Lang.text(">175.0");
        }
        temperatureText.add(class_2561.method_43470((String)" ")).add(Unit.TEMPERATURE.get()).style(this.color(temperature)).forGoggles(tooltip);
        Lang.translate("gui.thermometer.max_title", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        LangBuilder maxTemperatureText = Lang.numberConstant(this.maxTemperature);
        if (this.maxTemperature > 175.0f) {
            maxTemperatureText = Lang.text(">175.0");
        }
        maxTemperatureText.add(class_2561.method_43470((String)" ")).add(Unit.TEMPERATURE.get()).style(this.color(this.maxTemperature)).forGoggles(tooltip);
        Lang.translate("gui.thermometer.click", new Object[0]).style(class_124.field_1063).forGoggles(tooltip);
        return true;
    }
}

