/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.thunder;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.apache.commons.lang3.mutable.MutableObject;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.config.CKinetics;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.particles.ZapParticleData;
import org.patryk3211.powergrid.mixin.LightningAccessor;
import org.patryk3211.powergrid.network.packets.LightningSyncS2CPacket;

public class LightningRodMovementBehaviour
implements MovementBehaviour {
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && context.contraption instanceof BearingContraption;
    }

    protected void fire(MovementContext context) {
        LightningRodMovementBehaviour.spawnLightning((class_3218)context.world, context.position);
        class_1538 lightningEntity = (class_1538)class_1299.field_6112.method_5883(context.world);
        if (lightningEntity != null) {
            lightningEntity.method_29495(class_243.method_24955((class_2382)class_2338.method_49638((class_2374)context.position)));
            lightningEntity.method_29498(false);
            ((class_3218)context.world).method_30736((class_1297)lightningEntity);
        }
        ModdedPackets.sendToClientsTracking(new LightningSyncS2CPacket(context), (class_1297)context.contraption.entity);
    }

    public void pickController(MovementContext context) {
        ArrayList<MovementContext> actors = new ArrayList<MovementContext>();
        MutableObject fastestActor = new MutableObject();
        context.contraption.forEachActor(context.world, (behaviour, innerContext) -> {
            if (behaviour instanceof LightningRodMovementBehaviour) {
                actors.add((MovementContext)innerContext);
                if (fastestActor.getValue() == null) {
                    fastestActor.setValue(innerContext);
                } else {
                    double maxSpeed = ((MovementContext)fastestActor.getValue()).motion.method_1033();
                    double thisSpeed = innerContext.motion.method_1033();
                    if (thisSpeed > maxSpeed) {
                        fastestActor.setValue(innerContext);
                    }
                }
            }
        });
        if (fastestActor.getValue() != context.temporaryData) {
            actors.forEach(actor -> {
                actor.temporaryData = fastestActor.getValue();
            });
        }
    }

    private static void spawnLightning(class_3218 world, class_243 pos) {
        class_1538 lightningEntity;
        class_2338 blockPos = ((LightningAccessor)world).invokeGetLightningPos(class_2338.method_49638((class_2374)pos));
        if (world.method_8520(blockPos) && (lightningEntity = (class_1538)class_1299.field_6112.method_5883((class_1937)world)) != null) {
            lightningEntity.method_29495(class_243.method_24955((class_2382)blockPos));
            lightningEntity.method_29498(false);
            world.method_30736((class_1297)lightningEntity);
        }
    }

    public void fireClient(MovementContext context) {
        context.contraption.forEachActor(context.world, (behaviour, innerContext) -> {
            class_243 pos = innerContext.position;
            class_2350 facing = (class_2350)innerContext.state.method_11654((class_2769)class_2741.field_12525);
            SparkParticleData.explodeParticles(innerContext.world, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350, facing, 20);
        });
    }

    public void tick(MovementContext context) {
        this.pickController(context);
        boolean isController = context.temporaryData == context;
        float charge = isController ? context.data.method_10583("Charge") : ((MovementContext)context.temporaryData).data.method_10583("Charge");
        BearingContraption bearing = (BearingContraption)context.contraption;
        double speed = context.motion.method_1033();
        int sails = bearing.getSailBlocks();
        CKinetics configs = ModdedConfigs.server().kinetics;
        float speedFactor = (float)Math.min(speed * (double)configs.lightningAttractorSpeedFactor.getF(), 1.0);
        float sailFactor = Math.min((float)sails * configs.lightningAttractorSailFactor.getF(), 1.0f);
        class_2350 facing = (class_2350)context.state.method_11654((class_2769)class_2741.field_12525);
        class_243 facingVec = class_243.method_24954((class_2382)facing.method_10163());
        if (isController) {
            if (context.world.method_8546() && speed > 1.5) {
                if ((charge += speedFactor * sailFactor * configs.lightningAttractorMaxFrequency.getF()) >= 1.0f) {
                    charge = 0.0f;
                    if (!context.world.field_9236) {
                        this.fire(context);
                    } else {
                        charge = 1.0f;
                    }
                }
            } else if (charge > 0.0f && (charge -= 0.05f) < 0.0f) {
                charge = 0.0f;
            }
        }
        if (context.world.field_9236) {
            float chance;
            class_5819 r = context.world.field_9229;
            class_243 pos1 = context.position;
            class_243 vel1 = facingVec.method_1036(context.motion);
            for (chance = r.method_43057() * charge * 8.0f; r.method_43057() < chance; chance -= 1.0f) {
                class_243 vel = vel1.method_1021((double)((r.method_43057() - 0.5f) * 3.0f)).method_49272(r, 2.0f);
                class_243 pos = pos1.method_49272(r, 2.0f);
                context.world.method_8406((class_2394)class_2398.field_29644, pos.field_1352, pos.field_1351, pos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
            }
            for (chance = r.method_43057() * charge * 0.1f; r.method_43057() < chance; chance -= 1.0f) {
                class_243 dir = pos1.method_49272(r, 8.0f);
                context.world.method_8406((class_2394)new ZapParticleData(dir.field_1352, dir.field_1351, dir.field_1350, false).withLife(0), pos1.field_1352, pos1.field_1351, pos1.field_1350, 0.0, 0.0, 0.0);
            }
        }
        context.data.method_10548("Charge", charge);
    }

    public void writeExtraData(MovementContext context) {
        super.writeExtraData(context);
    }
}

