/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.base;

import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.patryk3211.powergrid.kinetics.base.ElectricKineticBlockEntity;

public abstract class GeneratorBlockEntity
extends ElectricKineticBlockEntity {
    private static final float TIME_STEP = 0.05f;
    private final float windingResistance;
    private final float armatureInertia;
    private final float coilConstant;

    public GeneratorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state, float windingResistance, float armatureInertia, float coilConstant) {
        super(typeIn, pos, state);
        this.windingResistance = windingResistance;
        this.armatureInertia = armatureInertia;
        this.coilConstant = coilConstant;
    }

    public abstract float windingCurrent();

    public abstract float fieldStrength();

    public abstract void updateVoltage(float var1);

    public float emfVoltage() {
        return -this.speed * this.fieldStrength() * this.coilConstant;
    }

    public void tick() {
        super.tick();
        float current = this.windingCurrent();
        float torque = this.coilConstant * this.fieldStrength() * current;
        this.speed += torque / this.armatureInertia * 0.05f;
        this.updateVoltage(this.emfVoltage());
    }
}

