/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.rotor;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.base.SegmentedBehaviour;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedTags;
import org.patryk3211.powergrid.electricity.sim.special.IRotor;
import org.patryk3211.powergrid.kinetics.generator.IRotorAssemblyPart;
import org.patryk3211.powergrid.kinetics.generator.rotor.AbstractRotorBlock;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorSoundInstance;

public class RotorBehaviour
extends SegmentedBehaviour<RotorBehaviour>
implements IRotor {
    public static final BehaviourType<RotorBehaviour> TYPE = new BehaviourType("generator_rotor");
    private static final int OVERSPEED_TICKS = 5;
    protected float totalForce = 0.0f;
    public float prevForce = 0.0f;
    protected float angularVelocity = 0.0f;
    private final float individualInertia;
    private float inertia = 0.0f;
    private int segmentCount = 0;
    private float oldAngVel = 0.0f;
    private float angle = 0.0f;
    private int overspeedTicks = 0;
    private boolean hasSoundSource = false;
    private IForceSource forceSupplier = null;
    public float power;

    public RotorBehaviour(SmartBlockEntity be, float inertia) {
        super(be, (Integer)ModdedConfigs.server().kinetics.generatorControls.rotorAssemblyMaxSize.get(), segment -> !segment.blockEntity.method_11010().method_26164(ModdedTags.Block.IGNORE_IN_ROTOR_ASSEMBLY_SIZE.tag));
        this.individualInertia = inertia;
        this.setLazyTickRate(100);
    }

    public void forceSource(IForceSource availableForce) {
        this.forceSupplier = availableForce;
    }

    @Override
    protected List<RotorBehaviour> getConnected() {
        class_1937 world = this.getWorld();
        assert (world != null);
        class_2680 state = this.blockEntity.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof IRotorAssemblyPart)) {
            return List.of();
        }
        IRotorAssemblyPart assembly = (IRotorAssemblyPart)class_22482;
        class_2338 pos = this.getPos();
        ArrayList<class_2350> checkDirs = new ArrayList<class_2350>();
        for (class_2350 dir : class_2350.values()) {
            if (!assembly.canConnect(state, dir)) continue;
            checkDirs.add(dir);
        }
        LinkedList<RotorBehaviour> entities = new LinkedList<RotorBehaviour>();
        for (class_2350 dir : checkDirs) {
            IRotorAssemblyPart assemblyPart;
            class_2680 otherState;
            class_2248 class_22483;
            RotorBehaviour rotor = (RotorBehaviour)RotorBehaviour.get((class_1922)world, (class_2338)pos.method_10093(dir), this.getType());
            if (rotor == null || !((class_22483 = (otherState = rotor.blockEntity.method_11010()).method_26204()) instanceof IRotorAssemblyPart) || !(assemblyPart = (IRotorAssemblyPart)class_22483).canConnect(otherState, dir.method_10153())) continue;
            entities.add(rotor);
        }
        return entities;
    }

    @Override
    public BehaviourType<RotorBehaviour> getType() {
        return TYPE;
    }

    @Nullable
    public class_2350.class_2351 getAxis() {
        class_2680 state = this.blockEntity.method_11010();
        if (state.method_28498(AbstractRotorBlock.AXIS)) {
            return (class_2350.class_2351)state.method_11654(AbstractRotorBlock.AXIS);
        }
        return null;
    }

    @Override
    protected void makeController() {
        super.makeController();
        this.inertia = this.individualInertia;
        this.segmentCount = 1;
        this.oldAngVel = 0.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        if (!this.isController()) {
            return;
        }
        if (!this.hasSoundSource && Math.abs(this.angularVelocity) > 32.0f) {
            class_310.method_1551().method_1483().method_4873((class_1113)new RotorSoundInstance(this));
            this.hasSoundSource = true;
        } else if (this.hasSoundSource && Math.abs(this.angularVelocity) < 32.0f) {
            this.hasSoundSource = false;
        }
    }

    @Override
    public void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.method_10545("AngularVelocity")) {
            this.angularVelocity = compound.method_10583("AngularVelocity");
            if (Float.isNaN(this.angularVelocity)) {
                this.angularVelocity = 0.0f;
            }
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10548("AngularVelocity", this.angularVelocity);
    }

    @Override
    public void segmentAdded(RotorBehaviour segment) {
        super.segmentAdded(segment);
        float momentum = this.angularVelocity * this.inertia + segment.angularVelocity * segment.individualInertia;
        this.inertia += segment.individualInertia;
        this.angularVelocity = momentum / this.inertia;
        ++this.segmentCount;
    }

    @Override
    public void segmentRemoved(RotorBehaviour segment) {
        super.segmentRemoved(segment);
        this.inertia -= segment.individualInertia;
        --this.segmentCount;
    }

    @Override
    public void applyTickForce(float force) {
        RotorBehaviour controller = (RotorBehaviour)this.getControllerOrThis();
        if (controller.inertia <= 0.0f) {
            return;
        }
        if (Math.abs(force) > 0.001f) {
            controller.totalForce += force;
        }
    }

    public float limitForce(float forceIn) {
        RotorBehaviour controller = (RotorBehaviour)this.getControllerOrThis();
        if (forceIn > 0.0f && controller.angularVelocity > 0.0f || forceIn < 0.0f && controller.angularVelocity < 0.0f) {
            return forceIn;
        }
        float maxForce = controller.angularVelocity * 20.0f * controller.inertia;
        return Math.signum(forceIn) * Math.min(Math.abs(forceIn), Math.abs(maxForce));
    }

    @Override
    public float getAngularVelocity() {
        RotorBehaviour controller = (RotorBehaviour)this.getControllerOrThis();
        return controller.angularVelocity;
    }

    @Override
    public float getInertia() {
        RotorBehaviour controller = (RotorBehaviour)this.getControllerOrThis();
        return controller.inertia;
    }

    public float getAngle() {
        RotorBehaviour controller = (RotorBehaviour)this.getControllerOrThis();
        return controller.angle;
    }

    public static int getMaxRotationSpeed() {
        return (Integer)ModdedConfigs.server().kinetics.generatorControls.rotorRPMMax.get();
    }

    public static float getRotorKp() {
        return ModdedConfigs.server().kinetics.generatorControls.rotorKp.getF();
    }

    public static float getRotorKd() {
        return ModdedConfigs.server().kinetics.generatorControls.rotorKd.getF();
    }

    public void setOldAngVel(float value) {
        this.oldAngVel = value;
        this.blockEntity.method_5431();
    }

    public float getOldAngVel() {
        RotorBehaviour controller = (RotorBehaviour)this.getControllerOrThis();
        return controller.oldAngVel;
    }

    public void lazyTick() {
        super.lazyTick();
        this.blockEntity.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isController()) {
            float oldAV = this.getOldAngVel();
            float velocity = this.getAngularVelocity();
            float friction = Math.abs(velocity * 20.0f * this.inertia);
            friction = Math.min(friction, (float)this.segmentCount * ModdedConfigs.server().kinetics.generatorControls.rotorSegmentFriction.getF());
            this.totalForce -= Math.signum(velocity) * friction;
            this.angularVelocity += this.totalForce / 20.0f / this.inertia;
            if ((double)Math.abs(this.angularVelocity) < 0.01 || Float.isNaN(this.angularVelocity)) {
                this.angularVelocity = 0.0f;
            }
            this.forEachSegment(segment -> {
                if (segment.forceSupplier != null) {
                    float target = segment.forceSupplier.forceSpeed();
                    float Kp = RotorBehaviour.getRotorKp();
                    float Kd = RotorBehaviour.getRotorKd();
                    float deltaT = target - this.angularVelocity;
                    if (target < 0.0f) {
                        deltaT = -deltaT;
                    }
                    deltaT = Math.max(0.0f, deltaT);
                    float deltaAV = oldAV - this.angularVelocity;
                    float maxForce = segment.forceSupplier.sourceForce(this.angularVelocity);
                    float force = (Kp * deltaT + Kd * deltaAV) * 20.0f * this.inertia;
                    force = Math.min(Math.abs(force), maxForce) * Math.signum(target);
                    this.angularVelocity += force / 20.0f / this.inertia;
                    segment.forceSupplier.receiveUsedForce(Math.abs(force / maxForce));
                    this.totalForce += force;
                    this.power = force * this.getAngularVelocityRadians();
                }
            });
            this.prevForce = this.totalForce;
            this.totalForce = 0.0f;
            if (!this.getWorld().field_9236) {
                int Vmax;
                float V = Math.abs(this.angularVelocity);
                if (V > (float)(Vmax = RotorBehaviour.getMaxRotationSpeed())) {
                    if (this.overspeedTicks++ >= 5) {
                        this.getWorld().method_22352(this.getPos(), false);
                        this.checkConnectivity(this);
                    } else {
                        this.angularVelocity = (float)Vmax * Math.signum(this.angularVelocity);
                        this.blockEntity.sendData();
                    }
                } else if (V <= (float)Vmax) {
                    this.overspeedTicks = 0;
                }
            }
            this.angle = (this.angle + velocity * 0.3f) % 360.0f;
            if (Float.isNaN(this.angle)) {
                this.angle = 0.0f;
            }
            if (this.getWorld() != null && this.getWorld().field_9236) {
                this.tickAudio();
            }
            this.setOldAngVel(this.angularVelocity);
        } else {
            this.angularVelocity = this.getAngularVelocity();
            this.angle = this.getAngle();
        }
        this.blockEntity.method_5431();
    }

    public static interface IForceSource {
        public float sourceForce(float var1);

        public float forceSpeed();

        default public void receiveUsedForce(float percent) {
        }
    }
}

