/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.mixin;

import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AirCurrent.class}, remap=false)
public abstract class AirCurrentMixin {
    @Shadow
    @Final
    public IAirCurrentSource source;
    @Shadow
    public class_2350 direction;
    @Unique
    private final List<ThermalBehaviour> powerGrid$affectedThermals = new ArrayList<ThermalBehaviour>();
    @Unique
    private final List<CircuitBoardBlockEntity> powerGrid$affectedCircuits = new ArrayList<CircuitBoardBlockEntity>();

    @Shadow
    protected abstract int getLimit();

    @Inject(method={"rebuild()V"}, at={@At(value="HEAD")})
    private void powerGrid$rebuildHead(CallbackInfo ci) {
        this.powerGrid$affectedThermals.forEach(ThermalBehaviour::noCooling);
        this.powerGrid$affectedThermals.clear();
        this.powerGrid$affectedCircuits.forEach(CircuitBoardBlockEntity::noCooling);
        this.powerGrid$affectedCircuits.clear();
    }

    @Inject(method={"rebuild()V"}, at={@At(value="TAIL")})
    private void powerGrid$rebuildTail(CallbackInfo ci) {
        class_1937 world = this.source.getAirCurrentWorld();
        class_2338 start = this.source.getAirCurrentPos();
        int limit = this.getLimit();
        float initialStrength = Math.abs(this.source.getSpeed()) * ModdedConfigs.server().kinetics.encasedFanCoolingStrength.getF();
        if (initialStrength == 0.0f) {
            return;
        }
        for (int i = 1; i <= limit; ++i) {
            class_2586 class_25862;
            class_2338 pos = start.method_10079(this.direction, i);
            ThermalBehaviour thermal = (ThermalBehaviour)BlockEntityBehaviour.get((class_1922)world, (class_2338)pos, ThermalBehaviour.TYPE);
            float factor = 1.0f - (float)(i - 1) / (float)limit;
            if (thermal != null) {
                thermal.setCoolingMultiplier((AirCurrent)this, factor * initialStrength + 1.0f);
                this.powerGrid$affectedThermals.add(thermal);
            }
            if (!((class_25862 = world.method_8321(pos)) instanceof CircuitBoardBlockEntity)) continue;
            CircuitBoardBlockEntity circuit = (CircuitBoardBlockEntity)class_25862;
            circuit.setCoolingMultiplier((AirCurrent)this, factor * initialStrength + 1.0f);
            this.powerGrid$affectedCircuits.add(circuit);
        }
    }
}

