/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntityEndpoint;
import org.patryk3211.powergrid.electricity.wire.DeferredJunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.network.SimplePacket;

public class BlockWireAttachC2SPacket
implements SimplePacket {
    public final int entityId;
    public final int index;
    public final int gridPoint;

    public BlockWireAttachC2SPacket(BlockWireEntity entity, int index, int gridPoint) {
        this.entityId = entity.method_5628();
        this.index = index;
        this.gridPoint = gridPoint;
    }

    public BlockWireAttachC2SPacket(class_2540 buf) {
        this.entityId = buf.readInt();
        this.index = buf.readInt();
        this.gridPoint = buf.readInt();
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.index);
        buf.writeInt(this.gridPoint);
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            class_1271<BlockWireEntity> result;
            IWireEndpoint endpoint;
            class_1657 player = ctx.getPlayer();
            class_1297 entity = player.method_37908().method_8469(this.entityId);
            if (!(entity instanceof BlockWireEntity)) {
                PowerGrid.LOGGER.error("Received block wire attach packet with invalid entity");
                return;
            }
            BlockWireEntity wire = (BlockWireEntity)entity;
            class_1799 stack = player.method_5998(class_1268.field_5808);
            if (!(stack.method_7909() instanceof WireItem)) {
                PowerGrid.LOGGER.error("Received wire attach packet for player whose not holding a wire");
                return;
            }
            if (this.index < 0 || this.index >= wire.segments.size()) {
                PowerGrid.LOGGER.error("Received wire segment index out of bounds");
                return;
            }
            BlockWireEntity.Point segment = wire.segments.get(this.index);
            int gridLength = segment.gridLength;
            if (this.gridPoint < 0 || this.gridPoint > gridLength) {
                PowerGrid.LOGGER.error("Received wire segment length out of bounds");
                return;
            }
            IWireEndpoint existingEndpoint = WireEndpointType.deserialize(stack.method_7969());
            if (this.gridPoint <= 1 && this.index == 0) {
                if (wire.getEndpoint1() == null) {
                    wire = wire.flip();
                    endpoint = new BlockWireEntityEndpoint(wire, true);
                } else {
                    endpoint = wire.getEndpoint1();
                }
            } else {
                endpoint = this.gridPoint >= segment.gridLength - 1 && this.index == wire.segments.size() - 1 ? (wire.getEndpoint2() == null ? new BlockWireEntityEndpoint(wire, true) : wire.getEndpoint2()) : new DeferredJunctionWireEndpoint(wire, this.index, this.gridPoint);
            }
            if (endpoint != null && existingEndpoint == null) {
                stack.method_7980(endpoint.serialize());
            } else if (endpoint != null && (result = WireItem.connect(player.method_37908(), stack, player, existingEndpoint, endpoint)).method_5467().method_23665()) {
                stack.method_7980(null);
            }
        });
    }
}

