/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.network.SimplePacket;

public class BlockWireCutC2SPacket
implements SimplePacket {
    public final int entityId;
    public final int index1;
    public final int point1;
    public final int index2;
    public final int point2;

    public BlockWireCutC2SPacket(class_2540 buf) {
        this.entityId = buf.readInt();
        this.index1 = buf.readInt();
        this.point1 = buf.readInt();
        this.index2 = buf.readInt();
        this.point2 = buf.readInt();
    }

    public BlockWireCutC2SPacket(BlockWireEntity entity, int index1, int point1, int index2, int point2) {
        this.entityId = entity.method_5628();
        if (index2 < index1) {
            this.index1 = index2;
            this.point1 = point2;
            this.index2 = index1;
            this.point2 = point1;
        } else {
            this.index1 = index1;
            this.index2 = index2;
            if (index1 == index2 && point2 < point1) {
                this.point1 = point2;
                this.point2 = point1;
            } else {
                this.point1 = point1;
                this.point2 = point2;
            }
        }
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.index1);
        buf.writeInt(this.point1);
        buf.writeInt(this.index2);
        buf.writeInt(this.point2);
    }

    private static BlockWireEntity spawnWire2(BlockWireEntity wire1, class_243 start, int wireCount, List<BlockWireEntity.Point> segments) {
        if (start == null || segments.isEmpty()) {
            return null;
        }
        BlockWireEntity entity = BlockWireEntity.create(wire1.method_37908(), start, new class_1799((class_1935)wire1.getWireItem(), wireCount), segments);
        ((class_3218)wire1.method_37908()).method_30771((class_1297)entity);
        entity.setEndpoint2(wire1.getEndpoint2());
        wire1.setEndpoint2(null);
        return entity;
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            class_1297 entity = ctx.getPlayer().method_37908().method_8469(this.entityId);
            if (!(entity instanceof BlockWireEntity)) {
                PowerGrid.LOGGER.error("Received block wire cut packet with invalid entity");
                return;
            }
            BlockWireEntity wire = (BlockWireEntity)entity;
            int wireCount = wire.getWireCount();
            int gridLength2 = 0;
            ArrayList<BlockWireEntity.Point> secondSegments = new ArrayList<BlockWireEntity.Point>();
            class_243 secondStart = null;
            for (int i = this.index2; i < wire.segments.size(); ++i) {
                BlockWireEntity.Point segment = wire.segments.get(i);
                if (i == this.index2) {
                    secondStart = segment.start.method_43206(segment.direction, (double)((float)this.point2 / 16.0f));
                    int len = segment.gridLength - this.point2;
                    if (len <= 0) continue;
                    secondSegments.add(new BlockWireEntity.Point(segment.direction, len));
                    gridLength2 += len;
                    continue;
                }
                secondSegments.add(new BlockWireEntity.Point(segment.direction, segment.gridLength));
                gridLength2 += segment.gridLength;
            }
            int wire2Count = (int)Math.ceil((float)gridLength2 / 16.0f);
            while (wire.segments.size() > this.index1 + 1) {
                wire.segments.remove(wire.segments.size() - 1);
            }
            BlockWireEntity.Point last = wire.segments.remove(wire.segments.size() - 1);
            wire.segments.add(new BlockWireEntity.Point(last.direction, Math.min(last.gridLength, this.point1)));
            int gridLength1 = 0;
            for (BlockWireEntity.Point segment : wire.segments) {
                gridLength1 += segment.gridLength;
            }
            int wire1Count = (int)Math.ceil((float)gridLength1 / 16.0f);
            if (wire1Count >= wire2Count) {
                if (gridLength1 < 3) {
                    wire.method_31472();
                } else {
                    wire.setItem(wire.getWireItem(), Math.min(wireCount, wire1Count));
                    if ((wireCount -= wire1Count) <= 0) {
                        wire.setEndpoint2(null);
                    } else {
                        wire2 = BlockWireCutC2SPacket.spawnWire2(wire, secondStart, Math.min(wire2Count, wireCount), secondSegments);
                        wireCount -= wire2Count;
                    }
                }
            } else if (gridLength2 < 3) {
                wire.method_31472();
            } else {
                wire2 = BlockWireCutC2SPacket.spawnWire2(wire, secondStart, Math.min(wireCount, wire2Count), secondSegments);
                if ((wireCount -= wire2Count) <= 0) {
                    wire.method_31472();
                } else {
                    wire.setItem(wire.getWireItem(), Math.min(wire1Count, wireCount));
                    wireCount -= wire1Count;
                }
            }
            if (wireCount > 0) {
                class_1657 cutter = ctx.getPlayer();
                while (wireCount > 0) {
                    cutter.method_31548().method_7398(new class_1799((class_1935)wire.getWireItem(), Math.min(wireCount, 64)));
                    wireCount -= 64;
                }
            }
            if (!wire.method_31481()) {
                wire.bakeBoundingBoxes();
                wire.sendExtraData();
            }
        });
    }
}

