/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class EntityDataS2CPacket
implements SimplePacket {
    private static final Map<Integer, class_2487> DEFERRED_DATA = new HashMap<Integer, class_2487>();
    public final int entityId;
    public final class_2487 data;

    public EntityDataS2CPacket(class_1297 entity, class_2487 data) {
        this.entityId = entity.method_5628();
        this.data = data;
    }

    public EntityDataS2CPacket(class_2540 buffer) {
        this.entityId = buffer.readInt();
        this.data = buffer.method_10798();
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.method_10794(this.data);
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            class_1937 world = ClientSideAccess.world();
            class_1297 entity = world.method_8469(this.entityId);
            if (entity == null) {
                DEFERRED_DATA.put(this.entityId, this.data);
                return;
            }
            if (entity instanceof IConsumer) {
                IConsumer consumer = (IConsumer)entity;
                consumer.onEntityDataPacket(this.data);
            }
        });
    }

    public static void clientEntityAdded(class_1297 entity) {
        class_2487 tag = DEFERRED_DATA.remove(entity.method_5628());
        if (tag == null) {
            return;
        }
        if (entity instanceof IConsumer) {
            IConsumer consumer = (IConsumer)entity;
            consumer.onEntityDataPacket(tag);
        }
    }

    public static interface IConsumer {
        public void onEntityDataPacket(class_2487 var1);
    }
}

