/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import org.patryk3211.powergrid.electricity.ClientElectricNetwork;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.network.SimplePacket;

public class TransmissionLineStateS2CPacket
implements SimplePacket {
    public final int lineId;
    public final IWireEndpoint endpoint1;
    public final IWireEndpoint endpoint2;
    public final float lineResistance;
    public final float node1Voltage;
    public final float node2Voltage;

    public TransmissionLineStateS2CPacket(TransmissionLine line) {
        this.lineId = line.getId();
        this.endpoint1 = line.getNode1().endpoint;
        this.endpoint2 = line.getNode2().endpoint;
        this.lineResistance = (float)line.getResistance();
        this.node1Voltage = line.getNode1().getVoltage();
        this.node2Voltage = line.getNode2().getVoltage();
    }

    public TransmissionLineStateS2CPacket(class_2540 buf) {
        this.lineId = buf.readInt();
        this.endpoint1 = WireEndpointType.deserialize(buf.method_10798());
        this.endpoint2 = WireEndpointType.deserialize(buf.method_10798());
        this.lineResistance = buf.readFloat();
        this.node1Voltage = buf.readFloat();
        this.node2Voltage = buf.readFloat();
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.lineId);
        buf.method_10794(this.endpoint1.serialize());
        buf.method_10794(this.endpoint2.serialize());
        buf.writeFloat(this.lineResistance);
        buf.writeFloat(this.node1Voltage);
        buf.writeFloat(this.node2Voltage);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> ClientElectricNetwork.partialTrackedLine(this));
    }
}

