/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.ponder.scenes;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.Optional;
import java.util.Random;
import java.util.function.UnaryOperator;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.createmod.ponder.foundation.instruction.TickingInstruction;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.basinheater.BasinHeaterBlock;
import org.patryk3211.powergrid.electricity.battery.BatteryBlockEntity;
import org.patryk3211.powergrid.electricity.battery.MultiBlockBatteryEntity;
import org.patryk3211.powergrid.electricity.electromagnet.ElectromagnetBlockEntity;
import org.patryk3211.powergrid.electricity.electromagnet.MagnetizingBehaviour;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerMediumBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerSmallBlock;
import org.patryk3211.powergrid.ponder.base.PowerGridSceneBuilder;

public class DeviceScenes {
    public static void heatingCoilBasic(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("heating_coil_basic", "Warming up the atmosphere");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world().showSection(util.select().fromTo(4, 1, 1, 5, 1, 3), class_2350.field_11036);
        scene.world().showSection(util.select().position(0, 1, 2), class_2350.field_11036);
        scene.world().showSection(util.select().position(5, 1, 2), class_2350.field_11036);
        scene.idle(5);
        class_2338 heatingCoil = util.grid().at(3, 1, 2);
        class_2338 voltageSource = util.grid().at(6, 2, 2);
        scene.world().showSection(util.select().position(4, 2, 1), class_2350.field_11033);
        scene.world().showSection(util.select().position(4, 2, 3), class_2350.field_11033);
        scene.world().showSection(util.select().position(heatingCoil), class_2350.field_11033);
        scene.idle(10);
        scene.electric().connect(util.grid().at(4, 2, 1), 0, heatingCoil, 0);
        scene.electric().connect(util.grid().at(4, 2, 3), 0, heatingCoil, 1);
        scene.electric().connectInvisible(util.grid().at(4, 2, 1), 0, voltageSource, 0);
        scene.electric().connectInvisible(util.grid().at(4, 2, 3), 0, voltageSource, 1);
        scene.idle(5);
        scene.overlay().showText(60).text("The heating coil can be used to heat up the passing Air Flow if enough power is applied to it").attachKeyFrame().pointAt(util.vector().topOf(heatingCoil)).placeNearTarget();
        scene.electric().setSource(voltageSource, 32.0f);
        scene.electric().tickFor(10);
        scene.idle(100);
        scene.overlay().showText(60).text("By applying a bigger voltage the Air Flow can be used for bulk blasting").attachKeyFrame().pointAt(util.vector().topOf(heatingCoil)).placeNearTarget();
        scene.electric().setSource(voltageSource, 38.0f);
        scene.electric().tickFor(10);
        scene.idle(80);
        scene.markAsFinished();
    }

    public static void heatingCoilSpeed(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("heating_coil_speed", "Electrified bulk processing");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world().showSection(util.select().fromTo(0, 1, 4, 3, 1, 5), class_2350.field_11036);
        scene.world().showSection(util.select().fromTo(1, 1, 0, 3, 1, 0), class_2350.field_11036);
        scene.world().showSection(util.select().position(2, 0, 5), class_2350.field_11036);
        scene.idle(5);
        class_2338 heatingCoil = util.grid().at(1, 1, 3);
        class_2338 voltageSource = util.grid().at(2, 1, 6);
        scene.world().showSection(util.select().position(0, 2, 4), class_2350.field_11033);
        scene.world().showSection(util.select().position(2, 2, 4), class_2350.field_11033);
        scene.world().showSection(util.select().position(heatingCoil), class_2350.field_11033);
        scene.idle(10);
        scene.electric().connect(util.grid().at(0, 2, 4), 0, heatingCoil, 1);
        scene.electric().connect(util.grid().at(2, 2, 4), 0, heatingCoil, 0);
        scene.electric().connectInvisible(util.grid().at(0, 2, 4), 0, voltageSource, 0);
        scene.electric().connectInvisible(util.grid().at(2, 2, 4), 0, voltageSource, 1);
        scene.electric().setSource(voltageSource, 32.0f);
        scene.electric().tickFor(10);
        scene.idle(10);
        scene.world().setBlock(util.grid().at(3, 1, 3), class_2246.field_10036.method_9564(), false);
        scene.world().showSection(util.select().position(3, 1, 3), class_2350.field_11039);
        scene.overlay().showText(60).text("The heating coil allows for faster bulk processing").attachKeyFrame().pointAt(util.vector().topOf(heatingCoil)).placeNearTarget();
        scene.idle(20);
        class_1799 stack = new class_1799((class_1935)class_1802.field_8046);
        class_1799 cooked = new class_1799((class_1935)class_1802.field_8176);
        ElementLink heaterEntity = scene.world().createItemEntity(util.vector().centerOf(1, 2, 1), util.vector().of(0.0, 0.1, 0.0), stack);
        ElementLink fireEntity = scene.world().createItemEntity(util.vector().centerOf(3, 2, 1), util.vector().of(0.0, 0.1, 0.0), stack);
        scene.idle(10);
        scene.world().modifyEntity(heaterEntity, e -> e.method_18800(0.0, 0.0, (double)-0.2f));
        scene.world().modifyEntity(fireEntity, e -> e.method_18800(0.0, 0.0, (double)-0.2f));
        class_243 item1Vec = util.vector().blockSurface(util.grid().at(1, 1, 0), class_2350.field_11035).method_1031(0.0, 0.0, 0.1);
        class_243 item2Vec = util.vector().blockSurface(util.grid().at(3, 1, 0), class_2350.field_11035).method_1031(0.0, 0.0, 0.1);
        scene.effects().emitParticles(item1Vec.method_1031(0.0, (double)0.2f, 0.0), scene.effects().simpleParticleEmitter((class_2394)class_2398.field_11237, class_243.field_1353), 1.0f, 60);
        scene.effects().emitParticles(item2Vec.method_1031(0.0, (double)0.2f, 0.0), scene.effects().simpleParticleEmitter((class_2394)class_2398.field_11237, class_243.field_1353), 1.0f, 100);
        scene.idle(60);
        scene.world().modifyEntity(heaterEntity, e -> ((class_1542)e).method_6979(cooked));
        scene.overlay().showControls(item1Vec, Pointing.DOWN, 20).withItem(cooked);
        scene.idle(40);
        scene.world().modifyEntity(fireEntity, e -> ((class_1542)e).method_6979(cooked));
        scene.overlay().showControls(item2Vec, Pointing.DOWN, 20).withItem(cooked);
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void transformerSizes(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("transformer_sizes", "Transformers");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        class_2338 smallTr = util.grid().at(2, 1, 1);
        scene.world().showSection(util.select().position(smallTr), class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(smallTr, class_2350.field_11043), Pointing.RIGHT, 30).withItem(AllItems.WRENCH.asStack());
        scene.idle(20);
        scene.world().setBlock(smallTr, (class_2680)ModdedBlocks.TRANSFORMER_SMALL.getDefaultState().method_11657(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.idle(20);
        class_2338 mediumTr = util.grid().at(2, 1, 3);
        scene.world().showSection(util.select().fromTo(mediumTr, mediumTr.method_10067().method_10084()), class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(mediumTr.method_10084(), class_2350.field_11043), Pointing.RIGHT, 30).withItem(AllItems.WRENCH.asStack());
        scene.idle(20);
        scene.world().setBlock(mediumTr, (class_2680)((class_2680)ModdedBlocks.TRANSFORMER_MEDIUM.getDefaultState().method_11657(TransformerMediumBlock.HORIZONTAL_AXIS, (Comparable)class_2350.class_2351.field_11048)).method_11657((class_2769)TransformerMediumBlock.PART, (Comparable)Integer.valueOf(1)), false);
        scene.world().setBlock(mediumTr.method_10067(), (class_2680)((class_2680)ModdedBlocks.TRANSFORMER_MEDIUM.getDefaultState().method_11657(TransformerMediumBlock.HORIZONTAL_AXIS, (Comparable)class_2350.class_2351.field_11048)).method_11657((class_2769)TransformerMediumBlock.PART, (Comparable)Integer.valueOf(0)), false);
        scene.world().setBlock(mediumTr.method_10084(), (class_2680)((class_2680)ModdedBlocks.TRANSFORMER_MEDIUM.getDefaultState().method_11657(TransformerMediumBlock.HORIZONTAL_AXIS, (Comparable)class_2350.class_2351.field_11048)).method_11657((class_2769)TransformerMediumBlock.PART, (Comparable)Integer.valueOf(3)), false);
        scene.world().setBlock(mediumTr.method_10084().method_10067(), (class_2680)((class_2680)ModdedBlocks.TRANSFORMER_MEDIUM.getDefaultState().method_11657(TransformerMediumBlock.HORIZONTAL_AXIS, (Comparable)class_2350.class_2351.field_11048)).method_11657((class_2769)TransformerMediumBlock.PART, (Comparable)Integer.valueOf(2)), false);
        scene.idle(20);
        scene.overlay().showText(80).text("Transformers come in different sizes, each of them offering different power capabilities and winding capacities").attachKeyFrame().placeNearTarget();
        scene.idle(90);
        scene.markAsFinished();
    }

    public static void transformerWinding(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("transformer_winding", "Winding a transformer");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        class_2338 tr = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().position(tr), class_2350.field_11033);
        scene.idle(15);
        scene.overlay().showText(80).text("To wind a transformer, first select the starting terminal for your winding").attachKeyFrame().placeNearTarget();
        scene.idle(90);
        class_1799 stack = new class_1799(ModdedItems.WIRE, 1);
        scene.overlay().showControls(util.vector().of(2.8, 1.9, 2.0), Pointing.RIGHT, 30).withItem(stack);
        scene.idle(30);
        class_243 side = util.vector().blockSurface(tr, class_2350.field_11043);
        scene.overlay().showText(80).text("Next, click on the transformer body and pick the number of turn you want to add").attachKeyFrame().pointAt(side).placeNearTarget();
        scene.idle(50);
        scene.overlay().showControls(side, Pointing.UP, 30).withItem(stack);
        scene.idle(40);
        scene.overlay().showText(80).text("Lastly, select the end terminal for your winding").attachKeyFrame().placeNearTarget();
        scene.idle(90);
        scene.overlay().showControls(util.vector().of(2.2, 1.9, 2.0), Pointing.LEFT, 30).withItem(stack);
        scene.idle(20);
        scene.world().setBlock(tr, (class_2680)((class_2680)ModdedBlocks.TRANSFORMER_SMALL.getDefaultState().method_11657(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable)class_2350.class_2351.field_11048)).method_11657((class_2769)TransformerSmallBlock.COILS, (Comparable)Integer.valueOf(1)), false);
        scene.idle(10);
        scene.effects().indicateSuccess(tr);
        scene.idle(10);
        scene.overlay().showText(60).text("Repeat for the secondary winding").placeNearTarget();
        scene.idle(50);
        scene.world().setBlock(tr, (class_2680)((class_2680)ModdedBlocks.TRANSFORMER_SMALL.getDefaultState().method_11657(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable)class_2350.class_2351.field_11048)).method_11657((class_2769)TransformerSmallBlock.COILS, (Comparable)Integer.valueOf(2)), false);
        scene.effects().indicateSuccess(tr);
        scene.idle(30);
        scene.overlay().showText(80).text("Your transformer will now transform voltage with the ratio you wound").attachKeyFrame().placeNearTarget();
        scene.idle(90);
        scene.markAsFinished();
    }

    public static void light(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("light", "Lighting up the world with electricity");
        scene.configureBasePlate(0, 0, 5);
        class_2338 light = util.grid().at(2, 2, 2);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 4, 1, 2), class_2350.field_11043);
        scene.idle(5);
        scene.world().showSection(util.select().position(0, 2, 2), class_2350.field_11033);
        scene.world().showSection(util.select().position(4, 2, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(light), class_2350.field_11033);
        scene.idle(5);
        scene.electric().connect(util.grid().at(0, 2, 2), 0, light, 0);
        scene.electric().connect(util.grid().at(4, 2, 2), 0, light, 1);
        scene.idle(15);
        scene.overlay().showText(80).text("When light bulbs are inserted into fixtures and powered on they turn electricity into light").attachKeyFrame().pointAt(util.vector().topOf(light).method_1023(0.0, 0.5, 0.0)).placeNearTarget();
        scene.idle(40);
        scene.world().modifyBlock(light, state -> (class_2680)state.method_11657((class_2769)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(2)), false);
        scene.idle(70);
        scene.overlay().showText(80).text("If the voltage is not high enough, the light bulb will be dimmer").attachKeyFrame().pointAt(util.vector().topOf(light).method_1023(0.0, 0.5, 0.0)).placeNearTarget();
        scene.idle(40);
        scene.world().modifyBlock(light, state -> (class_2680)state.method_11657((class_2769)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(1)), false);
        scene.idle(50);
        scene.markAsFinished();
    }

    public static void growthLamp(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("growth_lamp", "Accelerating crop growth");
        scene.configureBasePlate(0, 0, 5);
        class_2338 light = util.grid().at(2, 2, 2);
        scene.showBasePlate();
        scene.world().showSection(util.select().fromTo(1, 1, 1, 3, 1, 2), class_2350.field_11036);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(2, 1, 2, 2, 3, 4), class_2350.field_11043);
        scene.idle(15);
        scene.overlay().showText(80).text("The growth lamp is a special type of light bulb which accelerates crop growth in a certain area when powered on").attachKeyFrame().pointAt(util.vector().blockSurface(light, class_2350.field_11039)).placeNearTarget();
        scene.idle(40);
        scene.world().modifyBlock(light, state -> (class_2680)state.method_11657((class_2769)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(2)), false);
        class_2338[] crops = new class_2338[]{util.grid().at(1, 1, 1), util.grid().at(2, 1, 1), util.grid().at(1, 1, 2), util.grid().at(3, 1, 2)};
        Random random = new Random();
        UnaryOperator growCrop = state -> (class_2680)state.method_11657((class_2769)class_2741.field_12550, (Comparable)Integer.valueOf(Math.min((Integer)state.method_11654((class_2769)class_2741.field_12550) + 1, 7)));
        for (int i = 0; i < 15; ++i) {
            scene.world().modifyBlock(crops[random.nextInt(crops.length)], growCrop, false);
            scene.idle(10);
        }
        scene.markAsFinished();
    }

    public static void motor(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("electric_motor", "Turning electricity into rotation");
        scene.configureBasePlate(1, 0, 5);
        class_2338 source = util.grid().at(4, 1, 4);
        class_2338 motor = util.grid().at(4, 1, 2);
        class_2338 gauge = util.grid().at(5, 2, 2);
        scene.electric().connectInvisible(source, 0, util.grid().at(5, 1, 1), 0);
        scene.electric().connectInvisible(source, 1, util.grid().at(5, 1, 3), 0);
        scene.showBasePlate();
        scene.world().showSection(util.select().position(gauge.method_10074()), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().position(gauge), class_2350.field_11033);
        scene.world().showSection(util.select().position(5, 1, 1), class_2350.field_11033);
        scene.world().showSection(util.select().position(5, 1, 3), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(0, 0, 3), class_2350.field_11034);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 1, 1, 2), class_2350.field_11034);
        scene.world().showSection(util.select().fromTo(2, 1, 2, 3, 1, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(motor), class_2350.field_11033);
        scene.idle(5);
        scene.electric().connect(util.grid().at(5, 1, 1), 0, gauge, 0);
        scene.electric().connect(util.grid().at(5, 1, 1), 0, motor, 1);
        scene.electric().connect(util.grid().at(5, 1, 3), 0, gauge, 1);
        scene.electric().connect(util.grid().at(5, 1, 3), 0, motor, 0);
        scene.electric().setSource(source, 50.0f);
        scene.electric().tickFor(10);
        scene.world().setKineticSpeed(util.select().fromTo(0, 1, 2, 4, 1, 2), 64.0f);
        scene.world().setKineticSpeed(util.select().position(0, 0, 3), -32.0f);
        scene.effects().rotationSpeedIndicator(motor.method_10067());
        scene.idle(15);
        scene.overlay().showText(80).text("The electric motor lets you convert electricity into rotation").attachKeyFrame().pointAt(util.vector().topOf(motor)).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(80).text("The speed of the motor depends on the voltage you provide").attachKeyFrame().pointAt(util.vector().blockSurface(gauge, class_2350.field_11039)).placeNearTarget();
        scene.idle(40);
        scene.electric().setSource(source, 100.0f);
        scene.electric().tickFor(10);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 2.0f);
        scene.effects().rotationSpeedIndicator(motor.method_10067());
        scene.idle(50);
        scene.markAsFinished();
    }

    public static void constantSpeedMotor(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("constant_speed_motor", "Regulated Motor");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        ElementLink section = scene.world().showIndependentSection(util.select().fromTo(1, 1, 3, 2, 2, 3), class_2350.field_11033);
        scene.world().moveSection(section, util.vector().of(0.0, 0.0, -1.0), 0);
        scene.idle(10);
        scene.world().setKineticSpeed(util.select().fromTo(1, 1, 2, 2, 2, 3), 32.0f);
        scene.world().setKineticSpeed(util.select().fromTo(1, 1, 3, 2, 1, 3), 8.0f);
        scene.overlay().showText(80).text("A Constant Speed Motor combines the functionality of an Electric Motor and a Speed Controller").pointAt(util.vector().of(1.5, 1.5, 2.0)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.world().hideIndependentSection(section, class_2350.field_11036);
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(1, 1, 2, 2, 1, 2), class_2350.field_11033);
        scene.idle(20);
        scene.effects().indicateSuccess(util.grid().at(2, 1, 2));
        scene.idle(20);
        scene.overlay().showText(90).text("Its speed is constant while the provided voltage determines the stress capacity and rotation direction").pointAt(util.vector().topOf(2, 1, 2)).placeNearTarget().attachKeyFrame();
        scene.idle(100);
        scene.markAsFinished();
    }

    public static void basinHeater(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("basin_heater", "High power heating");
        scene.configureBasePlate(0, 0, 5);
        class_2338 target = util.grid().at(2, 1, 2);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().position(target), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(target.method_10084()), class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(80).text("The Basin Heater can provide Heat to Items processed in a Basin").pointAt(util.vector().blockSurface(target, class_2350.field_11039)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.world().hideSection(util.select().position(target.method_10084()), class_2350.field_11036);
        scene.idle(20);
        scene.world().modifyBlock(target, state -> (class_2680)state.method_11657(BasinHeaterBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), false);
        scene.idle(40);
        scene.overlay().showText(80).text("When given enough power the heater can give the highest level of heat").pointAt(util.vector().topOf(target)).placeNearTarget().attachKeyFrame();
        scene.idle(40);
        scene.world().modifyBlock(target, state -> (class_2680)state.method_11657(BasinHeaterBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SEETHING), false);
        scene.idle(50);
        scene.markAsFinished();
    }

    public static void servo(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("servo", "Precise movements");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().layer(1), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().layer(2), class_2350.field_11033);
        scene.idle(10);
        ElementLink plank = scene.world().showIndependentSection(util.select().layer(3), class_2350.field_11033);
        scene.world().moveSection(plank, util.vector().of(0.0, 0.0, 0.0), 0);
        scene.overlay().showText(80).text("A Servo can be used to precisely control mechanical movements using an electric signal").pointAt(util.vector().topOf(4, 1, 2)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        class_2338 bearing = util.grid().at(2, 2, 2);
        int rotationDuration = 74;
        scene.world().setKineticSpeed(util.select().layer(1), 16.0f);
        scene.world().setKineticSpeed(util.select().position(2, 1, 2), -16.0f);
        scene.effects().rotationSpeedIndicator(util.grid().at(4, 1, 2));
        scene.world().rotateBearing(bearing, 360.0f, rotationDuration);
        scene.world().rotateSection(plank, 0.0, 360.0, 0.0, rotationDuration);
        scene.idle(rotationDuration);
        rotationDuration = 69;
        scene.world().setKineticSpeed(util.select().layer(1), -16.0f);
        scene.world().setKineticSpeed(util.select().position(2, 1, 2), 16.0f);
        scene.effects().rotationSpeedIndicator(util.grid().at(4, 1, 2));
        scene.world().rotateBearing(bearing, -315.0f, rotationDuration);
        scene.world().rotateSection(plank, 0.0, -315.0, 0.0, rotationDuration);
        scene.idle(rotationDuration);
        scene.world().setKineticSpeed(util.select().layer(1), 0.0f);
        scene.overlay().showText(80).text("The control pin accepts a voltage between -5 and 5 volts, which maps to -360 and 360 degrees of rotation").placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.markAsFinished();
    }

    public static void bell(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("bell", "Alarm bell");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 1, 3), class_2350.field_11033);
        scene.world().showSection(util.select().position(2, 2, 3), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 2, 2), class_2350.field_11035);
        scene.idle(10);
        scene.overlay().showText(80).text("The Alarm Bell is an electric device which makes sound when you power it.").pointAt(util.vector().centerOf(2, 2, 2)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.markAsFinished();
    }

    public static void electromagnet(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("electromagnet", "Processing Items with the Electromagnet");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        ElementLink depot = scene.world().showIndependentSection(util.select().position(2, 1, 1), class_2350.field_11033);
        scene.world().moveSection(depot, util.vector().of(0.0, 0.0, 1.0), 0);
        scene.idle(10);
        Selection magnet = util.select().position(2, 3, 2);
        class_2338 magnetPos = util.grid().at(2, 3, 2);
        class_2338 depotPos = util.grid().at(2, 1, 1);
        scene.world().modifyBlockEntity(magnetPos, ElectromagnetBlockEntity.class, be -> ((ThermalBehaviour)be.getBehaviour(ThermalBehaviour.TYPE)).behaviourFlags(0));
        scene.electric().addSource(magnetPos, 0, 200.0f);
        scene.electric().addSource(magnetPos, 1, 0.0f);
        scene.electric().tickFor(5);
        scene.world().showSection(magnet, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(2, 1, 3, 2, 1, 5), class_2350.field_11043);
        scene.idle(3);
        scene.world().showSection(util.select().position(2, 2, 3), class_2350.field_11035);
        scene.idle(3);
        scene.world().showSection(util.select().position(2, 3, 3), class_2350.field_11043);
        scene.effects().indicateSuccess(magnetPos);
        scene.idle(10);
        class_243 pressSide = util.vector().blockSurface(magnetPos, class_2350.field_11039);
        scene.overlay().showText(60).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Electromagnet can process items provided beneath it");
        scene.idle(70);
        scene.overlay().showText(60).pointAt(pressSide.method_1023(0.0, 2.0, 0.0)).placeNearTarget().text("The Input items can be dropped or placed on a Depot under the Electromagnet");
        scene.idle(50);
        class_1799 iron = new class_1799((class_1935)class_1802.field_8620);
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11043, iron);
        class_243 depotCenter = util.vector().centerOf(depotPos.method_10072());
        scene.overlay().showControls(depotCenter, Pointing.UP, 30).withItem(iron);
        scene.idle(10);
        Class<ElectromagnetBlockEntity> type = ElectromagnetBlockEntity.class;
        scene.world().modifyBlockEntity(magnetPos, type, pte -> pte.getMagnetizingBehaviour().start(MagnetizingBehaviour.Mode.BELT, util.vector().of(2.5, 1.8125, 2.5)));
        int processingTime = 50;
        scene.idle(processingTime);
        scene.world().removeItemsFromBelt(depotPos);
        class_1799 magnetStack = ModdedItems.MAGNET.asStack();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11036, magnetStack);
        scene.idle(10);
        scene.overlay().showControls(depotCenter, Pointing.UP, 50).withItem(magnetStack);
        scene.idle(60);
        scene.world().hideIndependentSection(depot, class_2350.field_11043);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 1, 3, 0, 2, 3), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(4, 1, 2, 0, 2, 2), class_2350.field_11035);
        scene.idle(20);
        class_2338 beltPos = util.grid().at(0, 1, 2);
        scene.overlay().showText(40).pointAt(util.vector().blockSurface(beltPos, class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("When items are provided on a belt...");
        scene.idle(30);
        ElementLink ingot = scene.world().createItemOnBelt(beltPos, class_2350.field_11035, iron);
        scene.idle(15);
        ElementLink ingot2 = scene.world().createItemOnBelt(beltPos, class_2350.field_11035, iron);
        scene.idle(15);
        scene.world().stallBeltItem(ingot, true);
        scene.world().modifyBlockEntity(magnetPos, type, pte -> pte.getMagnetizingBehaviour().start(MagnetizingBehaviour.Mode.BELT, util.vector().of(2.5, 1.8125, 2.5)));
        scene.overlay().showText(50).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Electromagnet will hold and process them automatically");
        scene.idle(processingTime);
        scene.world().removeItemsFromBelt(magnetPos.method_10087(2));
        ingot = scene.world().createItemOnBelt(magnetPos.method_10087(2), class_2350.field_11036, magnetStack);
        scene.world().stallBeltItem(ingot, true);
        scene.idle(15);
        scene.world().stallBeltItem(ingot, false);
        scene.idle(15);
        scene.world().stallBeltItem(ingot2, true);
        scene.world().modifyBlockEntity(magnetPos, type, pte -> pte.getMagnetizingBehaviour().start(MagnetizingBehaviour.Mode.BELT, util.vector().of(2.5, 1.8125, 2.5)));
        scene.idle(processingTime);
        scene.world().removeItemsFromBelt(magnetPos.method_10087(2));
        ingot2 = scene.world().createItemOnBelt(magnetPos.method_10087(2), class_2350.field_11036, magnetStack);
        scene.world().stallBeltItem(ingot2, true);
        scene.idle(15);
        scene.world().stallBeltItem(ingot2, false);
        scene.markAsFinished();
    }

    public static void battery(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("battery", "Storing electricity");
        scene.configureBasePlate(0, 0, 5);
        class_2338 battery = util.grid().at(2, 1, 3);
        class_2338 meter = util.grid().at(2, 1, 1);
        class_2338 connector = util.grid().at(2, 2, 2);
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().position(battery), class_2350.field_11033);
        scene.world().showSection(util.select().position(battery.method_10084()), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(meter), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(connector), class_2350.field_11035);
        scene.idle(10);
        scene.electric().connect(connector, 0, meter, 1);
        scene.electric().connect(connector, 1, meter, 0);
        scene.electric().tickFor(10);
        scene.idle(10);
        scene.overlay().showText(80).text("The Battery allows you to store electricity for later use").pointAt(util.vector().topOf(battery.method_10084())).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.overlay().showText(80).text("As the battery discharges, its voltage and resistance will begin to change").placeNearTarget().attachKeyFrame();
        scene.idle(40);
        scene.electric().tickFor(30);
        scene.addInstruction((PonderInstruction)new DisChargeBattery(30, 0.0f, battery));
        scene.idle(50);
        scene.markAsFinished();
    }

    private static class DisChargeBattery
    extends TickingInstruction {
        private final class_2338 battery;
        private final int time;
        private final float targetEnergyLevel;
        private float energyPerTick;

        public DisChargeBattery(int time, float targetEnergyLevel, class_2338 battery) {
            super(false, time);
            this.time = time;
            this.targetEnergyLevel = targetEnergyLevel;
            this.battery = battery;
        }

        protected Optional<BatteryBlockEntity> getBattery(PonderScene scene) {
            class_2586 be = scene.getWorld().method_8321(this.battery);
            if (be instanceof MultiBlockBatteryEntity) {
                MultiBlockBatteryEntity mbe = (MultiBlockBatteryEntity)be;
                return Optional.ofNullable(mbe.getControllerBE());
            }
            if (be instanceof BatteryBlockEntity) {
                BatteryBlockEntity battery = (BatteryBlockEntity)be;
                return Optional.of(battery);
            }
            return Optional.empty();
        }

        protected void firstTick(PonderScene scene) {
            super.firstTick(scene);
            this.getBattery(scene).ifPresent(battery -> {
                double target = (double)this.targetEnergyLevel * battery.getCapacity();
                this.energyPerTick = (float)((target - battery.getEnergy()) / (double)this.time);
            });
        }

        public void tick(PonderScene scene) {
            super.tick(scene);
            if (!this.isComplete()) {
                this.getBattery(scene).ifPresent(battery -> battery.setEnergy(battery.getEnergy() + (double)this.energyPerTick));
            }
        }
    }
}

