/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.ponder.scenes;

import com.simibubi.create.AllItems;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.electricity.gauge.CurrentGaugeBlockEntity;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.ponder.base.PowerGridSceneBuilder;
import org.patryk3211.powergrid.ponder.base.WireElement;

public class GaugeScenes {
    public static void voltage(SceneBuilder scene, SceneBuildingUtil util) {
        GaugeScenes.gauge(scene, util, true);
    }

    public static void current(SceneBuilder scene, SceneBuildingUtil util) {
        GaugeScenes.gauge(scene, util, false);
    }

    public static void gauge(SceneBuilder builder, SceneBuildingUtil util, boolean voltage) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        String component = voltage ? "Voltage Gauge" : "Current Gauge";
        String title = "Monitoring Electricity using the " + component;
        scene.title(voltage ? "voltage_gauge" : "current_gauge", title);
        scene.configureBasePlate(0, 0, 5);
        class_2338 sourcePos = util.grid().at(2, 1, 4);
        class_2338 gaugePos = util.grid().at(2, 1, 2);
        if (!voltage) {
            scene.world().setBlock(gaugePos, ModdedBlocks.CURRENT_METER.getDefaultState(), false);
            scene.world().modifyBlockEntityNBT(util.select().position(2, 1, 2), CurrentGaugeBlockEntity.class, tag -> tag.method_10569("ScrollValue", 2));
        }
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().position(0, 1, 2), class_2350.field_11033);
        scene.world().showSection(util.select().position(0, 2, 2), class_2350.field_11033);
        scene.idle(2);
        scene.world().showSection(util.select().position(4, 1, 2), class_2350.field_11033);
        scene.world().showSection(util.select().position(4, 2, 2), class_2350.field_11033);
        scene.idle(2);
        scene.world().showSection(util.select().position(gaugePos), class_2350.field_11033);
        scene.idle(2);
        scene.electric().connect(util.grid().at(0, 2, 2), 0, gaugePos, 1);
        ElementLink<WireElement> wire2 = scene.electric().connect(util.grid().at(4, 2, 2), 0, gaugePos, 0);
        scene.electric().connectInvisible(util.grid().at(0, 2, 2), 0, sourcePos, 0);
        scene.electric().connectInvisible(util.grid().at(4, 2, 2), 0, sourcePos, 1);
        scene.idle(2);
        if (voltage) {
            scene.electric().tickFor(10);
            scene.electric().setSource(sourcePos, 5.0f);
            scene.idle(10);
            scene.overlay().showText(80).text("The " + component + " displays the voltage potential between it's terminals").attachKeyFrame().pointAt(util.vector().topOf(gaugePos)).placeNearTarget();
            scene.idle(40);
            scene.electric().tickFor(10);
            scene.electric().setSource(sourcePos, 15.0f);
            scene.idle(40);
            scene.effects().indicateSuccess(gaugePos);
            scene.idle(10);
        } else {
            scene.overlay().showText(60).text("The " + component + " displays the current flowing through it's terminals").attachKeyFrame().pointAt(util.vector().topOf(gaugePos)).placeNearTarget();
            scene.idle(60);
            scene.electric().removeWire(wire2);
            scene.idle(10);
            class_2338 heater1Pos = util.grid().at(3, 1, 1);
            class_2338 heater2Pos = util.grid().at(3, 1, 3);
            scene.world().setBlock(heater1Pos, ModdedBlocks.HEATING_COIL.getDefaultState(), true);
            scene.world().setBlock(heater2Pos, ModdedBlocks.HEATING_COIL.getDefaultState(), true);
            scene.world().showSection(util.select().position(heater1Pos), class_2350.field_11033);
            scene.world().showSection(util.select().position(heater2Pos), class_2350.field_11033);
            scene.idle(5);
            scene.electric().connect(util.grid().at(4, 2, 2), 0, heater1Pos, 0);
            scene.electric().connect(util.grid().at(4, 2, 2), 0, heater2Pos, 0);
            scene.electric().connect(gaugePos, 0, heater1Pos, 1);
            scene.electric().connect(gaugePos, 0, heater2Pos, 1);
            scene.electric().setSource(sourcePos, 20.0f);
            scene.electric().tickFor(10);
            scene.idle(40);
            scene.overlay().showText(80).text("Current gauges are in series with the circuit so they can have an effect on the transferred power").attachKeyFrame().pointAt(util.vector().topOf(gaugePos)).placeNearTarget();
            scene.idle(40);
            scene.electric().setSource(sourcePos, 10.0f);
            scene.electric().tickFor(10);
            scene.idle(50);
        }
        scene.overlay().showText(60).text("You can change the gauge's range by clicking on top of it").attachKeyFrame().pointAt(util.vector().topOf(gaugePos)).placeNearTarget();
        scene.idle(70);
        class_243 blockSurface = util.vector().blockSurface(gaugePos, class_2350.field_11043);
        scene.overlay().showControls(blockSurface, Pointing.RIGHT, 80).withItem(AllItems.GOGGLES.asStack());
        scene.idle(7);
        scene.overlay().showText(80).text("When wearing Engineers' Goggles, the player can get more detailed information from the Gauge").attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(blockSurface).placeNearTarget();
        scene.idle(90);
        scene.markAsFinished();
    }

    public static void power(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("power_gauge", "Monitoring Electricity using the Power Gauge");
        scene.configureBasePlate(0, 0, 5);
        class_2338 gauge = util.grid().at(2, 1, 2);
        class_2338 common = util.grid().at(4, 1, 3);
        class_2338 input = util.grid().at(4, 1, 2);
        class_2338 bulb = util.grid().at(0, 2, 2);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(input, common), class_2350.field_11033);
        scene.world().showSection(util.select().fromTo(bulb.method_10074(), bulb), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(gauge), class_2350.field_11033);
        scene.idle(5);
        scene.electric().addSource(common, 0, 0.0f);
        scene.electric().connect(common, 0, gauge, 2);
        scene.electric().connect(input, 0, gauge, 0);
        scene.electric().connect(gauge, 1, bulb, 0);
        scene.electric().connect(gauge, 2, bulb, 1);
        scene.idle(10);
        scene.overlay().showText(100).text("The Power Gauge can be used to measure power going into a section of the electrical network").pointAt(util.vector().of(2.5, 1.5, 2.0)).placeNearTarget().attachKeyFrame();
        scene.idle(80);
        scene.electric().addSource(input, 0, 245.0f);
        scene.electric().tickFor(10);
        scene.world().modifyBlock(bulb, state -> (class_2680)state.method_11657((class_2769)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(2)), false);
        scene.idle(20);
        scene.effects().indicateSuccess(gauge);
        scene.idle(20);
        scene.overlay().showText(60).text("You can change the gauge's range by clicking on top of it").attachKeyFrame().pointAt(util.vector().topOf(gauge)).placeNearTarget();
        scene.idle(70);
        class_243 blockSurface = util.vector().blockSurface(gauge, class_2350.field_11043);
        scene.overlay().showControls(blockSurface, Pointing.RIGHT, 80).withItem(AllItems.GOGGLES.asStack());
        scene.idle(7);
        scene.overlay().showText(80).text("When wearing Engineers' Goggles, the player can get more detailed information from the Gauge").attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(blockSurface).placeNearTarget();
        scene.idle(90);
        scene.markAsFinished();
    }
}

