/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility;

import com.google.common.collect.Sets;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.utility.fabric.PlayerUtilitiesImpl;

public class PlayerUtilities {
    public static boolean hasEnoughItems(class_1657 player, class_1792 item, int requiredCount) {
        if (player.method_7337()) {
            return true;
        }
        class_1661 inv = player.method_31548();
        return inv.method_18861(item) >= requiredCount;
    }

    public static boolean hasEnoughItems(@Nullable class_1657 player, class_1799 usedStack, int requiredCount) {
        if (player != null) {
            return PlayerUtilities.hasEnoughItems(player, usedStack.method_7909(), requiredCount);
        }
        return usedStack.method_7947() >= requiredCount;
    }

    public static void removeItems(class_1657 player, class_1792 item, int count) {
        if (player.method_7337()) {
            return;
        }
        class_1661 inv = player.method_31548();
        class_1262.method_29234((class_1263)inv, stack -> stack.method_31574(item), (int)count, (boolean)false);
    }

    public static void removeItems(@Nullable class_1657 player, class_1799 usedStack, int count) {
        if (player != null) {
            PlayerUtilities.removeItems(player, usedStack.method_7909(), count);
            return;
        }
        usedStack.method_7934(Math.min(count, usedStack.method_7947()));
    }

    @NotNull
    public static Collection<class_3222> partialTracking(@NotNull class_3218 world, @NotNull TransmissionLine line) {
        Set<class_3222> players1 = GlobalElectricNetworks.getWorldNetworks((class_1937)world).getTrackers(line.getNode1().endpoint);
        Set<class_3222> players2 = GlobalElectricNetworks.getWorldNetworks((class_1937)world).getTrackers(line.getNode2().endpoint);
        return Sets.symmetricDifference(players1, players2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isFake(class_1657 player) {
        return PlayerUtilitiesImpl.isFake(player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean cancelBreak(class_1937 world, class_2338 pos, class_1657 player) {
        void var2_2;
        void var1_1;
        return PlayerUtilitiesImpl.cancelBreak(world, (class_2338)var1_1, (class_1657)var2_2);
    }
}

