/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.base;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;

public abstract class SegmentedBehaviour<T extends SegmentedBehaviour<T>>
extends BlockEntityBehaviour {
    @Nullable
    protected BlockPos controllerPos;
    protected BlockPos lastKnownPos;
    protected Set<T> segments;
    @Nullable
    protected Runnable changeCallback;
    protected final int maxSize;
    protected Predicate<T> countToSize;
    private boolean rebuildClient = true;

    public SegmentedBehaviour(SmartBlockEntity be, int maxSize, Predicate<T> countToSize) {
        super(be);
        this.maxSize = maxSize;
        this.countToSize = countToSize;
        this.controllerPos = null;
        this.segments = null;
        this.changeCallback = null;
    }

    public void setChangeCallback(@Nullable Runnable callback) {
        this.changeCallback = callback;
    }

    public void initialize() {
        if (this.checkSizeConstraint()) {
            this.makeController();
            super.initialize();
            this.checkConnectivity(null);
        }
    }

    private void sync() {
        if (!this.getWorld().f_46443_) {
            this.rebuildClient = true;
            this.blockEntity.notifyUpdate();
        }
    }

    public void tick() {
        super.tick();
        BlockPos pos = this.getPos();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = pos;
        } else if (!this.lastKnownPos.equals((Object)pos) && pos != null) {
            this.onPositionChanged();
            this.lastKnownPos = pos;
        }
    }

    protected void onPositionChanged() {
        if (this.checkSizeConstraint()) {
            this.makeController();
            super.initialize();
            this.checkConnectivity(null);
        }
    }

    public void forEachSegment(Consumer<T> consumer) {
        T controller = this.getControllerOrThis();
        consumer.accept((SegmentedBehaviour)((Object)controller));
        if (((SegmentedBehaviour)((Object)controller)).segments != null) {
            for (SegmentedBehaviour segment : ((SegmentedBehaviour)((Object)controller)).segments) {
                consumer.accept(segment);
            }
        }
    }

    protected void makeController() {
        this.controllerPos = null;
        this.segments = new HashSet<T>();
        this.onChange();
    }

    protected void makePeripheral(T controller) {
        assert (controller.isController());
        this.controllerPos = controller.getPos();
        this.segments = null;
        if (this.isCounted() && controller.getLimitedSize() + 1 > this.maxSize) {
            Level world = this.getWorld();
            if (!world.f_46443_) {
                world.m_46961_(this.getPos(), true);
            }
            return;
        }
        controller.segments.add((T)((Object)this));
        controller.segmentAdded((SegmentedBehaviour)this);
        this.sync();
    }

    public boolean isController() {
        return this.controllerPos == null;
    }

    protected abstract List<T> getConnected();

    public abstract BehaviourType<T> getType();

    public Optional<T> getController() {
        if (this.controllerPos == null) {
            return Optional.empty();
        }
        Level world = this.getWorld();
        if (world == null) {
            throw new IllegalCallerException("Tried to get controller before receiving world");
        }
        if (world.m_7232_(SectionPos.m_123171_((int)this.controllerPos.m_123341_()), SectionPos.m_123171_((int)this.controllerPos.m_123343_()))) {
            return Optional.ofNullable((SegmentedBehaviour)SegmentedBehaviour.get((BlockGetter)world, (BlockPos)this.controllerPos, this.getType()));
        }
        return Optional.empty();
    }

    @NotNull
    public T getControllerOrThis() {
        return (T)((Object)this.getController().orElse(this));
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        int[] posArray;
        super.read(compound, clientPacket);
        if (compound.m_128441_("LastKnownPos")) {
            posArray = compound.m_128465_("LastKnownPos");
            this.lastKnownPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        }
        if (clientPacket && !compound.m_128471_("SegmentedRebuild")) {
            return;
        }
        if (compound.m_128441_("Controller")) {
            posArray = compound.m_128465_("Controller");
            this.controllerPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            this.segments = null;
        } else {
            this.controllerPos = null;
            if (this.segments == null) {
                this.segments = new HashSet<T>();
            }
            if (clientPacket) {
                this.makeController();
                this.checkConnectivity(null);
            }
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.lastKnownPos != null) {
            compound.m_128385_("LastKnownPos", new int[]{this.lastKnownPos.m_123341_(), this.lastKnownPos.m_123342_(), this.lastKnownPos.m_123343_()});
        }
        if (clientPacket) {
            if (!this.rebuildClient) {
                return;
            }
            this.rebuildClient = false;
            compound.m_128379_("SegmentedRebuild", true);
        }
        if (!this.isController()) {
            compound.m_128385_("Controller", new int[]{this.controllerPos.m_123341_(), this.controllerPos.m_123342_(), this.controllerPos.m_123343_()});
        }
    }

    private boolean checkSizeConstraint() {
        if (this.controllerPos != null || this.segments != null) {
            return true;
        }
        int totalSize = this.isCounted() ? 1 : 0;
        for (SegmentedBehaviour connected : this.getConnected()) {
            totalSize += connected.getLimitedSize();
        }
        if (totalSize > this.maxSize) {
            Level world = this.getWorld();
            if (!world.f_46443_) {
                world.m_46961_(this.getPos(), true);
            }
            return false;
        }
        return true;
    }

    public void checkConnectivity(@Nullable T without) {
        if (!this.isController() && !this.getPos().equals((Object)this.controllerPos)) {
            Optional<T> controller = this.getController();
            if (controller.isPresent()) {
                ((SegmentedBehaviour)((Object)controller.get())).checkConnectivity(without);
            } else {
                PowerGrid.LOGGER.warn("Tried to check connectivity but controller is null");
            }
            return;
        }
        if (this.segments == null) {
            return;
        }
        HashSet<SegmentedBehaviour> allConnected = new HashSet<SegmentedBehaviour>();
        ArrayList<SegmentedBehaviour<T>> toCheck = new ArrayList<SegmentedBehaviour<T>>();
        toCheck.add(this);
        while (!toCheck.isEmpty()) {
            SegmentedBehaviour segment = (SegmentedBehaviour)((Object)toCheck.remove(0));
            if (segment == without || !allConnected.add(segment)) continue;
            List<T> connected = segment.getConnected();
            toCheck.addAll(connected);
        }
        ArrayList<Object> removed = new ArrayList<Object>();
        if (without == this) {
            removed.addAll(this.segments);
            this.segments.forEach(SegmentedBehaviour::makeController);
        } else {
            Iterator<T> iter = this.segments.iterator();
            while (iter.hasNext()) {
                SegmentedBehaviour segment = (SegmentedBehaviour)((Object)iter.next());
                if (segment == without || allConnected.contains((Object)segment)) continue;
                iter.remove();
                removed.add((Object)segment);
                this.segmentRemoved(segment);
                segment.makeController();
            }
        }
        while (!removed.isEmpty()) {
            SegmentedBehaviour zoneController = (SegmentedBehaviour)((Object)removed.remove(0));
            ArrayList<SegmentedBehaviour> checkQueue2 = new ArrayList<SegmentedBehaviour>();
            checkQueue2.add(zoneController);
            while (!checkQueue2.isEmpty()) {
                SegmentedBehaviour segment = (SegmentedBehaviour)((Object)checkQueue2.remove(0));
                List<T> connected = segment.getConnected();
                for (SegmentedBehaviour neighbor : connected) {
                    if (!removed.contains((Object)neighbor)) continue;
                    neighbor.makePeripheral(zoneController);
                    removed.remove((Object)neighbor);
                    checkQueue2.add(neighbor);
                }
            }
        }
        this.segments.clear();
        for (SegmentedBehaviour segment : allConnected) {
            if (segment == this) continue;
            segment.makePeripheral(this);
        }
        this.sync();
    }

    public void remove() {
        SegmentedBehaviour controller = this.getControllerOrThis();
        controller.checkConnectivity((SegmentedBehaviour)this);
    }

    protected void onChange() {
        this.sync();
        if (this.changeCallback != null) {
            this.changeCallback.run();
        }
    }

    public void segmentAdded(T behaviour) {
        this.onChange();
        for (SegmentedBehaviour segment : this.segments) {
            segment.onChange();
        }
    }

    public void segmentRemoved(T behaviour) {
        this.onChange();
        for (SegmentedBehaviour segment : this.segments) {
            segment.onChange();
        }
    }

    public int getSegmentCount() {
        T controller = this.getControllerOrThis();
        if (((SegmentedBehaviour)((Object)controller)).segments == null) {
            return 1;
        }
        return ((SegmentedBehaviour)((Object)controller)).segments.size() + 1;
    }

    protected boolean isCounted() {
        return this.countToSize.test(this);
    }

    public int getLimitedSize() {
        int count;
        T controller = this.getControllerOrThis();
        int n = count = ((SegmentedBehaviour)((Object)controller)).isCounted() ? 1 : 0;
        if (((SegmentedBehaviour)((Object)controller)).segments == null) {
            return count;
        }
        for (SegmentedBehaviour segment : ((SegmentedBehaviour)((Object)controller)).segments) {
            if (!segment.isCounted()) continue;
            ++count;
        }
        return count;
    }
}

