/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.circuitboard;

import java.util.HashMap;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.utility.Lang;

public class IncompleteCircuitItem
extends Item {
    public IncompleteCircuitItem(Item.Properties settings) {
        super(settings.m_41487_(1));
    }

    private static CompoundTag makeAssemblyTag(CompoundTag schematicTag) {
        CircuitSchematic schematic = CircuitSchematic.fromNbt(schematicTag);
        HashMap<Item, Integer> componentAmounts = new HashMap<Item, Integer>();
        int componentCount = 0;
        for (PlacedComponent placed : schematic.components()) {
            Item item2 = placed.component.getRequiredItem();
            componentAmounts.compute(item2, (key, current) -> current == null ? 1 : current + 1);
            ++componentCount;
        }
        CompoundTag componentTag = new CompoundTag();
        componentAmounts.forEach((item, count) -> {
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_(item);
            componentTag.m_128405_(id.toString(), count.intValue());
        });
        CompoundTag assemblyTag = new CompoundTag();
        assemblyTag.m_128365_("Missing", (Tag)componentTag);
        assemblyTag.m_128405_("Inserted", 0);
        assemblyTag.m_128405_("Total", componentCount);
        return assemblyTag;
    }

    private static boolean insertComponent(CompoundTag assemblyTag, ItemStack component) {
        String id;
        CompoundTag missingComponents = assemblyTag.m_128469_("Missing");
        if (!missingComponents.m_128441_(id = BuiltInRegistries.f_257033_.m_7981_((Object)component.m_41720_()).toString())) {
            return false;
        }
        int missingAmount = missingComponents.m_128451_(id);
        if (--missingAmount <= 0) {
            missingComponents.m_128473_(id);
        } else {
            missingComponents.m_128405_(id, missingAmount);
        }
        assemblyTag.m_128405_("Inserted", assemblyTag.m_128451_("Inserted") + 1);
        return true;
    }

    @Nullable
    public static ItemStack insert(ItemStack circuit, ItemStack component) {
        ItemStack newStack;
        if (!circuit.m_150930_((Item)ModdedItems.INCOMPLETE_CIRCUIT.get()) || !circuit.m_41782_()) {
            return null;
        }
        CompoundTag tag = circuit.m_41783_().m_6426_();
        if (!tag.m_128441_("Assembly")) {
            tag.m_128365_("Assembly", (Tag)IncompleteCircuitItem.makeAssemblyTag(tag.m_128469_("Schematic")));
        }
        if (!IncompleteCircuitItem.insertComponent(tag.m_128469_("Assembly"), component)) {
            return null;
        }
        CompoundTag missing = tag.m_128469_("Assembly").m_128469_("Missing");
        if (missing.m_128456_()) {
            tag.m_128473_("Assembly");
            newStack = new ItemStack(ModdedBlocks.CIRCUIT_BOARD);
        } else {
            newStack = new ItemStack(ModdedItems.INCOMPLETE_CIRCUIT);
        }
        newStack.m_41751_(tag);
        return newStack;
    }

    public static float getProgress(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("Assembly")) {
            return 0.0f;
        }
        CompoundTag assemblyTag = stack.m_41737_("Assembly");
        return (float)assemblyTag.m_128451_("Inserted") / (float)assemblyTag.m_128451_("Total");
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * IncompleteCircuitItem.getProgress(stack));
    }

    public int m_142159_(ItemStack stack) {
        return Color.mixColors((int)-16268, (int)-12124192, (float)IncompleteCircuitItem.getProgress(stack));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        CompoundTag assemblyTag;
        if (!stack.m_41782_()) {
            return;
        }
        if (!stack.m_41783_().m_128441_("Assembly")) {
            if (!stack.m_41783_().m_128441_("Schematic")) {
                return;
            }
            assemblyTag = IncompleteCircuitItem.makeAssemblyTag(stack.m_41737_("Schematic"));
        } else {
            assemblyTag = stack.m_41737_("Assembly");
        }
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Lang.translate("tooltip.circuit_assembly", new Object[0]).style(ChatFormatting.GRAY).component());
        int inserted = assemblyTag.m_128451_("Inserted");
        int total = assemblyTag.m_128451_("Total");
        tooltip.add((Component)Lang.translate("tooltip.circuit_assembly.progress", new Object[0]).add(Component.m_237113_((String)String.format(": %d/%d", inserted, total))).style(ChatFormatting.DARK_GRAY).component());
        CompoundTag missing = assemblyTag.m_128469_("Missing");
        int index = 0;
        for (String itemId : missing.m_128431_()) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemId));
            String key = item.m_5524_();
            MutableComponent line = switch (index) {
                case 0 -> Lang.translate("tooltip.circuit_assembly.insert", new Object[0]).add(Component.m_237113_((String)" ")).add(Component.m_237115_((String)key)).style(ChatFormatting.AQUA).component();
                case 1 -> Lang.text("-> ").add(Lang.translate("tooltip.circuit_assembly.insert", new Object[0])).add(Component.m_237113_((String)" ")).add(Component.m_237115_((String)key)).style(ChatFormatting.DARK_AQUA).component();
                default -> throw new IllegalStateException();
            };
            tooltip.add((Component)line);
            if (++index < 2) continue;
            break;
        }
    }
}

