/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.IRenderedComponent;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.CalculatedProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.thermal.ThermalBuilder;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.special.ElectronTubeWire;

public class ElectronTubeComponent
extends OrientableComponent
implements IRenderedComponent {
    public static final FloatProperty TUBE_GAIN = new FloatProperty("powergrid", "tube_gain", 5.0f, 1.0f, 100.0f);
    public static final FloatProperty ANODE_RESISTANCE = new FloatProperty("powergrid", "tube_anode_resistance", 5000.0f, 100.0f, 100000.0f);
    public static final FloatProperty SATURATION_CURRENT = new FloatProperty("powergrid", "tube_saturation_current", 0.1f, 0.001f, 20.0f);
    public static final FloatProperty HEATER_VOLTAGE = new FloatProperty("powergrid", "tube_heater_voltage", 6.0f, 1.0f, 16.0f);
    public static final CalculatedProperty<Float> HEATER_POWER = new CalculatedProperty<Float>("powergrid", "tube_heater_power", state -> {
        Float Is = state.get(SATURATION_CURRENT);
        return Float.valueOf(Math.max(5.0f, Is.floatValue() * 50.0f));
    }, value -> String.format("%.1f W", value));

    public ElectronTubeComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{TUBE_GAIN, ANODE_RESISTANCE, SATURATION_CURRENT, HEATER_VOLTAGE, HEATER_POWER});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder, @NotNull ThermalBuilder.IEmitter thermals) {
        float perveance = ElectronTubeWire.calculatePerveance(1.0f, placed.get(TUBE_GAIN).floatValue(), 1.0f / placed.get(ANODE_RESISTANCE).floatValue());
        Float saturationCurrent = placed.get(SATURATION_CURRENT);
        ElectronTubeWire tube = new ElectronTubeWire(placed.get(TUBE_GAIN).floatValue(), perveance, saturationCurrent.floatValue(), builder.terminalNode(0), builder.terminalNode(2), builder.terminalNode(1));
        builder.add(tube);
        Float targetPower = placed.get(HEATER_POWER);
        float heaterCurrent = targetPower.floatValue() / placed.get(HEATER_VOLTAGE).floatValue();
        float heaterResistance = placed.get(HEATER_VOLTAGE).floatValue() / heaterCurrent;
        ElectricWire heater = builder.connect(heaterResistance, builder.terminalNode(3), builder.terminalNode(4));
        placed.add(tube);
        placed.add(heater);
        RenderData data = new RenderData();
        placed.customData = data;
        float operatingTemperature = 1400.0f;
        float dissipationFactor = targetPower.floatValue() / 1378.0f;
        thermals.builder().addHeatSource(heater).setThermalMass(0.001f * targetPower.floatValue() / 5.0f).setOverheatTemperature(1600.0f).setDissipationFactor(dissipationFactor).withTemperatureCallback(temperature -> {
            tube.setSaturationCurrent(Mth.m_14036_((float)(temperature.floatValue() - 1300.0f), (float)0.0f, (float)150.0f) * saturationCurrent.floatValue() / 100.0f);
            data.prev = data.current;
            data.current = Mth.m_14036_((float)((temperature.floatValue() - 1000.0f) / 400.0f), (float)0.0f, (float)1.125f);
        });
    }

    @Override
    public void render(CircuitBoardBlockEntity be, PlacedComponent placed, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        int a = 0;
        Object object = placed.customData;
        if (object instanceof RenderData) {
            RenderData data = (RenderData)object;
            a = (int)(Mth.m_14179_((float)partialTicks, (float)data.prev, (float)data.current) * 64.0f);
        }
        if (a == 0) {
            return;
        }
        SuperByteBuffer buffer = CachedBuffers.partial((PartialModel)ModdedPartialModels.ELECTRON_TUBE_GLOW, (BlockState)be.m_58900_());
        buffer.disableDiffuse().color(a, a, a, 255).light(0xF000F0).renderInto(ms, bufferSource.m_6299_(RenderTypes.additive()));
    }

    public static class RenderData {
        float prev;
        float current;
    }
}

