/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.electricity.sim.special.LRSeriesWire;

public class InductorComponent
extends OrientableComponent {
    public static final FloatProperty INDUCTANCE = new FloatProperty("powergrid", "inductor_value", 0.1f, 1.0E-4f, 1000.0f);
    private static final CurrentProperty CURRENT = new CurrentProperty("powergrid", "current");

    public InductorComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{INDUCTANCE, CURRENT});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        float L = placed.get(INDUCTANCE).floatValue() / 1000.0f;
        LRSeriesWire wire = new LRSeriesWire(L, 0.01f, builder.terminalNode(0), builder.terminalNode(1));
        wire.setCurrent(placed.get(CURRENT).floatValue());
        builder.add(wire);
        placed.add(wire);
    }

    @Override
    public boolean tick(@NotNull PlacedComponent placed) {
        if (!placed.wires.isEmpty()) {
            placed.set(CURRENT, Float.valueOf(placed.wires.get(0).current()));
        }
        return true;
    }

    @Override
    public void stateUpdated(@NotNull PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return;
        }
        LRSeriesWire wire = (LRSeriesWire)placed.wires.get(0);
        wire.setCurrent(placed.get(CURRENT).floatValue());
    }

    private static class CurrentProperty
    extends FloatProperty {
        public CurrentProperty(String namespace, String name) {
            super(namespace, name, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public Float parse(String str) throws NumberFormatException {
            return Float.valueOf(0.0f);
        }

        @Override
        public boolean isHidden() {
            return true;
        }

        @Override
        protected float limit(float value) {
            return value;
        }
    }
}

