/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.config;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.config.ResistanceValues;

public class CResistance
extends ConfigBase
implements ResistanceValues.Provider {
    private static final int VERSION = 3;
    private static final Object2DoubleMap<ResourceLocation> DEFAULT_RESISTANCES = new Object2DoubleOpenHashMap();
    protected final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> resistances = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{".", Comments.ohm, Comments.resistance}).push("resistance");
        DEFAULT_RESISTANCES.forEach((id, value) -> this.resistances.put((ResourceLocation)id, (ForgeConfigSpec.ConfigValue<Double>)builder.define(id.m_135815_(), value)));
        builder.pop();
    }

    public String getName() {
        return "resistance-v3";
    }

    @Override
    @Nullable
    public DoubleSupplier get(Block block) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        ForgeConfigSpec.ConfigValue<Double> entry = this.resistances.get(id);
        return entry == null ? null : () -> entry.get();
    }

    @Override
    @Nullable
    public DoubleSupplier get(Block block, String suffix) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_266382_("." + suffix);
        ForgeConfigSpec.ConfigValue<Double> entry = this.resistances.get(id);
        return entry == null ? null : () -> entry.get();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setResistance(double value) {
        return builder -> {
            CResistance.assertFromPowerGrid(builder);
            ResourceLocation id = PowerGrid.asResource(builder.getName());
            DEFAULT_RESISTANCES.put((Object)id, value);
            return builder;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setResistance(String suffix, double value) {
        return builder -> {
            CResistance.assertFromPowerGrid(builder);
            ResourceLocation id = PowerGrid.asResource(builder.getName()).m_266382_("." + suffix);
            DEFAULT_RESISTANCES.put((Object)id, value);
            return builder;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setResistances(Object ... suffixValuePairs) {
        return builder -> {
            CResistance.assertFromPowerGrid(builder);
            for (int i = 0; i < suffixValuePairs.length; i += 2) {
                String suffix = (String)suffixValuePairs[i];
                Number value = (Number)suffixValuePairs[i + 1];
                ResourceLocation id = PowerGrid.asResource(builder.getName()).m_266382_("." + suffix);
                DEFAULT_RESISTANCES.put((Object)id, value.doubleValue());
            }
            return builder;
        };
    }

    private static void assertFromPowerGrid(BlockBuilder<?, ?> builder) {
        if (!builder.getOwner().getModid().equals("powergrid")) {
            throw new IllegalStateException("Non-Power Grid blocks cannot be added to Power Grid's config.");
        }
    }

    private static class Comments {
        static String ohm = "[in Ohms]";
        static String resistance = "Configure the individual resistances of electrical blocks";

        private Comments() {
        }
    }
}

