/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ThermalValues {
    private static final List<Provider> providers = new ArrayList<Provider>();

    public static float getPower(Block block) {
        for (Provider provider : providers) {
            DoubleSupplier v = provider.getPower(block);
            if (v == null) continue;
            return (float)v.getAsDouble();
        }
        throw new IllegalArgumentException("Block not found in any thermal providers");
    }

    public static float getMass(Block block) {
        for (Provider provider : providers) {
            DoubleSupplier v = provider.getMass(block);
            if (v == null) continue;
            return (float)v.getAsDouble();
        }
        throw new IllegalArgumentException("Block not found in any thermal providers");
    }

    public static void register(Provider provider) {
        providers.add(provider);
    }

    public static interface Provider {
        @Nullable
        public DoubleSupplier getPower(Block var1);

        @Nullable
        public DoubleSupplier getMass(Block var1);
    }
}

