/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.ClientWorldNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEntity;
import org.patryk3211.powergrid.utility.NumberFormats;

public class GlobalElectricNetworks {
    protected static final Map<Level, WorldNetworks> worldNetworks = new ConcurrentHashMap<Level, WorldNetworks>();

    public static void tick(Level world) {
        WorldNetworks networks = worldNetworks.get(world);
        if (networks == null) {
            return;
        }
        networks.tick();
    }

    public static void unloadWorld(ServerLevel world) {
        worldNetworks.remove(world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static WorldNetworks makeClientWorldNetworks(Level world) {
        return new ClientWorldNetworks(world);
    }

    public static WorldNetworks getWorldNetworks(Level world) {
        return worldNetworks.computeIfAbsent(world, key -> {
            if (key instanceof PonderLevel) {
                return new WorldNetworks((Level)key);
            }
            if (key.f_46443_) {
                return GlobalElectricNetworks.makeClientWorldNetworks(key);
            }
            if (world instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)world;
                return (WorldNetworks)server.m_8895_().m_164861_(nbt -> new WorldNetworks(world, (CompoundTag)nbt), () -> new WorldNetworks(world), "powergrid_electric_network_data");
            }
            return new WorldNetworks(world);
        });
    }

    @Nullable
    public static WorldNetworks getWorldNetworks(LevelAccessor world) {
        return worldNetworks.get(world);
    }

    public static TransmissionLine getLine(WireEntity entity) {
        OwnedFloatingNode owned;
        Object line;
        ElectricWire wire = entity.getWire();
        if (wire == null) {
            return null;
        }
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(entity.m_9236_());
        IElectricNode iElectricNode = wire.getNode1();
        if (iElectricNode instanceof OwnedFloatingNode && (line = worldNetworks.findLineMiddle(owned = (OwnedFloatingNode)iElectricNode)) != null && ((TransmissionLine)line).isPart(wire)) {
            return line;
        }
        line = wire.getNode2();
        if (line instanceof OwnedFloatingNode && (line = worldNetworks.findLineMiddle(owned = (OwnedFloatingNode)line)) != null && ((TransmissionLine)line).isPart(wire)) {
            return line;
        }
        AbstractElectricWire lineWire = worldNetworks.globalGraph.getFirstWire(wire.getNode1(), wire.getNode2());
        if (lineWire instanceof TransmissionLine) {
            TransmissionLine line1 = (TransmissionLine)lineWire;
            return line1;
        }
        return null;
    }

    public static ElectricWire makeConnection(Level world, IWireEndpoint endpoint1, IWireEndpoint endpoint2, BaseWireEntity forEntity, WorldNetworks.PartId id) {
        return GlobalElectricNetworks.getWorldNetworks(world).makeTransmissionLine(endpoint1, endpoint2, forEntity, id);
    }

    private static Component display(IElectricNode node) {
        MutableComponent line;
        if (node instanceof OwnedFloatingNode) {
            OwnedFloatingNode ofn = (OwnedFloatingNode)node;
            line = Component.m_237113_((String)("OFN[" + String.valueOf(ofn.endpoint) + "]"));
        } else {
            line = Component.m_237113_((String)node.toString());
        }
        line.m_7220_((Component)Component.m_237113_((String)("@" + NumberFormats.formatPrecise(node.getVoltage()) + "V")).m_130940_(ChatFormatting.DARK_GRAY));
        if (node.getNetwork() != null) {
            if (node.getNetwork().isLeaf(node)) {
                line.m_7220_((Component)Component.m_237113_((String)" -").m_130940_(ChatFormatting.GREEN));
            } else if (node.getNetwork().isOptimized(node)) {
                line.m_7220_((Component)Component.m_237113_((String)" *").m_130940_(ChatFormatting.GREEN));
            }
        }
        return line;
    }

    public static void inspect(ElectricBehaviour behaviour, Player user) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(user.m_9236_());
        user.m_213846_((Component)(user instanceof ServerPlayer ? Component.m_237113_((String)"Server:").m_130940_(ChatFormatting.GOLD) : Component.m_237113_((String)"Client:").m_130940_(ChatFormatting.GREEN)));
        int index = 0;
        for (OwnedFloatingNode node : behaviour.getExternalNodes()) {
            user.m_213846_((Component)Component.m_237113_((String)(index++ + " = ")).m_7220_(GlobalElectricNetworks.display(node)).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
            for (IElectricNode connected : worldNetworks.globalGraph.getConnectedNodes(node)) {
                user.m_213846_((Component)Component.m_237113_((String)" - ").m_7220_(GlobalElectricNetworks.display(connected)).m_130940_(ChatFormatting.BLUE));
                for (AbstractElectricWire wire : worldNetworks.globalGraph.getWires(node, connected)) {
                    user.m_213846_((Component)Component.m_237113_((String)("    via " + String.valueOf(wire))).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                }
            }
        }
    }

    public static void nodeHolderUnloaded(ElectricBehaviour behaviour) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(behaviour.blockEntity.m_58904_());
        for (IElectricNode iElectricNode : behaviour.getExternalNodes()) {
            if (!(iElectricNode instanceof OwnedFloatingNode)) continue;
            OwnedFloatingNode ownedNode = (OwnedFloatingNode)iElectricNode;
            worldNetworks.nodeHolderUnloaded(ownedNode);
        }
    }

    public static void nodeHolderRemoved(ElectricBehaviour behaviour) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(behaviour.blockEntity.m_58904_());
        for (IElectricNode iElectricNode : behaviour.getExternalNodes()) {
            if (!(iElectricNode instanceof OwnedFloatingNode)) continue;
            OwnedFloatingNode ownedNode = (OwnedFloatingNode)iElectricNode;
            worldNetworks.nodeHolderRemoved(ownedNode);
        }
    }

    public static void nodeHolderAdded(ElectricBehaviour behaviour) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(behaviour.blockEntity.m_58904_());
        for (OwnedFloatingNode node : behaviour.getExternalNodes()) {
            worldNetworks.nodeHolderAdded(node, behaviour.hasInternals());
        }
    }

    public static void prepareUnpaused(ElectricBehaviour behaviour) {
        WorldNetworks worldNetworks = GlobalElectricNetworks.getWorldNetworks(behaviour.blockEntity.m_58904_());
        for (OwnedFloatingNode node : behaviour.getExternalNodes()) {
            worldNetworks.prepareUnpaused(node);
        }
    }
}

