/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedTags;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.HangingWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public interface IElectric
extends IWrenchable {
    default public int terminalIndexAt(BlockState state, Vec3 pos) {
        for (int i = 0; i < this.terminalCount(); ++i) {
            ITerminalPlacement terminal = this.terminal(state, i);
            if (terminal == null || !terminal.check(pos)) continue;
            return i;
        }
        return -1;
    }

    default public ITerminalPlacement terminalAt(BlockState state, Vec3 pos) {
        for (int i = 0; i < this.terminalCount(); ++i) {
            ITerminalPlacement terminal = this.terminal(state, i);
            if (terminal == null || !terminal.check(pos)) continue;
            return terminal;
        }
        return null;
    }

    public int terminalCount();

    default public boolean accepts(ItemStack wireStack) {
        return wireStack.m_204117_(ModdedTags.Item.LIGHT_WIRES.tag);
    }

    public ITerminalPlacement terminal(BlockState var1, int var2);

    default public InteractionResult onWire(BlockState state, UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        int terminal = this.terminalIndexAt(state, context.m_43720_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        if (terminal >= 0) {
            if (!this.accepts(context.m_43722_())) {
                IElectric.sendMessage(context, (Component)Lang.translate("message.connection_incorrect_wire_type", new Object[0]).style(ChatFormatting.RED).component());
                return InteractionResult.FAIL;
            }
            if (stack.m_41782_()) {
                IWireEndpoint endpoint = WireEndpointType.deserialize(stack.m_41783_());
                if (endpoint == null) {
                    return InteractionResult.FAIL;
                }
                InteractionResult result = IElectric.makeConnection(context.m_43725_(), endpoint, new BlockWireEndpoint(pos, terminal), context);
                if (result.m_19077_()) {
                    stack.m_41751_(null);
                }
                return result;
            }
            BlockWireEndpoint endpoint = new BlockWireEndpoint(pos, terminal);
            CompoundTag tag = endpoint.serialize();
            stack.m_41751_(tag);
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_next", new Object[0]).style(ChatFormatting.GRAY).component());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    default public ElectricBehaviour getBehaviour(Level world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SmartBlockEntity) {
            SmartBlockEntity smartEntity = (SmartBlockEntity)blockEntity;
            return (ElectricBehaviour)smartEntity.getBehaviour(ElectricBehaviour.TYPE);
        }
        return null;
    }

    @Nullable
    public static IElectric getAt(Level world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof IElectric) {
            IElectric electric = (IElectric)be;
            return electric;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IElectric) {
            IElectric electric = (IElectric)block;
            return electric;
        }
        return null;
    }

    @NotNull
    public static Vec3 getTerminalPos(Level world, BlockPos position, int terminalIndex) {
        IElectric electric = IElectric.getAt(world, position);
        if (electric == null) {
            return position.m_252807_();
        }
        BlockState state = world.m_8055_(position);
        ITerminalPlacement terminal = electric.terminal(state, terminalIndex);
        if (terminal == null) {
            return position.m_252807_();
        }
        Vec3 origin = terminal.getOrigin();
        return new Vec3((double)position.m_123341_() + origin.f_82479_, (double)position.m_123342_() + origin.f_82480_, (double)position.m_123343_() + origin.f_82481_);
    }

    public static void sendMessage(UseOnContext context, Component text) {
        if (context.m_43723_() != null) {
            context.m_43723_().m_5661_(text, true);
        }
    }

    public static InteractionResult makeConnection(Level world, IWireEndpoint endpoint1, IWireEndpoint endpoint2, UseOnContext context) {
        if (endpoint1.type() == WireEndpointType.BLOCK && endpoint2.type() == WireEndpointType.BLOCK) {
            return IElectric.makeHangingWireConnection(world, (BlockWireEndpoint)endpoint1, (BlockWireEndpoint)endpoint2, context);
        }
        InteractionResultHolder<BlockWireEntity> result = WireItem.connect(world, context.m_43722_(), context.m_43723_(), endpoint1, endpoint2);
        return result.m_19089_();
    }

    public static InteractionResult makeHangingWireConnection(Level world, BlockWireEndpoint endpoint1, BlockWireEndpoint endpoint2, UseOnContext context) {
        ElectricBehaviour behaviour1 = endpoint1.getElectricBehaviour(world);
        ElectricBehaviour behaviour2 = endpoint2.getElectricBehaviour(world);
        if (behaviour1 == null || behaviour2 == null) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_failed", new Object[0]).style(ChatFormatting.RED).component());
            PowerGrid.LOGGER.error("Connection failed, at least one behaviour is null");
            return InteractionResult.FAIL;
        }
        OwnedFloatingNode node1 = endpoint1.getNode(world);
        OwnedFloatingNode node2 = endpoint2.getNode(world);
        if (node1 == null || node2 == null || node1 == node2) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_failed", new Object[0]).style(ChatFormatting.RED).component());
            PowerGrid.LOGGER.error("Connection failed, nodes: ({}, {})", (Object)node1, (Object)node2);
            return InteractionResult.FAIL;
        }
        if (behaviour1.hasConnection(endpoint1, endpoint2) || behaviour2.hasConnection(endpoint2, endpoint1)) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_exists", new Object[0]).style(ChatFormatting.RED).component());
            return InteractionResult.FAIL;
        }
        Vec3 terminal1Pos = endpoint1.getExactPosition(world);
        Vec3 terminal2Pos = endpoint2.getExactPosition(world);
        ItemStack stack = context.m_43722_();
        if (!1.$assertionsDisabled && !(stack.m_41720_() instanceof IWire)) {
            throw new AssertionError();
        }
        IWire item = (IWire)stack.m_41720_();
        CompoundTag tag = stack.m_41783_();
        if (!1.$assertionsDisabled && tag == null) {
            throw new AssertionError();
        }
        float distance = (float)terminal1Pos.m_82554_(terminal2Pos);
        if (distance > item.getMaximumLength()) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_too_long", new Object[0]).style(ChatFormatting.RED).component());
            return InteractionResult.FAIL;
        }
        int requiredItemCount = Math.max(Math.round(distance), 1);
        if (!PlayerUtilities.hasEnoughItems(context.m_43723_(), stack, requiredItemCount)) {
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_missing_items", new Object[0]).style(ChatFormatting.RED).component());
            return InteractionResult.FAIL;
        }
        if (!HangingWireEntity.checkClearance(world, endpoint1.getExactPosition(world), endpoint2.getExactPosition(world))) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        HangingWireEntity entity = HangingWireEntity.create((Level)serverWorld, endpoint1, endpoint2, new ItemStack(stack.m_220173_(), requiredItemCount), null);
        if (context.m_43723_() != null) {
            Item item2;
            ItemStack offItem = context.m_43723_().m_21206_();
            if (item.canBeColored() && (item2 = offItem.m_41720_()) instanceof DyeItem) {
                DyeItem dye = (DyeItem)item2;
                entity.setColor(dye.m_41089_());
            }
        }
        if (!serverWorld.m_8860_((Entity)entity)) {
            PowerGrid.LOGGER.error("Failed to spawn new connection wire entity.");
            IElectric.sendMessage(context, (Component)Lang.translate("message.connection_failed", new Object[0]).style(ChatFormatting.RED).component());
            return InteractionResult.FAIL;
        }
        if (context.m_43723_() == null || !context.m_43723_().m_7500_()) {
            stack.m_41774_(requiredItemCount);
        }
        return InteractionResult.SUCCESS;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

