/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base.terminals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.SimpleTerminalCollectionBuilder;

public class RotatedTerminalCollection {
    private final TerminalBoundingBox[][] terminals;

    private RotatedTerminalCollection(TerminalBoundingBox[][] terminals) {
        this.terminals = terminals;
    }

    public TerminalBoundingBox get(Direction dir, int index) {
        return this.terminals[dir.ordinal()][index];
    }

    public static Builder builder(ITerminalRotator rotator) {
        return new Builder(rotator);
    }

    public static TerminalBoundingBox rotateNorthToFacing(TerminalBoundingBox terminal, Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> terminal;
            case Direction.SOUTH -> terminal.rotateAroundY(Rotation.CLOCKWISE_180);
            case Direction.EAST -> terminal.rotateAroundY(Rotation.CLOCKWISE_90);
            case Direction.WEST -> terminal.rotateAroundY(Rotation.COUNTERCLOCKWISE_90);
            case Direction.UP -> terminal.rotateAroundX(Rotation.COUNTERCLOCKWISE_90);
            case Direction.DOWN -> terminal.rotateAroundX(Rotation.CLOCKWISE_90);
        };
    }

    public static class Builder
    extends SimpleTerminalCollectionBuilder<Builder, RotatedTerminalCollection> {
        private final ITerminalRotator rotator;
        private final List<Direction> directions = new ArrayList<Direction>();

        private Builder(ITerminalRotator rotator) {
            this.rotator = rotator;
        }

        public Builder with(Direction direction) {
            this.directions.add(direction);
            return this;
        }

        public Builder with(Direction ... directions) {
            Collections.addAll(this.directions, directions);
            return this;
        }

        @Override
        public RotatedTerminalCollection build() {
            TerminalBoundingBox[][] terminals = new TerminalBoundingBox[6][this.terminals.size()];
            for (Direction dir : this.directions) {
                for (int i = 0; i < this.terminals.size(); ++i) {
                    terminals[dir.ordinal()][i] = this.rotator.rotate((TerminalBoundingBox)this.terminals.get(i), dir);
                }
            }
            return new RotatedTerminalCollection(terminals);
        }
    }

    public static interface ITerminalRotator {
        public TerminalBoundingBox rotate(TerminalBoundingBox var1, Direction var2);
    }
}

