/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electricswitch;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.electricswitch.HvSwitchBlock;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.kinetics.base.ElectricKineticBlockEntity;

public class HvSwitchBlockEntity
extends ElectricKineticBlockEntity {
    protected LerpedFloat rod = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);
    private SwitchedWire wire;
    private int state = 1;

    public HvSwitchBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig((SmartBlockEntity)this);
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        Direction facing = (Direction)this.m_58900_().m_61143_(HvSwitchBlock.HORIZONTAL_FACING);
        if (facing == Direction.NORTH || facing == Direction.EAST) {
            speed = -speed;
        }
        this.rod.chase(speed > 0.0f ? 1.0 : 0.0, (double)this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        this.sendData();
    }

    private float getChaseSpeed() {
        return Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 21.0f / 20.0f), (float)0.0f, (float)1.0f);
    }

    public void initialize() {
        super.initialize();
        this.wire.setState(false);
        this.wire.setResistance(this.getResistance());
        this.wire.setState(this.isClosed());
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        this.rod.tickChaser();
        if (!(this.rod.settled() || this.wire.getState() == this.isClosed() && this.wire.getResistance() == (double)this.getResistance())) {
            this.wire.setState(false);
            this.wire.setResistance(this.getResistance());
            this.wire.setState(this.isClosed());
            this.m_6596_();
        }
    }

    public void tickAudio() {
        assert (this.f_58857_ != null);
        super.tickAudio();
        int newState = 1;
        if (this.rod.getValue() == 1.0f) {
            newState = 2;
        }
        if (this.rod.getValue() == 0.0f) {
            newState = 0;
        }
        if (newState != this.state) {
            this.state = newState;
            if (this.state == 2) {
                this.f_58857_.m_245747_(this.m_58899_(), ModdedSoundEvents.HV_SWITCH_DISCONNECT.getMainEvent(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
            } else if (this.state == 0) {
                this.f_58857_.m_245747_(this.m_58899_(), ModdedSoundEvents.HV_SWITCH_CONNECT.getMainEvent(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
            }
        }
    }

    public boolean isClosed() {
        if (this.rod == null) {
            return false;
        }
        return this.rod.getValue() > 0.9f;
    }

    public float getResistance() {
        if (this.rod == null || !this.isClosed()) {
            return this.resistance();
        }
        float x = this.rod.getValue();
        return -999.0f * x + 999.0f + this.resistance();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Rod", (Tag)this.rod.writeNBT());
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        tag.m_128365_("Rod", (Tag)this.rod.writeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.rod.readNBT(compound.m_128469_("Rod"), false);
        if (this.wire != null) {
            this.wire.setState(false);
            this.wire.setResistance(this.getResistance());
            this.wire.setState(this.isClosed());
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connectSwitch(this.getResistance(), builder.terminalNode(0), builder.terminalNode(1), this.isClosed());
    }
}

