/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.info;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import java.util.Iterator;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.powercord.CordItem;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordPlacementHandler;

public class TerminalHandler {
    private static final Object outlineSlot = new Object();
    private static IDecoratedTerminal targetTerminal = null;

    public static void tick(ClientLevel world) {
        targetTerminal = null;
        Minecraft client = Minecraft.m_91087_();
        HitResult target = client.f_91077_;
        if (target == null || target.m_6662_() == HitResult.Type.MISS || client.f_91074_ == null) {
            return;
        }
        ItemStack mainItem = client.f_91074_.m_21205_();
        ItemStack offItem = client.f_91074_.m_21206_();
        if (!(mainItem != null && !mainItem.m_41619_() && mainItem.m_41720_() instanceof IWire || offItem != null && !offItem.m_41619_() && offItem.m_41720_() instanceof IWire || GogglesItem.isWearingGoggles((Player)client.f_91074_))) {
            return;
        }
        if (target instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)target;
            ITerminalPlacement terminal = null;
            BlockPos blockPos = blockHit.m_82425_();
            BlockState state = world.m_8055_(blockPos);
            IElectric electric = IElectric.getAt((Level)world, blockPos);
            if (electric != null) {
                terminal = electric.terminalAt(state, blockHit.m_82450_().m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()));
            }
            if (terminal == null && (mainItem != null && mainItem.m_41720_() instanceof CordItem || offItem != null && offItem.m_41720_() instanceof CordItem)) {
                ICordPlacementHandler handler;
                Iterator<ICordPlacementHandler> iterator = CordItem.PLACEMENT_HANDLERS.iterator();
                while (iterator.hasNext() && (terminal = (handler = iterator.next()).terminal(state, (Level)world, blockHit)) == null) {
                }
            }
            if (!(terminal instanceof IDecoratedTerminal)) {
                return;
            }
            IDecoratedTerminal decorated = (IDecoratedTerminal)((Object)terminal);
            targetTerminal = decorated;
            Outliner.getInstance().chaseAABB(outlineSlot, decorated.getOutline().m_82338_(blockPos)).colored(decorated.getColor()).withFaceTexture((BindableTexture)AllSpecialTextures.CUTOUT_CHECKERED).lineWidth(0.02f);
        }
    }

    @Nullable
    public static Component overlayText(Player player) {
        if (targetTerminal == null) {
            return null;
        }
        return targetTerminal.getName();
    }
}

