/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.solver;

import java.util.Random;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.PerformanceCounter;
import org.patryk3211.powergrid.electricity.sim.solver.DynamicallyTypedMatrix;
import org.patryk3211.powergrid.electricity.sim.solver.ISolver;

public class BiCGSTABSolver
implements ISolver {
    private static final boolean USE_RANDOM_HAT_RESIDUAL = true;
    private static final int MAX_ITERATIONS = 300;
    private static final PerformanceCounter PERF = new PerformanceCounter("BiCGStab");
    private final Random random;
    private DMatrixRMaj guess;
    private DMatrixRMaj residual;
    private DMatrixRMaj hatResidual;
    private DMatrixRMaj p;
    private DMatrixRMaj v;
    private DMatrixRMaj h;
    private DMatrixRMaj s;
    private DMatrixRMaj t;
    private DMatrixRMaj y;
    private DMatrixRMaj z;
    private int solveCount = 0;
    private DMatrixRMaj L;
    private DMatrixRMaj U;
    private boolean shouldCalculateLU;
    private double targetPrecision;
    private final double maxAllowed;

    public BiCGSTABSolver(double targetPrecision, double maxAllowed) {
        this.targetPrecision = targetPrecision;
        this.maxAllowed = maxAllowed;
        this.random = new Random();
    }

    @Override
    public void setTargetPrecision(double targetPrecision) {
        this.targetPrecision = targetPrecision;
    }

    @Override
    public void setStateSize(int newSize) {
        if (this.guess == null || this.guess.getNumRows() != newSize) {
            this.guess = new DMatrixRMaj(newSize, 1);
            this.residual = new DMatrixRMaj(newSize, 1);
            this.hatResidual = new DMatrixRMaj(newSize, 1);
            this.p = new DMatrixRMaj(newSize, 1);
            this.v = new DMatrixRMaj(newSize, 1);
            this.h = new DMatrixRMaj(newSize, 1);
            this.s = new DMatrixRMaj(newSize, 1);
            this.t = new DMatrixRMaj(newSize, 1);
            this.y = new DMatrixRMaj(newSize, 1);
            this.z = new DMatrixRMaj(newSize, 1);
            this.shouldCalculateLU = true;
            this.L = new DMatrixRMaj(newSize, newSize);
            this.U = new DMatrixRMaj(newSize, newSize);
        }
    }

    @Override
    public void zero() {
        if (this.guess != null) {
            this.guess.zero();
            this.residual.zero();
            this.hatResidual.zero();
            this.p.zero();
            this.v.zero();
            this.h.zero();
            this.s.zero();
            this.t.zero();
            this.shouldCalculateLU = true;
        }
    }

    private void prepareILU(DynamicallyTypedMatrix A) {
        this.shouldCalculateLU = false;
        this.L.zero();
        this.U.zero();
        int n = A.getNumRows();
        for (int j = 0; j < n; ++j) {
            this.U.set(0, j, A.get(0, j));
        }
        for (int i = 1; i < n; ++i) {
            for (int k = 0; k < i - 1; ++k) {
                double Aij;
                int j;
                double Ukk = this.U.get(k, k);
                if (Ukk == 0.0) continue;
                double Lik = A.get(i, k) / Ukk;
                this.L.set(i, k, Lik);
                for (j = k + 1; j < i - 1; ++j) {
                    Aij = A.get(i, j);
                    if (Aij == 0.0) continue;
                    this.L.set(i, j, Aij - Lik * this.U.get(k, j));
                }
                for (j = i; j < n; ++j) {
                    Aij = A.get(i, j);
                    if (Aij == 0.0) continue;
                    this.U.set(i, j, Aij - Lik * this.U.get(k, j));
                }
            }
        }
    }

    private void preconditioned(DynamicallyTypedMatrix K, DMatrixRMaj input, DMatrixRMaj output) {
        int j;
        double b;
        int i;
        for (i = 0; i < input.getNumRows(); ++i) {
            b = input.get(i, 0);
            for (j = 0; j < i; ++j) {
                b -= this.L.get(i, j) * output.get(j);
            }
            output.set(i, 0, b);
        }
        for (i = input.getNumRows() - 1; i >= 0; --i) {
            b = output.get(i, 0);
            for (j = i + 1; j < input.getNumRows(); ++j) {
                b -= this.U.get(i, j) * output.get(j);
            }
            if (this.U.get(i, i) == 0.0) continue;
            output.set(i, 0, b / this.U.get(i, i));
        }
    }

    private double pickHatResidual() {
        RandomMatrices_DDRM.fillUniform((DMatrixRMaj)this.hatResidual, (Random)this.random);
        double dot = CommonOps_DDRM.dot((DMatrixD1)this.hatResidual, (DMatrixD1)this.residual);
        if (dot == 0.0) {
            this.hatResidual.setTo((DMatrixD1)this.residual);
            return 1.0;
        }
        return dot;
    }

    @Override
    @Nullable
    public DMatrixRMaj solve(DynamicallyTypedMatrix A, DMatrixRMaj b, boolean acceptAll) {
        double norm;
        if (b.getNumRows() == 0) {
            return this.guess;
        }
        PERF.start();
        if (this.shouldCalculateLU || this.solveCount++ >= 20) {
            this.prepareILU(A);
            this.solveCount = 0;
        }
        A.mult(this.guess, this.v);
        CommonOps_DDRM.subtract((DMatrixD1)b, (DMatrixD1)this.v, (DMatrixD1)this.residual);
        double initialDistance = norm = NormOps_DDRM.normP2((DMatrixRMaj)this.residual);
        if (norm <= this.targetPrecision) {
            return this.guess;
        }
        double dot = this.pickHatResidual();
        this.p.setTo((DMatrixD1)this.residual);
        int iters = 0;
        while (iters++ < 300) {
            this.preconditioned(A, this.p, this.y);
            A.mult(this.y, this.v);
            double alpha = dot / CommonOps_DDRM.dot((DMatrixD1)this.hatResidual, (DMatrixD1)this.v);
            CommonOps_DDRM.add((DMatrixD1)this.guess, (double)alpha, (DMatrixD1)this.y, (DMatrixD1)this.h);
            CommonOps_DDRM.add((DMatrixD1)this.residual, (double)(-alpha), (DMatrixD1)this.v, (DMatrixD1)this.s);
            norm = NormOps_DDRM.normP2((DMatrixRMaj)this.s);
            if (norm <= this.targetPrecision) {
                this.guess.setTo((DMatrixD1)this.h);
                break;
            }
            this.preconditioned(A, this.s, this.z);
            A.mult(this.z, this.t);
            double omega = CommonOps_DDRM.dot((DMatrixD1)this.t, (DMatrixD1)this.s) / CommonOps_DDRM.dot((DMatrixD1)this.t, (DMatrixD1)this.t);
            CommonOps_DDRM.add((DMatrixD1)this.h, (double)omega, (DMatrixD1)this.z, (DMatrixD1)this.guess);
            CommonOps_DDRM.add((DMatrixD1)this.s, (double)(-omega), (DMatrixD1)this.t, (DMatrixD1)this.residual);
            norm = NormOps_DDRM.normP2((DMatrixRMaj)this.residual);
            if (norm <= this.targetPrecision) break;
            double dotPrev = dot;
            dot = CommonOps_DDRM.dot((DMatrixD1)this.hatResidual, (DMatrixD1)this.residual);
            double beta = dot / dotPrev * (alpha / omega);
            CommonOps_DDRM.add((DMatrixD1)this.p, (double)(-omega), (DMatrixD1)this.v, (DMatrixD1)this.t);
            CommonOps_DDRM.add((DMatrixD1)this.residual, (double)beta, (DMatrixD1)this.t, (DMatrixD1)this.p);
        }
        PERF.end();
        if (iters >= 300) {
            String prefix;
            String string = prefix = acceptAll ? "(AcceptAll) " : "";
            if (ElectricalNetwork.LOGGER != null) {
                if (ModdedConfigs.logsEnabled()) {
                    ElectricalNetwork.LOGGER.warn("{}Solver iteration limit, final precision: {}", (Object)prefix, (Object)norm);
                }
            } else {
                System.out.printf("%sSolver iteration limit, final precision: %g", prefix, norm);
            }
            if (!acceptAll) {
                if (norm > this.maxAllowed && initialDistance / norm < 10.0) {
                    if (ElectricalNetwork.LOGGER != null && ModdedConfigs.logsEnabled()) {
                        ElectricalNetwork.LOGGER.warn("Large imprecision, dropping iterative result");
                    }
                    A.solve(b, this.guess);
                    return this.guess;
                }
            } else if (initialDistance / norm < 1.0) {
                if (ElectricalNetwork.LOGGER != null && ModdedConfigs.logsEnabled()) {
                    ElectricalNetwork.LOGGER.info("(AcceptAll) Large imprecision, dropping iterative result");
                }
                A.solve(b, this.guess);
                return this.guess;
            }
        }
        return this.guess;
    }

    @Override
    public DMatrixRMaj getLastGuess() {
        return this.guess;
    }
}

