/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.IOuterHook;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.solver.ISolverHook;

public class InductorWire
extends AbstractElectricWire
implements ISolverHook,
IOuterHook {
    private double inductance;
    private double Ieq;
    private double I;

    public InductorWire(double inductance, IElectricNode node1, IElectricNode node2) {
        super(node1, node2);
        this.inductance = inductance;
    }

    @Override
    public double conductance() {
        return 0.05 / (2.0 * this.inductance);
    }

    @Override
    public float current() {
        return (float)((double)super.current() + this.Ieq);
    }

    public void setCurrent(float current) {
        this.valueChange(current, this.I);
        if (Float.isFinite(current)) {
            this.I = current;
        }
    }

    @Override
    public void postUpperSolve() {
        if (this.isConverged()) {
            this.I = this.current();
        }
    }

    @Override
    public void startIteration() {
        double G = this.conductance();
        double V = this.inductance * ((double)this.current() - this.I) / (double)0.05f;
        this.Ieq = (V * G + this.I) * 0.99999;
    }

    @Override
    public void addResidual(IResidualAdder residual) {
        if (this.node1 != null) {
            residual.add(this.node1.getIndex(), this.Ieq);
        }
        if (this.node2 != null) {
            residual.add(this.node2.getIndex(), -this.Ieq);
        }
    }

    public void setInductance(float inductance) {
        double oldConductance = this.conductance();
        this.inductance = inductance;
        if (this.network != null) {
            this.network.updateConductance(this, this.conductance() - oldConductance);
        }
    }
}

