/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;

public class TransmissionLinePart
extends ElectricWire {
    @Nullable
    private TransmissionLine line;
    @NotNull
    private final WorldNetworks global;
    @Nullable
    public BaseWireEntity owner;
    public final WorldNetworks.PartId persistentOwnerId;
    public ChunkPos lastKnownChunk;
    @NotNull
    public IWireEndpoint endpoint1;
    @NotNull
    public IWireEndpoint endpoint2;

    private TransmissionLinePart(double resistance, @NotNull IWireEndpoint endpoint1, @NotNull IWireEndpoint endpoint2, WorldNetworks.PartId ownerId, ChunkPos lastKnownChunk, @NotNull WorldNetworks global) {
        super(resistance, global.holderOrPlaceholderNode(endpoint1), global.holderOrPlaceholderNode(endpoint2));
        this.global = global;
        this.endpoint1 = endpoint1;
        this.endpoint2 = endpoint2;
        this.persistentOwnerId = ownerId;
        this.lastKnownChunk = lastKnownChunk;
        global.registerPart(this.persistentOwnerId, this);
    }

    private TransmissionLinePart(double resistance, @NotNull IWireEndpoint endpoint1, @NotNull IWireEndpoint endpoint2, @NotNull BaseWireEntity owner, @NotNull WorldNetworks global, WorldNetworks.PartId id) {
        super(resistance, global.holderOrPlaceholderNode(endpoint1), global.holderOrPlaceholderNode(endpoint2));
        this.global = global;
        this.owner = owner;
        this.endpoint1 = endpoint1;
        this.endpoint2 = endpoint2;
        this.persistentOwnerId = id;
        this.lastKnownChunk = new ChunkPos(owner.m_20183_());
        global.registerPart(this.persistentOwnerId, this);
    }

    public static TransmissionLinePart uniquePart(CompoundTag tag, WorldNetworks global) {
        Record ownerId = tag.m_128441_("ComplexOwner") ? new WorldNetworks.ComplexId(tag.m_128342_("Owner"), tag.m_128451_("ComplexOwner")) : new WorldNetworks.SimpleId(tag.m_128342_("Owner"));
        double resistance = tag.m_128459_("Resistance");
        IWireEndpoint endpoint1 = WireEndpointType.deserialize(tag.m_128469_("Node1"));
        IWireEndpoint endpoint2 = WireEndpointType.deserialize(tag.m_128469_("Node2"));
        ChunkPos lastKnownChunk = new ChunkPos(tag.m_128451_("X"), tag.m_128451_("Z"));
        TransmissionLinePart part = global.getPart((WorldNetworks.PartId)((Object)ownerId));
        if (part == null) {
            return new TransmissionLinePart(resistance, endpoint1, endpoint2, (WorldNetworks.PartId)((Object)ownerId), lastKnownChunk, global);
        }
        if (!endpoint1.equals(part.endpoint1)) {
            throw new IllegalStateException();
        }
        if (!endpoint2.equals(part.endpoint2)) {
            throw new IllegalStateException();
        }
        return part;
    }

    public static TransmissionLinePart uniquePart(double resistance, @NotNull IWireEndpoint endpoint1, @NotNull IWireEndpoint endpoint2, BaseWireEntity owner, @NotNull WorldNetworks global, WorldNetworks.PartId id) {
        TransmissionLinePart part = global.getPart(id);
        if (part == null) {
            return new TransmissionLinePart(resistance, endpoint1, endpoint2, owner, global, id);
        }
        if (!endpoint1.equals(part.endpoint1)) {
            throw new IllegalStateException();
        }
        if (!endpoint2.equals(part.endpoint2)) {
            throw new IllegalStateException();
        }
        return part;
    }

    @Override
    public void setNode1(IElectricNode node1) {
        assert (node1 instanceof OwnedFloatingNode);
        super.setNode1(Objects.requireNonNull(node1));
    }

    @Override
    public void setNode2(IElectricNode node2) {
        assert (node2 instanceof OwnedFloatingNode);
        super.setNode2(Objects.requireNonNull(node2));
    }

    @Override
    public void flipNodes() {
        super.flipNodes();
        IWireEndpoint endpoint = this.endpoint1;
        this.endpoint1 = this.endpoint2;
        this.endpoint2 = endpoint;
    }

    @Override
    public OwnedFloatingNode getNode1() {
        return (OwnedFloatingNode)this.node1;
    }

    @Override
    public OwnedFloatingNode getNode2() {
        return (OwnedFloatingNode)this.node2;
    }

    @NotNull
    public IWireEndpoint getEndpoint1() {
        return this.endpoint1;
    }

    @NotNull
    public IWireEndpoint getEndpoint2() {
        return this.endpoint2;
    }

    @Nullable
    public TransmissionLine getLine() {
        return this.line;
    }

    public void setLine(@Nullable TransmissionLine line) {
        this.line = line;
    }

    public void unload() {
        assert (this.owner != null) : "Node already unloaded";
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("{}: Unloading part, UUID={}, chunk={}", new Object[]{this.line, this.persistentOwnerId, this.lastKnownChunk});
        }
        this.lastKnownChunk = new ChunkPos(this.owner.m_20183_());
        this.global.bounty(this.persistentOwnerId, this.lastKnownChunk);
        this.owner = null;
    }

    public void grab(BaseWireEntity forEntity, WorldNetworks.PartId id) {
        if (this.persistentOwnerId.equals(id)) {
            this.owner = forEntity;
            if (this.line != null) {
                this.line.grabPart(forEntity, this);
            }
        } else {
            PowerGrid.LOGGER.warn("Entity tried to grab a part which it does not own, part: {}, entity: {}", (Object)this, (Object)forEntity);
        }
    }

    @Override
    public void setNetwork(ElectricalNetwork network) {
        throw new IllegalCallerException();
    }

    @Override
    public void remove() {
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("Removing {}", (Object)this);
        }
        if (this.line != null) {
            this.line.remove(this);
        }
        this.global.unregisterPart(this.persistentOwnerId, this);
    }

    @Override
    public float potentialDifference() {
        if (this.line == null) {
            return 0.0f;
        }
        return (float)((double)this.line.current() * this.getResistance());
    }

    @Override
    public float current() {
        if (this.line == null) {
            return 0.0f;
        }
        return this.line.current();
    }

    @Override
    public boolean isConverged() {
        if (this.line == null) {
            return false;
        }
        return this.line.isConverged();
    }

    public String toString() {
        return String.format("LinePart[id=%s, %s, %s]", this.persistentOwnerId, this.endpoint1, this.endpoint2);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Node1", (Tag)this.endpoint1.serialize());
        tag.m_128365_("Node2", (Tag)this.endpoint2.serialize());
        WorldNetworks.PartId partId = this.persistentOwnerId;
        if (partId instanceof WorldNetworks.SimpleId) {
            WorldNetworks.SimpleId id = (WorldNetworks.SimpleId)partId;
            tag.m_128362_("Owner", id.id());
        } else {
            partId = this.persistentOwnerId;
            if (partId instanceof WorldNetworks.ComplexId) {
                WorldNetworks.ComplexId id = (WorldNetworks.ComplexId)partId;
                tag.m_128362_("Owner", id.id());
                tag.m_128405_("ComplexOwner", id.sub());
            }
        }
        if (this.owner != null) {
            this.lastKnownChunk = new ChunkPos(this.owner.m_20183_());
        }
        tag.m_128405_("X", this.lastKnownChunk.f_45578_);
        tag.m_128405_("Z", this.lastKnownChunk.f_45579_);
        tag.m_128347_("Resistance", this.resistance);
        return tag;
    }

    public void refreshEndpointNodes() {
        OwnedFloatingNode node2;
        OwnedFloatingNode node1 = this.endpoint1.getNode(this.global.world);
        if (this.node1 != node1) {
            this.global.addAndMigrateNode(this.getNode1().endpoint, node1);
            this.setNode1(node1);
        }
        if (this.node2 != (node2 = this.endpoint2.getNode(this.global.world))) {
            this.global.addAndMigrateNode(this.getNode2().endpoint, node2);
            this.setNode2(node2);
        }
    }
}

