/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.transformer;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlockEntity;
import org.patryk3211.powergrid.electricity.transformer.TransformerCoilParameters;
import org.patryk3211.powergrid.electricity.transformer.TransformerCoreBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerWindingScreen;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public abstract class TransformerBlock
extends ElectricBlock {
    public static final IntegerProperty COILS = IntegerProperty.m_61631_((String)"coils", (int)0, (int)2);
    private final int maxTurns;

    public TransformerBlock(BlockBehaviour.Properties settings, int maxTurns) {
        super(settings);
        this.maxTurns = maxTurns;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return ((TransformerCoreBlock)((Object)ModdedBlocks.TRANSFORMER_CORE.get())).m_7397_(world, pos, state);
    }

    public abstract Optional<TransformerBlockEntity> getBlockEntity(Level var1, BlockPos var2, BlockState var3);

    protected abstract boolean isInitiator(BlockPos var1, BlockState var2, BlockPos var3);

    @Override
    public ElectricBehaviour getBehaviour(Level world, BlockPos pos, BlockState state) {
        Optional<TransformerBlockEntity> be = this.getBlockEntity(world, pos, state);
        return be.map(ElectricBlockEntity::getElectricBehaviour).orElse(null);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        BlockEntity be = (BlockEntity)params.m_287159_(LootContextParams.f_81462_);
        if (!(be instanceof TransformerBlockEntity)) {
            return super.m_49635_(state, params);
        }
        TransformerBlockEntity tbe = (TransformerBlockEntity)be;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.m_49635_(state, params));
        int turns = 0;
        if (tbe.getSecondary() != null) {
            turns += tbe.getSecondary().getTurns();
        }
        if (tbe.getPrimary() != null) {
            turns += tbe.getPrimary().getTurns();
        }
        while (turns > 0) {
            ItemStack stack = ModdedItems.WIRE.asStack(Math.min(turns, 64));
            drops.add(stack);
            turns -= 64;
        }
        return drops;
    }

    public InteractionResult onWinding(BlockState state, UseOnContext context) {
        BlockPos pos = context.m_8083_();
        int terminal = this.terminalIndexAt(state, context.m_43720_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        ItemStack stack = context.m_43722_();
        CompoundTag nbt = stack.m_41783_();
        int turns = nbt.m_128451_("Turns");
        return this.getBlockEntity(context.m_43725_(), context.m_8083_(), state).map(be -> {
            if (terminal >= 0) {
                int firstTerminal = nbt.m_128451_("Terminal");
                if (terminal == firstTerminal) {
                    IElectric.sendMessage(context, (Component)Lang.translate("message.coil_same_terminal", new Object[0]).style(ChatFormatting.RED).component());
                    return InteractionResult.FAIL;
                }
                Player player = context.m_43723_();
                if (!PlayerUtilities.hasEnoughItems(player, stack, turns)) {
                    IElectric.sendMessage(context, (Component)Lang.translate("message.coil_missing_items", new Object[0]).style(ChatFormatting.RED).component());
                    return InteractionResult.FAIL;
                }
                if (be.hasPrimary()) {
                    if (turns + be.getPrimary().getTurns() > this.maxTurns) {
                        IElectric.sendMessage(context, (Component)Lang.translate("message.coil_max_turns", new Object[0]).style(ChatFormatting.RED).component());
                        return InteractionResult.FAIL;
                    }
                } else if (turns > this.maxTurns) {
                    IElectric.sendMessage(context, (Component)Lang.translate("message.coil_max_turns", new Object[0]).style(ChatFormatting.RED).component());
                    return InteractionResult.FAIL;
                }
                if (!context.m_43725_().f_46443_) {
                    if (be.hasPrimary()) {
                        be.makeSecondary(firstTerminal, terminal, turns, stack.m_41720_());
                    } else {
                        be.makePrimary(firstTerminal, terminal, turns, stack.m_41720_());
                    }
                    PlayerUtilities.removeItems(player, stack, turns);
                    stack.m_41751_(null);
                }
                return InteractionResult.SUCCESS;
            }
            if (context.m_43725_().f_46443_) {
                int cap = be.hasPrimary() ? be.getPrimary().getTurns() : 0;
                boolean b = TransformerWindingScreen.beginInteraction(() -> new TransformerWindingScreen(this, context.m_43724_(), turns, cap));
                return b ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.FAIL);
    }

    @Override
    public InteractionResult onWire(BlockState state, UseOnContext context) {
        CompoundTag nbt;
        ItemStack stack = context.m_43722_();
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("Turns")) {
            int[] posArray = nbt.m_128465_("Initiator");
            BlockPos initiatorPosition = new BlockPos(posArray[0], posArray[1], posArray[2]);
            if (this.isInitiator(context.m_8083_(), state, initiatorPosition)) {
                return this.onWinding(state, context);
            }
            return InteractionResult.FAIL;
        }
        InteractionResult result = super.onWire(state, context);
        if (result == InteractionResult.PASS && stack.m_41782_()) {
            if (!stack.m_150930_((Item)ModdedItems.WIRE.get())) {
                return InteractionResult.FAIL;
            }
            return this.getBlockEntity(context.m_43725_(), context.m_8083_(), state).map(be -> {
                CompoundTag nbt = stack.m_41783_();
                IWireEndpoint endpoint = WireEndpointType.deserialize(nbt);
                if (endpoint.type() != WireEndpointType.BLOCK) {
                    return InteractionResult.FAIL;
                }
                BlockWireEndpoint blockEndpoint = (BlockWireEndpoint)endpoint;
                if (be.isTerminalUsed(blockEndpoint.getTerminal())) {
                    IElectric.sendMessage(context, (Component)Lang.translate("message.coil_exists", new Object[0]).style(ChatFormatting.RED).component());
                    return InteractionResult.FAIL;
                }
                if (this.isInitiator(context.m_8083_(), state, blockEndpoint.getPos())) {
                    if (context.m_43725_().f_46443_) {
                        int cap = be.hasPrimary() ? be.getPrimary().getTurns() : 0;
                        boolean b = TransformerWindingScreen.beginInteraction(() -> new TransformerWindingScreen(this, context.m_43724_(), 1, cap));
                        return b ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }).orElse(InteractionResult.FAIL);
        }
        return result;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModdedItems.WIRE_CUTTER.get()) && !world.f_46443_) {
            Optional<TransformerBlockEntity> be = this.getBlockEntity(world, pos, state);
            if (be.isEmpty()) {
                return InteractionResult.FAIL;
            }
            if (be.get().hasSecondary()) {
                if (!player.m_7500_()) {
                    int count;
                    TransformerCoilParameters coil = be.get().getSecondary();
                    Item item = coil.getItem();
                    for (int items = count = coil.getTurns(); items > 0; items -= 64) {
                        player.m_36356_(new ItemStack((ItemLike)item, Math.min(64, items)));
                    }
                }
                be.get().removeSecondary();
                return InteractionResult.SUCCESS;
            }
            if (be.get().hasPrimary()) {
                if (!player.m_7500_()) {
                    int count;
                    TransformerCoilParameters coil = be.get().getPrimary();
                    Item item = coil.getItem();
                    for (int items = count = coil.getTurns(); items > 0; items -= 64) {
                        player.m_36356_(new ItemStack((ItemLike)item, Math.min(64, items)));
                    }
                }
                be.get().removePrimary();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public int getMaxTurns() {
        return this.maxTurns;
    }
}

