/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.DeferredJunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.equipment.multimeter.MultimeterItem;
import org.patryk3211.powergrid.network.packets.EntityDataS2CPacket;

public abstract class BaseWireEntity
extends Entity
implements EntityDataS2CPacket.IConsumer {
    protected static final EntityDataAccessor<Float> TEMPERATURE = SynchedEntityData.m_135353_(BaseWireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Byte> OVERHEAT_TICKS = SynchedEntityData.m_135353_(BaseWireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected IWireEndpoint endpoint1;
    protected IWireEndpoint endpoint2;
    protected byte deferEndpointResolution = 0;
    protected int deferTicks = 0;
    @NotNull
    private WireItem item;
    private int itemCount;
    private int color;
    protected float overheatTemperature = 175.0f;
    private int despawnTime = 0;
    private int dataVersion = 0;
    private float dissipationFactor;
    private float thermalMass;
    protected Float resistanceOverride = null;

    public BaseWireEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public abstract float current();

    protected void m_8097_() {
        this.f_19804_.m_135372_(TEMPERATURE, (Object)Float.valueOf(22.0f));
        this.f_19804_.m_135372_(OVERHEAT_TICKS, (Object)0);
    }

    private void temperatureUpdate() {
        if (!((Boolean)ModdedConfigs.server().electricity.wireOverheating.get()).booleanValue()) {
            return;
        }
        if (this.m_9236_().f_46443_ && !(this.m_9236_() instanceof PonderLevel)) {
            return;
        }
        float temperature = ((Float)this.f_19804_.m_135370_(TEMPERATURE)).floatValue();
        float energy = 0.0f;
        float I = this.current();
        energy += I * I * this.getResistance() / 20.0f;
        if (!this.isOverheated()) {
            if ((temperature += (energy -= this.dissipationFactor * (temperature - 22.0f) / 20.0f) / this.thermalMass) > this.overheatTemperature && energy > 0.0f) {
                this.f_19804_.m_135381_(OVERHEAT_TICKS, (Object)((byte)((Byte)this.f_19804_.m_135370_(OVERHEAT_TICKS) + 1)));
            } else if (energy <= 0.0f) {
                this.f_19804_.m_135381_(OVERHEAT_TICKS, (Object)0);
                if (temperature > this.overheatTemperature + 10.0f) {
                    temperature = this.overheatTemperature + 10.0f;
                }
            }
        }
        this.f_19804_.m_135381_(TEMPERATURE, (Object)Float.valueOf(temperature));
    }

    public boolean isOverheated() {
        return ((Float)this.f_19804_.m_135370_(TEMPERATURE)).floatValue() >= this.overheatTemperature && (Byte)this.f_19804_.m_135370_(OVERHEAT_TICKS) >= 2;
    }

    public float getTemperature() {
        return ((Float)this.f_19804_.m_135370_(TEMPERATURE)).floatValue();
    }

    public void m_8119_() {
        Level world = this.m_9236_();
        this.temperatureUpdate();
        this.m_6075_();
        if ((this.deferEndpointResolution & 1) != 0 && this.endpoint1 != null && this.endpoint1.isValid(world)) {
            this.endpoint1.assignWireEntity(this);
            this.deferEndpointResolution = (byte)(this.deferEndpointResolution & 0xFFFFFFFE);
            this.makeWire();
        }
        if ((this.deferEndpointResolution & 2) != 0 && this.endpoint2 != null && this.endpoint2.isValid(world)) {
            this.endpoint2.assignWireEntity(this);
            this.deferEndpointResolution = (byte)(this.deferEndpointResolution & 0xFFFFFFFD);
            this.makeWire();
        }
        if (this.isOverheated()) {
            this.dropWire();
            if (!world.f_46443_) {
                if (this.despawnTime == 0) {
                    ModdedSoundEvents.WIRE_BURNED.playFrom((Entity)this);
                }
                if (++this.despawnTime >= 5) {
                    this.m_146870_();
                }
            }
        }
        this.f_19803_ = false;
    }

    public void setEndpoint1(IWireEndpoint endpoint) {
        assert (endpoint == null || endpoint.canAcceptType(this.getClass())) : "Endpoint doesn't accept this entity type";
        if (this.endpoint1 != endpoint) {
            if (this.endpoint1 != null) {
                this.endpoint1.removeWireEntity(this);
            }
            Level world = this.m_9236_();
            if (endpoint != null) {
                if (endpoint.type() == WireEndpointType.DEFERRED_JUNCTION) {
                    endpoint = ((DeferredJunctionWireEndpoint)endpoint).resolve(world);
                }
                if (endpoint != null) {
                    if (endpoint.isValid(world)) {
                        endpoint.assignWireEntity(this);
                    } else {
                        this.deferEndpointResolution = (byte)(this.deferEndpointResolution | 1);
                        this.deferTicks = 0;
                    }
                }
            }
            this.endpoint1 = endpoint;
            this.makeWire();
        }
    }

    public void setEndpoint2(IWireEndpoint endpoint) {
        assert (endpoint == null || endpoint.canAcceptType(this.getClass())) : "Endpoint doesn't accept this entity type";
        if (this.endpoint2 != endpoint) {
            if (this.endpoint2 != null) {
                this.endpoint2.removeWireEntity(this);
            }
            Level world = this.m_9236_();
            if (endpoint != null) {
                if (endpoint.type() == WireEndpointType.DEFERRED_JUNCTION) {
                    endpoint = ((DeferredJunctionWireEndpoint)endpoint).resolve(world);
                }
                if (endpoint != null) {
                    if (endpoint.isValid(world)) {
                        endpoint.assignWireEntity(this);
                    } else {
                        this.deferEndpointResolution = (byte)(this.deferEndpointResolution | 2);
                        this.deferTicks = 0;
                    }
                }
            }
            this.endpoint2 = endpoint;
            this.makeWire();
        }
    }

    public void flipEndpoints() {
        IWireEndpoint endpoint = this.endpoint1;
        this.endpoint1 = this.endpoint2;
        this.endpoint2 = endpoint;
        this.deferEndpointResolution = (byte)((this.deferEndpointResolution & 1) << 1 | (this.deferEndpointResolution & 2) >> 1);
        PowerGrid.LOGGER.debug("Wire entity endpoints have been flipped.");
    }

    public IWireEndpoint getEndpoint1() {
        return this.endpoint1;
    }

    public IWireEndpoint getEndpoint2() {
        return this.endpoint2;
    }

    public void endpointRemoved(IWireEndpoint endpoint) {
    }

    private EntityDataS2CPacket createExtraDataPacket() {
        CompoundTag tag = new CompoundTag();
        this.m_7380_(tag);
        tag.m_128405_("Version", this.dataVersion++);
        return new EntityDataS2CPacket(this, tag);
    }

    public void sendExtraData() {
        ModdedPackets.sendToClientsTracking(this.createExtraDataPacket(), this);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        EntityDataS2CPacket extra = this.createExtraDataPacket();
        ModdedPackets.sendToClientsTracking(extra, this);
        return super.m_5654_();
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
    }

    @Override
    public void onEntityDataPacket(CompoundTag data) {
        int version = data.m_128451_("Version");
        if (version < this.dataVersion) {
            return;
        }
        this.m_7378_(data);
        this.dataVersion = version + 1;
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("Item")) {
            CompoundTag itemTag = nbt.m_128469_("Item");
            Item readItem = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemTag.m_128461_("Id")));
            if (!(readItem instanceof WireItem)) {
                throw new IllegalStateException("WireEntity item must be a WireItem");
            }
            WireItem wireItem = (WireItem)readItem;
            this.setItem(wireItem, itemTag.m_128451_("Count"));
            if (wireItem.canBeColored()) {
                this.color = nbt.m_128451_("Color");
            }
        } else {
            throw new IllegalStateException("WireEntity must have an item");
        }
        BlockPos lastPos = null;
        if (nbt.m_128441_("LastKnownPos")) {
            lastPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("LastKnownPos"));
        }
        IWireEndpoint endpoint1 = null;
        IWireEndpoint endpoint2 = null;
        if (nbt.m_128441_("Endpoint1")) {
            endpoint1 = WireEndpointType.deserialize(nbt.m_128469_("Endpoint1"));
        }
        if (nbt.m_128441_("Endpoint2")) {
            endpoint2 = WireEndpointType.deserialize(nbt.m_128469_("Endpoint2"));
        }
        BlockPos currentPos = this.m_20183_();
        if (lastPos != null && !lastPos.equals((Object)currentPos)) {
            BlockPos diff = currentPos.m_121996_((Vec3i)lastPos);
            if (endpoint1 != null) {
                endpoint1 = endpoint1.makeOffset(diff);
            }
            if (endpoint2 != null) {
                endpoint2 = endpoint2.makeOffset(diff);
            }
        }
        this.setEndpoint1(endpoint1);
        this.setEndpoint2(endpoint2);
        this.f_19804_.m_135381_(TEMPERATURE, (Object)Float.valueOf(nbt.m_128457_("Temperature")));
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColor(DyeColor color) {
        float[] rgb = color.m_41068_();
        this.color = (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
    }

    public void setItem(WireItem item, int count) {
        this.item = item;
        this.itemCount = count;
        int thermalCount = Math.max(this.itemCount, 1);
        this.thermalMass = item.getThermalMass() * (float)thermalCount;
        this.dissipationFactor = item.getDissipationFactor() * (float)thermalCount;
    }

    public float getResistance() {
        if (this.resistanceOverride != null) {
            return this.resistanceOverride.floatValue();
        }
        return this.item.getResistance() * (float)Math.max(this.itemCount, 1);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.item, 1);
    }

    public abstract void makeWire();

    public abstract void dropWire();

    public boolean isConnectedTo(BlockPos pos, int terminal) {
        BlockWireEndpoint testPoint = new BlockWireEndpoint(pos, terminal);
        return testPoint.equals(this.endpoint1) || testPoint.equals(this.endpoint2);
    }

    protected void m_7380_(CompoundTag nbt) {
        if (this.endpoint1 != null) {
            nbt.m_128365_("Endpoint1", (Tag)this.endpoint1.serialize());
        }
        if (this.endpoint2 != null) {
            nbt.m_128365_("Endpoint2", (Tag)this.endpoint2.serialize());
        }
        CompoundTag itemTag = new CompoundTag();
        itemTag.m_128359_("Id", BuiltInRegistries.f_257033_.m_7981_((Object)this.item).toString());
        itemTag.m_128405_("Count", this.itemCount);
        nbt.m_128365_("Item", (Tag)itemTag);
        if (this.item.canBeColored()) {
            nbt.m_128405_("Color", this.color);
        }
        nbt.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.m_20183_()));
        nbt.m_128350_("Temperature", ((Float)this.f_19804_.m_135370_(TEMPERATURE)).floatValue());
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (reason.m_146965_()) {
            this.dropWire();
            if (this.endpoint1 != null) {
                this.endpoint1.removeWireEntity(this);
            }
            if (this.endpoint2 != null) {
                this.endpoint2.removeWireEntity(this);
            }
        }
    }

    public void m_142036_() {
        super.m_142036_();
        Entity.RemovalReason reason = this.m_146911_();
        if (reason.m_146965_()) {
            this.dropWire();
            if (this.endpoint1 != null) {
                this.endpoint1.removeWireEntity(this);
            }
            if (this.endpoint2 != null) {
                this.endpoint2.removeWireEntity(this);
            }
        }
    }

    public void m_6074_() {
        for (int i = this.itemCount; i > 0; i -= 64) {
            this.m_19983_(new ItemStack((ItemLike)this.item, Math.min(i, 64)));
        }
        this.itemCount = 0;
        super.m_6074_();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ModdedItems.WIRE_CUTTER.get()) {
            ModdedSoundEvents.WIRE_CUT.playAt(this.m_9236_(), this.m_20182_(), 0.75f, 1.25f, false);
            this.m_6074_();
            return InteractionResult.SUCCESS;
        }
        Item item = stack.m_41720_();
        if (item instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)item;
            return multimeter.useOnWire(player, stack, hand, this);
        }
        item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (this.item.canBeColored()) {
                this.setColor(dye.m_41089_());
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6096_(player, hand);
    }

    public WireItem getWireItem() {
        return this.item;
    }

    public int getWireCount() {
        return this.itemCount;
    }

    public void incrementWireCount(int count) {
        this.itemCount += count;
        if (this.itemCount < 0) {
            this.itemCount = 0;
        }
        int thermalCount = Math.max(this.itemCount, 1);
        this.thermalMass = this.item.getThermalMass() * (float)thermalCount;
        this.dissipationFactor = this.item.getDissipationFactor() * (float)thermalCount;
    }

    public void m_146868_(boolean onFire) {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public int getColor() {
        if (this.item.canBeColored()) {
            return this.color;
        }
        return -1;
    }
}

