/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.config.WireValues;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntityEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.ImaginaryWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.utility.BlockTrace;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class WireItem
extends Item
implements IWire {
    protected ResourceLocation wireTexture;
    protected float horizontalCoefficient = 1.01f;
    protected float verticalCoefficient = 1.2f;
    protected float wireThickness = 0.0625f;
    protected boolean colored = false;

    public WireItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result;
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return super.m_6225_(context);
        }
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return super.m_6225_(context);
        }
        IElectric electric = IElectric.getAt(context.m_43725_(), context.m_8083_());
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (electric != null && (result = electric.onWire(blockState, context)) != InteractionResult.PASS) {
            return result;
        }
        CompoundTag tag = context.m_43722_().m_41783_();
        if (tag != null) {
            Level world = context.m_43725_();
            ItemStack stack = context.m_43722_();
            IWireEndpoint endpoint = WireEndpointType.deserialize(tag);
            if (endpoint == null) {
                return InteractionResult.FAIL;
            }
            InteractionResultHolder<BlockWireEntity> result2 = WireItem.connect(world, stack, context.m_43723_(), endpoint, new ImaginaryWireEndpoint(context.m_43720_()));
            if (result2.m_19089_().m_19077_()) {
                BlockWireEntity entity = (BlockWireEntity)result2.m_19095_();
                if (entity != null) {
                    stack.m_41751_(new BlockWireEntityEndpoint(entity, true).serialize());
                    Player player = context.m_43723_();
                    if (player != null) {
                        player.m_21008_(context.m_43724_(), stack);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    public static InteractionResultHolder<BlockWireEntity> connect(Level world, ItemStack stack, Player player, IWireEndpoint endpoint1, IWireEndpoint endpoint2) {
        BlockTrace.TraceResult result;
        if (endpoint1.type() == WireEndpointType.BLOCK_WIRE && endpoint2.type() == WireEndpointType.BLOCK_WIRE) {
            return WireItem.mergeWires(world, stack, player, (BlockWireEntityEndpoint)endpoint1, (BlockWireEntityEndpoint)endpoint2);
        }
        Vec3 lastPoint = endpoint1.getExactPosition(world);
        if (endpoint1.type() != WireEndpointType.BLOCK_WIRE) {
            lastPoint = BlockTrace.alignPosition(lastPoint);
        }
        Vec3 targetPoint = endpoint2.getExactPosition(world);
        Direction continueDir = null;
        if (endpoint1 instanceof BlockWireEntityEndpoint) {
            BlockWireEntityEndpoint bwe = (BlockWireEntityEndpoint)endpoint1;
            BlockWireEntity entity = bwe.getEntity(world);
            if (entity == null) {
                return InteractionResultHolder.m_19100_(null);
            }
            List<BlockWireEntity.Point> segments = entity.segments;
            if (bwe.getEnd()) {
                BlockWireEntity.Point last = segments.get(segments.size() - 1);
                continueDir = last.direction;
            } else {
                BlockWireEntity.Point first = segments.get(0);
                continueDir = first.direction.m_122424_();
            }
        }
        ITerminalPlacement terminal = null;
        if (endpoint2 instanceof BlockWireEndpoint) {
            BlockWireEndpoint wireEndpoint = (BlockWireEndpoint)endpoint2;
            terminal = wireEndpoint.getTerminalPlacement(world);
        }
        if ((result = BlockTrace.findPath(world, lastPoint, targetPoint, terminal, continueDir)) != null && result.reachedTarget()) {
            float addedLength = 0.0f;
            for (BlockWireEntity.Point point : result.points()) {
                addedLength += point.length();
            }
            if (endpoint1.type() != WireEndpointType.BLOCK_WIRE) {
                int newItems = (int)Math.ceil(addedLength);
                if (!PlayerUtilities.hasEnoughItems(player, stack, newItems)) {
                    if (player != null) {
                        player.m_5661_((Component)Lang.translate("message.connection_missing_items", new Object[0]).style(ChatFormatting.RED).component(), true);
                    }
                    return InteractionResultHolder.m_19100_(null);
                }
                if (!world.f_46443_) {
                    BlockWireEntity entity = BlockWireEntity.create(world, endpoint1, stack.m_255036_(newItems), result.points());
                    if (endpoint2.type().isConnectable()) {
                        entity.setEndpoint2(endpoint2);
                    }
                    if (player != null) {
                        Item item;
                        ItemStack offItem = player.m_21206_();
                        if (((IWire)stack.m_41720_()).canBeColored() && (item = offItem.m_41720_()) instanceof DyeItem) {
                            DyeItem dye = (DyeItem)item;
                            entity.setColor(dye.m_41089_());
                        }
                    }
                    if (!((ServerLevel)world).m_8860_((Entity)entity)) {
                        PowerGrid.LOGGER.error("Failed to spawn new block wire entity.");
                        if (player != null) {
                            player.m_5661_((Component)Lang.translate("message.connection_failed", new Object[0]).style(ChatFormatting.RED).component(), true);
                        }
                        return InteractionResultHolder.m_19100_(null);
                    }
                    PlayerUtilities.removeItems(player, stack, newItems);
                    return InteractionResultHolder.m_19090_((Object)entity);
                }
            } else {
                BlockWireEntityEndpoint bwEndpoint = (BlockWireEntityEndpoint)endpoint1;
                BlockWireEntity wire = bwEndpoint.getEntity(world);
                if (wire.getWireItem() != stack.m_41720_()) {
                    player.m_5661_((Component)Lang.translate("message.connection_incorrect_wire_type", new Object[0]).style(ChatFormatting.RED).component(), true);
                    return InteractionResultHolder.m_19100_(null);
                }
                int newItems = (int)Math.ceil(wire.getTotalLength() + addedLength - (float)wire.getWireCount());
                if (!PlayerUtilities.hasEnoughItems(player, stack, newItems)) {
                    if (player != null) {
                        player.m_5661_((Component)Lang.translate("message.connection_missing_items", new Object[0]).style(ChatFormatting.RED).component(), true);
                    }
                    return InteractionResultHolder.m_19100_(null);
                }
                if (!world.f_46443_) {
                    if (!bwEndpoint.getEnd()) {
                        PowerGrid.LOGGER.error("Cannot extend wire at start (must be flipped beforehand)");
                        return InteractionResultHolder.m_19100_(null);
                    }
                    if (endpoint2.type().isConnectable()) {
                        wire.setEndpoint2(endpoint2);
                    }
                    wire.extend(result.points(), newItems);
                    PlayerUtilities.removeItems(player, stack, newItems);
                    return InteractionResultHolder.m_19090_((Object)wire);
                }
            }
            return InteractionResultHolder.m_19090_(null);
        }
        return InteractionResultHolder.m_19100_(null);
    }

    public static InteractionResultHolder<BlockWireEntity> mergeWires(Level world, ItemStack stack, Player player, BlockWireEntityEndpoint endpoint1, BlockWireEntityEndpoint endpoint2) {
        BlockWireEntity sourceEntity;
        BlockWireEntity targetEntity;
        Direction continueDir;
        BlockWireEntity entity2;
        if (world.f_46443_) {
            throw new IllegalStateException("Wire merging must occur on server");
        }
        Vec3 lastPoint = endpoint1.getExactPosition(world);
        Vec3 targetPoint = endpoint2.getExactPosition(world);
        BlockWireEntity entity1 = endpoint1.getEntity(world);
        if (entity1 == (entity2 = endpoint2.getEntity(world))) {
            return InteractionResultHolder.m_19100_(null);
        }
        if (entity1.getWireItem() != entity2.getWireItem()) {
            if (player != null) {
                player.m_5661_((Component)Lang.translate("message.connection_two_wire_types", new Object[0]).style(ChatFormatting.RED).component(), true);
            }
            return InteractionResultHolder.m_19100_(null);
        }
        if (entity1.getWireItem() != stack.m_41720_()) {
            if (player != null) {
                player.m_5661_((Component)Lang.translate("message.connection_incorrect_wire_type", new Object[0]).style(ChatFormatting.RED).component(), true);
            }
            return InteractionResultHolder.m_19100_(null);
        }
        List<BlockWireEntity.Point> currentSegments = endpoint1.getEntity((Level)world).segments;
        if (endpoint1.getEnd()) {
            BlockWireEntity.Point last = currentSegments.get(currentSegments.size() - 1);
            continueDir = last.direction;
        } else {
            BlockWireEntity.Point first = currentSegments.get(0);
            continueDir = first.direction.m_122424_();
        }
        BlockTrace.TraceResult result = BlockTrace.findPath(world, lastPoint, targetPoint, null, continueDir);
        if (result == null || !result.reachedTarget()) {
            return InteractionResultHolder.m_19100_(null);
        }
        float addedLength = 0.0f;
        for (BlockWireEntity.Point point : result.points()) {
            addedLength += point.length();
        }
        int newItems = (int)Math.ceil(entity1.getTotalLength() + entity2.getTotalLength() + addedLength - (float)entity1.getWireCount() - (float)entity2.getWireCount());
        if (!PlayerUtilities.hasEnoughItems(player, stack, newItems)) {
            if (player != null) {
                player.m_5661_((Component)Lang.translate("message.connection_missing_items", new Object[0]).style(ChatFormatting.RED).component(), true);
            }
            return InteractionResultHolder.m_19100_(null);
        }
        boolean flipped = false;
        if (endpoint1.getEnd() || !endpoint2.getEnd()) {
            targetEntity = entity1;
            if (!endpoint1.getEnd()) {
                targetEntity = targetEntity.flip();
            }
            sourceEntity = entity2;
            if (endpoint2.getEnd()) {
                flipped = true;
            }
        } else {
            targetEntity = entity2;
            sourceEntity = entity1;
        }
        targetEntity.extend(result.points(), newItems, false);
        if (flipped) {
            ArrayList<BlockWireEntity.Point> segments = new ArrayList<BlockWireEntity.Point>();
            for (BlockWireEntity.Point segment : sourceEntity.segments) {
                segments.add(0, new BlockWireEntity.Point(segment.direction.m_122424_(), segment.gridLength));
            }
            targetEntity.setEndpoint2(sourceEntity.getEndpoint1());
            targetEntity.extend(segments, sourceEntity.getWireCount());
        } else {
            targetEntity.setEndpoint2(sourceEntity.getEndpoint2());
            targetEntity.extend(sourceEntity.segments, sourceEntity.getWireCount());
        }
        sourceEntity.m_146870_();
        return InteractionResultHolder.m_19090_((Object)targetEntity);
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || stack.m_41782_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (stack.m_41782_() && user.m_6144_()) {
            stack.m_41751_(null);
            if (!world.f_46443_) {
                user.m_5661_((Component)Lang.translate("message.connection_reset", new Object[0]).style(ChatFormatting.GRAY).component(), true);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)true);
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public float getResistance() {
        return WireValues.resistance(this);
    }

    @Override
    public float getMaximumLength() {
        return WireValues.maxLength(this);
    }

    @Override
    public float getDissipationFactor() {
        return WireValues.dissipationFactor(this);
    }

    @Override
    public float getThermalMass() {
        return WireValues.thermalMass(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getWireTexture() {
        return this.wireTexture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHorizontalCoefficient() {
        return this.horizontalCoefficient;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getVerticalCoefficient() {
        return this.verticalCoefficient;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getWireThickness() {
        return this.wireThickness;
    }

    @Override
    public boolean canBeColored() {
        return this.colored;
    }
}

