/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.thunder;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.config.CKinetics;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.particles.ZapParticleData;
import org.patryk3211.powergrid.mixin.LightningAccessor;
import org.patryk3211.powergrid.network.packets.LightningSyncS2CPacket;

public class LightningRodMovementBehaviour
implements MovementBehaviour {
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && context.contraption instanceof BearingContraption;
    }

    protected void fire(MovementContext context) {
        LightningRodMovementBehaviour.spawnLightning((ServerLevel)context.world, context.position);
        LightningBolt lightningEntity = (LightningBolt)EntityType.f_20465_.m_20615_(context.world);
        if (lightningEntity != null) {
            lightningEntity.m_20219_(Vec3.m_82539_((Vec3i)BlockPos.m_274446_((Position)context.position)));
            lightningEntity.m_20874_(false);
            ((ServerLevel)context.world).m_8860_((Entity)lightningEntity);
        }
        ModdedPackets.sendToClientsTracking(new LightningSyncS2CPacket(context), (Entity)context.contraption.entity);
    }

    public void pickController(MovementContext context) {
        ArrayList<MovementContext> actors = new ArrayList<MovementContext>();
        MutableObject fastestActor = new MutableObject();
        context.contraption.forEachActor(context.world, (behaviour, innerContext) -> {
            if (behaviour instanceof LightningRodMovementBehaviour) {
                actors.add((MovementContext)innerContext);
                if (fastestActor.getValue() == null) {
                    fastestActor.setValue(innerContext);
                } else {
                    double maxSpeed = ((MovementContext)fastestActor.getValue()).motion.m_82553_();
                    double thisSpeed = innerContext.motion.m_82553_();
                    if (thisSpeed > maxSpeed) {
                        fastestActor.setValue(innerContext);
                    }
                }
            }
        });
        if (fastestActor.getValue() != context.temporaryData) {
            actors.forEach(actor -> {
                actor.temporaryData = fastestActor.getValue();
            });
        }
    }

    private static void spawnLightning(ServerLevel world, Vec3 pos) {
        LightningBolt lightningEntity;
        BlockPos blockPos = ((LightningAccessor)world).invokeGetLightningPos(BlockPos.m_274446_((Position)pos));
        if (world.m_46758_(blockPos) && (lightningEntity = (LightningBolt)EntityType.f_20465_.m_20615_((Level)world)) != null) {
            lightningEntity.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
            lightningEntity.m_20874_(false);
            world.m_8860_((Entity)lightningEntity);
        }
    }

    public void fireClient(MovementContext context) {
        context.contraption.forEachActor(context.world, (behaviour, innerContext) -> {
            Vec3 pos = innerContext.position;
            Direction facing = (Direction)innerContext.state.m_61143_((Property)BlockStateProperties.f_61372_);
            SparkParticleData.explodeParticles(innerContext.world, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, facing, 20);
        });
    }

    public void tick(MovementContext context) {
        this.pickController(context);
        boolean isController = context.temporaryData == context;
        float charge = isController ? context.data.m_128457_("Charge") : ((MovementContext)context.temporaryData).data.m_128457_("Charge");
        BearingContraption bearing = (BearingContraption)context.contraption;
        double speed = context.motion.m_82553_();
        int sails = bearing.getSailBlocks();
        CKinetics configs = ModdedConfigs.server().kinetics;
        float speedFactor = (float)Math.min(speed * (double)configs.lightningAttractorSpeedFactor.getF(), 1.0);
        float sailFactor = Math.min((float)sails * configs.lightningAttractorSailFactor.getF(), 1.0f);
        Direction facing = (Direction)context.state.m_61143_((Property)BlockStateProperties.f_61372_);
        Vec3 facingVec = Vec3.m_82528_((Vec3i)facing.m_122436_());
        if (isController) {
            if (context.world.m_46470_() && speed > 1.5) {
                if ((charge += speedFactor * sailFactor * configs.lightningAttractorMaxFrequency.getF()) >= 1.0f) {
                    charge = 0.0f;
                    if (!context.world.f_46443_) {
                        this.fire(context);
                    } else {
                        charge = 1.0f;
                    }
                }
            } else if (charge > 0.0f && (charge -= 0.05f) < 0.0f) {
                charge = 0.0f;
            }
        }
        if (context.world.f_46443_) {
            float chance;
            RandomSource r = context.world.f_46441_;
            Vec3 pos1 = context.position;
            Vec3 vel1 = facingVec.m_82537_(context.motion);
            for (chance = r.m_188501_() * charge * 8.0f; r.m_188501_() < chance; chance -= 1.0f) {
                Vec3 vel = vel1.m_82490_((double)((r.m_188501_() - 0.5f) * 3.0f)).m_272010_(r, 2.0f);
                Vec3 pos = pos1.m_272010_(r, 2.0f);
                context.world.m_7106_((ParticleOptions)ParticleTypes.f_175830_, pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
            }
            for (chance = r.m_188501_() * charge * 0.1f; r.m_188501_() < chance; chance -= 1.0f) {
                Vec3 dir = pos1.m_272010_(r, 8.0f);
                context.world.m_7106_((ParticleOptions)new ZapParticleData(dir.f_82479_, dir.f_82480_, dir.f_82481_, false).withLife(0), pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, 0.0, 0.0, 0.0);
            }
        }
        context.data.m_128350_("Charge", charge);
    }

    public void writeExtraData(MovementContext context) {
        super.writeExtraData(context);
    }
}

