/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.zapper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.powergrid.collections.ModdedDamageTypes;
import org.patryk3211.powergrid.collections.ModdedEntities;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.network.packets.ZapProjectileS2CPacket;

public class ZapProjectileEntity
extends Projectile {
    public ZapProjectileEntity(EntityType<? extends Projectile> type, Level world) {
        super(type, world);
    }

    public static ZapProjectileEntity create(Level world, Vec3 position, Vec3 velocity, float yaw, float pitch) {
        ZapProjectileEntity entity = new ZapProjectileEntity((EntityType<? extends Projectile>)((EntityType)ModdedEntities.ZAP_PROJECTILE.get()), world);
        entity.m_20343_(position.f_82479_, position.f_82480_, position.f_82481_);
        entity.m_20256_(velocity);
        ProjectileUtil.m_37284_((Entity)entity, (float)1.0f);
        entity.m_146867_();
        entity.m_20090_();
        return entity;
    }

    protected void m_8097_() {
    }

    public static void playHitSound(Level world, Vec3 location) {
    }

    public static void playLaunchSound(Level world, Vec3 location, float pitch) {
        ModdedSoundEvents.ELECTROZAPPER_SHOOT.playAt(world, location, 1.0f, pitch, true);
    }

    public void m_8119_() {
        super.m_8119_();
        HitResult hit = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hit.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hit);
        }
        this.m_20101_();
        Vec3 velocity = this.m_20184_();
        double x = this.m_20185_() + velocity.f_82479_;
        double y = this.m_20186_() + velocity.f_82480_;
        double z = this.m_20189_() + velocity.f_82481_;
        ProjectileUtil.m_37284_((Entity)this, (float)1.0f);
        if (this.m_20069_()) {
            this.m_6074_();
            return;
        }
        Level world = this.m_9236_();
        RandomSource r = world.f_46441_;
        for (int i = 0; i < 4; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, (double)(r.m_188501_() - 0.5f), (double)(r.m_188501_() - 0.5f), (double)(r.m_188501_() - 0.5f));
        }
        this.m_6034_(x, y, z);
    }

    private DamageSource causeZapDamage() {
        Registry registry = this.m_9236_().m_9598_().m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)registry.m_203636_(ModdedDamageTypes.ZAP).get(), (Entity)this, this.m_19749_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    protected void m_5790_(EntityHitResult hit) {
        WitherBoss wither;
        Entity owner = this.m_19749_();
        Entity target = hit.m_82443_();
        if (!target.m_6084_()) {
            return;
        }
        if (owner instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)owner;
            living.m_21335_(target);
        }
        if (target instanceof WitherBoss && (wither = (WitherBoss)target).m_7090_()) {
            return;
        }
        float damage = 8.0f;
        AABB effectBB = new AABB(target.m_20183_()).m_82400_(2.0);
        Level world = this.m_9236_();
        DamageSource source = this.causeZapDamage();
        List affectedEntities = world.m_6249_(target, effectBB, e -> e instanceof LivingEntity && !e.m_6673_(source));
        boolean onServer = !world.f_46443_;
        if (onServer && !target.m_6469_(source, damage /= (float)Math.min(affectedEntities.size() + 1, 3))) {
            this.m_6074_();
            return;
        }
        if (onServer) {
            ArrayList<Entity> damagedEntities = new ArrayList<Entity>();
            for (Entity entity : affectedEntities) {
                if (entity.m_6469_(source, damage)) {
                    damagedEntities.add(entity);
                }
                if (damagedEntities.size() < 2) continue;
                break;
            }
            ModdedPackets.sendToClientsAround(new ZapProjectileS2CPacket(target, damagedEntities), (ServerLevel)this.m_9236_(), this.m_20182_(), 50.0);
        }
        if (target.m_6095_() == EntityType.f_20566_) {
            return;
        }
        if (!(target instanceof LivingEntity)) {
            this.m_6074_();
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (onServer && owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)livingOwner);
            EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingTarget);
        }
        if (livingTarget != owner && livingTarget instanceof Player && owner instanceof ServerPlayer) {
            ServerPlayer ownerPlayer = (ServerPlayer)owner;
            if (!this.m_20067_()) {
                ownerPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
            }
        }
        if (onServer && owner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
        }
        this.m_6074_();
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        if (!this.m_9236_().f_46443_) {
            ModdedPackets.sendToClientsTracking(new ZapProjectileS2CPacket(hit), (Entity)this);
        }
        this.m_6074_();
    }
}

