/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.base;

import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.patryk3211.powergrid.kinetics.base.ElectricKineticBlockEntity;

public abstract class TunedBlockEntity
extends ElectricKineticBlockEntity {
    public LerpedFloat arm = LerpedFloat.linear().chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);

    public TunedBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.arm.setValue(1.0);
    }

    public void initialize() {
        super.initialize();
        this.arm.forceNextSync();
        this.sendData();
    }

    private float getChaseSpeed() {
        return Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 60.0f * 0.05f), (float)0.0f, (float)1.0f);
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            this.arm.chase((double)this.arm.getValue(), 0.0, LerpedFloat.Chaser.LINEAR);
            this.arm.forceNextSync();
            return;
        }
        if (this.sequenceContext != null && this.sequenceContext.instruction() == SequencerInstructions.TURN_ANGLE) {
            double angle = this.sequenceContext.getEffectiveValue((double)this.getTheoreticalSpeed());
            double target = Mth.m_14008_((double)((double)this.arm.getValue() + angle / 315.0 * (double)Math.signum(speed)), (double)0.0, (double)1.0);
            this.arm.chase(target, (double)this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        } else {
            this.arm.chase(speed > 0.0f ? 1.0 : 0.0, (double)this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        }
        this.sendData();
    }

    public abstract void refreshParameters();

    public void tick() {
        super.tick();
        this.arm.tickChaser();
        if (!this.arm.settled()) {
            if (this.getSpeed() == 0.0f) {
                this.arm.updateChaseTarget(this.arm.getValue());
            }
            this.refreshParameters();
            this.m_6596_();
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (clientPacket) {
            this.arm.forceNextSync();
        }
        compound.m_128365_("Arm", (Tag)this.arm.writeNBT());
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        tag.m_128365_("Arm", (Tag)this.arm.writeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.arm.readNBT(compound.m_128469_("Arm"), clientPacket);
        this.refreshParameters();
    }
}

