/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.clutch;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBehaviour;

public class GeneratorClutchBlockEntity
extends KineticBlockEntity
implements RotorBehaviour.IForceSource {
    protected RotorBehaviour rotorBehaviour;
    private int currentRedstonePower = 0;
    public float load;
    private boolean recalculateStress = false;

    public GeneratorClutchBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.rotorBehaviour = new RotorBehaviour((SmartBlockEntity)this, ModdedConfigs.server().kinetics.generatorControls.generatorClutchInertia.getF());
        this.rotorBehaviour.forceSource(this);
        this.rotorBehaviour.setChangeCallback(this::assemblyChanged);
        behaviours.add(this.rotorBehaviour);
    }

    private void assemblyChanged() {
        this.recalculateStress = true;
    }

    public float torqueForStress() {
        return ModdedConfigs.server().kinetics.torqueForStress.getF();
    }

    @Override
    public float sourceForce(float velocity) {
        if (this.getTheoreticalSpeed() == 0.0f || this.isOverStressed()) {
            return 0.0f;
        }
        return (float)((double)(this.torqueForStress() * this.lastStressApplied / 30.0f) * Math.PI);
    }

    @Override
    public float forceSpeed() {
        return this.getTheoreticalSpeed();
    }

    @Override
    public void receiveUsedForce(float percent) {
        this.load = percent;
    }

    public void updateStrength(int receivedRedstonePower) {
        if (this.currentRedstonePower != receivedRedstonePower) {
            this.currentRedstonePower = receivedRedstonePower;
            this.recalculateStress = true;
        }
    }

    public void tick() {
        super.tick();
        if (this.recalculateStress) {
            if (this.hasNetwork() && (!this.f_58857_.f_46443_ || this.isVirtual())) {
                KineticNetwork network = this.getOrCreateNetwork();
                network.remove((KineticBlockEntity)this);
                network.add((KineticBlockEntity)this);
            }
            this.recalculateStress = false;
            this.notifyUpdate();
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128344_("Power", (byte)this.currentRedstonePower);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.currentRedstonePower = compound.m_128445_("Power");
    }

    public float calculateStressApplied() {
        MutableFloat totalImpact = new MutableFloat(0.0f);
        this.rotorBehaviour.forEachSegment(segment -> totalImpact.add((Number)BlockStressValues.getImpact((Block)segment.blockEntity.m_58900_().m_60734_())));
        float couplingStrength = (float)(15 - this.currentRedstonePower) / 15.0f;
        this.lastStressApplied = totalImpact.getValue().floatValue() * couplingStrength;
        return this.lastStressApplied;
    }

    public void remove() {
        super.remove();
        this.rotorBehaviour.remove();
    }
}

