/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.inductionrotor;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.CommutatorBlock;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.VerticalCommutatorBlock;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBlockEntity;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorRenderer;

public class CommutatorRenderer
extends RotorRenderer {
    public CommutatorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(RotorBlockEntity rotor, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(rotor, partialTicks, matrixStack, buffer, light, overlay);
        float rotorAngle = CommutatorRenderer.getRotorAngle(rotor, partialTicks);
        float brushAngle = rotorAngle * 2.0f;
        double sin = Math.sin(brushAngle);
        double brushOffset = sin * sin * 1.0 / 16.0;
        BlockState state = rotor.m_58900_();
        if (state.m_60734_() instanceof VerticalCommutatorBlock) {
            Direction facing = (Direction)state.m_61143_((Property)VerticalCommutatorBlock.HORIZONTAL_FACING);
            if (!((Boolean)state.m_61143_((Property)VerticalCommutatorBlock.UP)).booleanValue()) {
                facing = facing.m_122424_();
            }
            SuperByteBuffer brush = CachedBuffers.partial((PartialModel)ModdedPartialModels.VERTICAL_COMMUTATOR_BRUSH, (BlockState)state);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)brush.light(light).center()).rotateToFace(facing)).uncenter()).translate(-brushOffset, 0.0, 0.0)).renderInto(matrixStack, buffer.m_6299_(RenderType.m_110451_()));
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)brush.light(light).center()).rotateToFace(facing)).rotateZ((float)Math.PI)).uncenter()).translate(-brushOffset, 0.0, 0.0)).renderInto(matrixStack, buffer.m_6299_(RenderType.m_110451_()));
        } else {
            Direction.Axis axis = ((Direction)state.m_61143_((Property)CommutatorBlock.HORIZONTAL_FACING)).m_122434_();
            Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            SuperByteBuffer brush = CachedBuffers.partial((PartialModel)ModdedPartialModels.COMMUTATOR_BRUSH, (BlockState)state);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)brush.light(light).center()).rotateToFace(facing)).uncenter()).translate(-brushOffset, 0.0, 0.0)).renderInto(matrixStack, buffer.m_6299_(RenderType.m_110451_()));
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)brush.light(light).center()).rotateToFace(facing.m_122424_())).uncenter()).translate(-brushOffset, 0.0, 0.0)).renderInto(matrixStack, buffer.m_6299_(RenderType.m_110451_()));
        }
    }

    @Override
    protected SuperByteBuffer getModelForState(BlockState state) {
        if (state.m_60734_() instanceof VerticalCommutatorBlock) {
            return CachedBuffers.partialFacing((PartialModel)ModdedPartialModels.COMMUTATOR_SHAFT, (BlockState)state, (Direction)Direction.UP);
        }
        return CachedBuffers.partialFacing((PartialModel)ModdedPartialModels.COMMUTATOR_SHAFT, (BlockState)state, (Direction)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction)state.m_61143_((Property)CommutatorBlock.HORIZONTAL_FACING)).m_122434_()));
    }
}

