/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.IGoggleLabel;
import org.patryk3211.powergrid.circuits.components.IRenderedComponent;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.BooleanProperty;
import org.patryk3211.powergrid.circuits.components.properties.CalculatedProperty;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.electricity.sim.special.NeonBulbWire;
import org.patryk3211.powergrid.utility.Unit;

public class NeonBulbComponent
extends OrientableComponent
implements IRenderedComponent,
IGoggleLabel {
    public static final FloatProperty BREAKDOWN_VOLTAGE = new FloatProperty("powergrid", "neon_tube_vb", 60.0f, 30.0f, 300.0f);
    public static final CalculatedProperty<Float> HOLDING_VOLTAGE = new CalculatedProperty<Float>("powergrid", "neon_tube_vh", placed -> Float.valueOf(0.75f * placed.get(BREAKDOWN_VOLTAGE).floatValue()), v -> Unit.VOLTAGE.formatWithPrefixes(v.floatValue()).string());
    public static final CalculatedProperty<Float> HOLDING_CURRENT = new CalculatedProperty<Float>("powergrid", "neon_tube_ih", placed -> Float.valueOf(0.2f / placed.get(BREAKDOWN_VOLTAGE).floatValue()), v -> Unit.CURRENT.formatWithPrefixes(v.floatValue()).string());
    public static final BooleanProperty LIT = (BooleanProperty)new BooleanProperty("powergrid", "lit").hidden();

    public NeonBulbComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{BREAKDOWN_VOLTAGE, HOLDING_VOLTAGE, HOLDING_CURRENT, LABEL, LIT, NeonBulbComponent.power(1.5f)});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        Float ih = placed.get(HOLDING_CURRENT);
        Float vb = placed.get(BREAKDOWN_VOLTAGE);
        Float vh = placed.get(HOLDING_VOLTAGE);
        NeonBulbWire wire = new NeonBulbWire(vb.floatValue(), vh.floatValue(), ih.floatValue(), 0.005f, builder.terminalNode(0), builder.terminalNode(1));
        wire.setLit(placed.get(LIT));
        builder.add(wire);
        placed.add(wire);
        thermals.builder().addHeatSource(wire).setThermalMass(0.01f).setMaxPower(1.5f, 125.0f);
    }

    @Override
    public boolean tick(@NotNull PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return true;
        }
        NeonBulbWire wire = (NeonBulbWire)placed.wires.get(0);
        placed.onClientWorld(() -> world -> {
            LerpPair state;
            Object patt0$temp = placed.customData;
            if (patt0$temp instanceof LerpPair) {
                LerpPair current;
                state = current = (LerpPair)patt0$temp;
            } else {
                state = new LerpPair();
                placed.customData = state;
            }
            state.tickChaser();
            if (wire.isLit()) {
                if (wire.current() > 0.0f) {
                    state.first.updateChaseTarget(1.0f);
                    state.second.updateChaseTarget(0.0f);
                } else {
                    state.first.updateChaseTarget(0.0f);
                    state.second.updateChaseTarget(1.0f);
                }
            } else {
                state.first.updateChaseTarget(0.0f);
                state.second.updateChaseTarget(0.0f);
            }
        });
        if (wire.isLit() != placed.get(LIT).booleanValue()) {
            placed.set(LIT, wire.isLit());
        }
        return true;
    }

    @Override
    public void render(CircuitBoardBlockEntity be, PlacedComponent placed, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        SuperByteBuffer buffer;
        SuperByteBuffer bulb = CachedBuffers.partial((PartialModel)ModdedPartialModels.NEON_TUBE_BULB, (BlockState)be.m_58900_());
        bulb.light(light).renderInto(ms, bufferSource.m_6299_(RenderType.m_110466_()));
        int a1 = 0;
        int a2 = 0;
        Object object = placed.customData;
        if (object instanceof LerpPair) {
            LerpPair pair = (LerpPair)object;
            a1 = (int)(pair.first.getValue(partialTicks) * 128.0f);
            a2 = (int)(pair.second.getValue(partialTicks) * 128.0f);
        }
        if (a1 != 0) {
            buffer = CachedBuffers.partial((PartialModel)ModdedPartialModels.NEON_TUBE_GLOW, (BlockState)be.m_58900_());
            buffer.disableDiffuse().color(a1, a1, a1, 255).light(0xF000F0).renderInto(ms, bufferSource.m_6299_(RenderTypes.additive()));
        }
        if (a2 != 0) {
            buffer = CachedBuffers.partial((PartialModel)ModdedPartialModels.NEON_TUBE_GLOW, (BlockState)be.m_58900_());
            float center = 0.0625f;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.disableDiffuse().color(a2, a2, a2, 255).light(0xF000F0).translate(center, center, center)).rotateYDegrees(180.0f)).translateBack(center, center, center)).renderInto(ms, bufferSource.m_6299_(RenderTypes.additive()));
        }
    }

    private static class LerpPair {
        public final LerpedFloat first = LerpedFloat.linear().chase(0.0, (double)0.1f, LerpedFloat.Chaser.LINEAR);
        public final LerpedFloat second = LerpedFloat.linear().chase(0.0, (double)0.1f, LerpedFloat.Chaser.LINEAR);

        public void tickChaser() {
            this.first.tickChaser();
            this.second.tickChaser();
        }
    }
}

