/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components.properties;

import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;

public class FloatProperty
extends ComponentProperty<Float> {
    private final float defaultValue;
    private final float min;
    private final float max;

    public FloatProperty(String namespace, String name, float defaultValue, float min, float max) {
        super(namespace, name);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
    }

    protected float limit(float value) {
        if (value < this.min) {
            return this.min;
        }
        if (value > this.max) {
            return this.max;
        }
        return value;
    }

    @Override
    public Float parse(String str) throws NumberFormatException {
        float value = Float.parseFloat(str);
        return Float.valueOf(this.limit(value));
    }

    @Override
    public String toString(Float value) {
        return Float.toString(value.floatValue());
    }

    @Override
    public Float read(@Nullable Tag element) {
        if (element == null) {
            return Float.valueOf(this.defaultValue);
        }
        if (element.m_7060_() != 5) {
            return Float.valueOf(this.defaultValue);
        }
        float value = ((FloatTag)element).m_7057_();
        return Float.valueOf(this.limit(value));
    }

    @Override
    public Tag write(Float value) {
        return FloatTag.m_128566_((float)value.floatValue());
    }

    @Override
    public Float defaultValue() {
        return Float.valueOf(this.defaultValue);
    }
}

