/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.collections;

import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.mutable.MutableObject;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.collections.ModdedItems;

public class ItemDisplay {

    public static class BaseItemDisplay
    implements CreativeModeTab.DisplayItemsGenerator {
        private static final Predicate<Item> IS_ITEM_3D_PREDICATE;
        private final boolean addItems;

        public BaseItemDisplay(boolean addItems) {
            this.addItems = addItems;
        }

        private static Predicate<Item> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<BlockEntry<CircuitBoardBlock>> simpleExclusions = List.of(ModdedItems.INCOMPLETE_TRANSFORMER_CORE, ModdedItems.INCOMPLETE_BATTERY, ModdedItems.INCOMPLETE_CIRCUIT, ModdedItems.INCOMPLETE_ELECTRICAL_GIZMO, ModdedItems.INCOMPLETE_UNETCHED_CIRCUIT, ModdedItems.PORTABLE_BATTERY_PLACEABLE, ModdedItems.CIRCUIT_SCHEMATIC, ModdedItems.UNETCHED_CIRCUIT, ModdedBlocks.CIRCUIT_BOARD);
            for (ItemProviderEntry itemProviderEntry : simpleExclusions) {
                exclusions.add(itemProviderEntry.m_5456_());
            }
            return ((Set)exclusions)::contains;
        }

        private static List<ItemOrdering> makeOrderings() {
            ReferenceArrayList orderings = new ReferenceArrayList();
            return orderings;
        }

        private static Function<Item, ItemStack> makeStackFunc() {
            Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
            Map<ItemProviderEntry, Function> simpleFactories = Map.of();
            simpleFactories.forEach((arg_0, arg_1) -> BaseItemDisplay.lambda$makeStackFunc$4((Map)factories, arg_0, arg_1));
            return arg_0 -> BaseItemDisplay.lambda$makeStackFunc$5((Map)factories, arg_0);
        }

        private static Function<Item, CreativeModeTab.TabVisibility> makeVisibilityFunc() {
            Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
            Map<ItemProviderEntry, CreativeModeTab.TabVisibility> simpleVisibilities = Map.of();
            simpleVisibilities.forEach((arg_0, arg_1) -> BaseItemDisplay.lambda$makeVisibilityFunc$6((Map)visibilities, arg_0, arg_1));
            return arg_0 -> BaseItemDisplay.lambda$makeVisibilityFunc$7((Map)visibilities, arg_0);
        }

        public void m_257865_(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
            Predicate<Item> exclusionPredicate = BaseItemDisplay.makeExclusionPredicate();
            List<ItemOrdering> orderings = BaseItemDisplay.makeOrderings();
            Function<Item, ItemStack> stackFunc = BaseItemDisplay.makeStackFunc();
            Function<Item, CreativeModeTab.TabVisibility> visibilityFunc = BaseItemDisplay.makeVisibilityFunc();
            LinkedList<Item> items = new LinkedList<Item>();
            if (this.addItems) {
                items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE.negate())));
            }
            items.addAll(this.collectBlocks(exclusionPredicate));
            if (this.addItems) {
                items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE)));
            }
            BaseItemDisplay.applyOrderings(items, orderings);
            BaseItemDisplay.outputAll(output, items, stackFunc, visibilityFunc);
        }

        private List<Item> collectBlocks(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : PowerGrid.REGISTRATE.getAll(Registries.f_256747_)) {
                Item item = ((Block)entry.get()).m_5456_();
                if (item == Items.f_41852_ || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<Item> collectItems(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : PowerGrid.REGISTRATE.getAll(Registries.f_256913_)) {
                Item item = (Item)entry.get();
                if (item instanceof BlockItem || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }

        private static void applyOrderings(List<Item> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                Item item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(CreativeModeTab.Output output, List<Item> items, Function<Item, ItemStack> stackFunc, Function<Item, CreativeModeTab.TabVisibility> visibilityFunc) {
            for (Item item : items) {
                output.m_246267_(stackFunc.apply(item), visibilityFunc.apply(item));
            }
        }

        private static /* synthetic */ CreativeModeTab.TabVisibility lambda$makeVisibilityFunc$7(Map visibilities, Item item) {
            CreativeModeTab.TabVisibility visibility = (CreativeModeTab.TabVisibility)visibilities.get(item);
            if (visibility != null) {
                return visibility;
            }
            return CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
        }

        private static /* synthetic */ void lambda$makeVisibilityFunc$6(Map visibilities, ItemProviderEntry entry, CreativeModeTab.TabVisibility factory) {
            visibilities.put(entry.m_5456_(), factory);
        }

        private static /* synthetic */ ItemStack lambda$makeStackFunc$5(Map factories, Item item) {
            Function factory = (Function)factories.get(item);
            if (factory != null) {
                return (ItemStack)factory.apply(item);
            }
            return new ItemStack((ItemLike)item);
        }

        private static /* synthetic */ void lambda$makeStackFunc$4(Map factories, ItemProviderEntry entry, Function factory) {
            factories.put(entry.m_5456_(), factory);
        }

        static {
            MutableObject isItem3d = new MutableObject(item -> false);
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> isItem3d.setValue(item -> {
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                BakedModel model = itemRenderer.m_174264_(new ItemStack((ItemLike)item), null, null, 0);
                return model.m_7539_();
            }));
            IS_ITEM_3D_PREDICATE = (Predicate)isItem3d.getValue();
        }

        private record ItemOrdering(Item item, Item anchor, Type type) {
            public static ItemOrdering before(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }
}

