/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.collections;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.equipment.zapper.ElectroZapperS2CPacket;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.network.packets.BlockWireAttachC2SPacket;
import org.patryk3211.powergrid.network.packets.BlockWireCutC2SPacket;
import org.patryk3211.powergrid.network.packets.ChangeScreenC2SPacket;
import org.patryk3211.powergrid.network.packets.EndpointTrackingC2SPacket;
import org.patryk3211.powergrid.network.packets.EntityDataS2CPacket;
import org.patryk3211.powergrid.network.packets.LightningSyncS2CPacket;
import org.patryk3211.powergrid.network.packets.MultimeterDataC2SPacket;
import org.patryk3211.powergrid.network.packets.SaveSchematicC2SPacket;
import org.patryk3211.powergrid.network.packets.SolverStateS2CPacket;
import org.patryk3211.powergrid.network.packets.TransformerWindingC2SPacket;
import org.patryk3211.powergrid.network.packets.TransmissionLineManagementS2CPacket;
import org.patryk3211.powergrid.network.packets.TransmissionLineStateS2CPacket;
import org.patryk3211.powergrid.network.packets.UpdateComponentBiPacket;
import org.patryk3211.powergrid.network.packets.ZapProjectileS2CPacket;
import org.patryk3211.powergrid.utility.PlayerLookup;

public enum ModdedPackets {
    ELECTRO_ZAPPER_SHOOT(ElectroZapperS2CPacket.class, ElectroZapperS2CPacket::new, true),
    ZAP_PROJECTILE(ZapProjectileS2CPacket.class, ZapProjectileS2CPacket::new),
    SOLVER_SYNC(SolverStateS2CPacket.class, SolverStateS2CPacket::new),
    TRANSMISSION_LINE_STATE(TransmissionLineStateS2CPacket.class, TransmissionLineStateS2CPacket::new),
    TRANSMISSION_LINE_MANAGEMENT(TransmissionLineManagementS2CPacket.class, TransmissionLineManagementS2CPacket::new),
    LIGHTNING_SYNC(LightningSyncS2CPacket.class, LightningSyncS2CPacket::new),
    ENTITY_DATA(EntityDataS2CPacket.class, EntityDataS2CPacket::new),
    TRANSFORMER_WINDING(TransformerWindingC2SPacket.class, TransformerWindingC2SPacket::new),
    CHANGE_SCREEN(ChangeScreenC2SPacket.class, ChangeScreenC2SPacket::new),
    SAVE_SCHEMATIC(SaveSchematicC2SPacket.class, SaveSchematicC2SPacket::new),
    BLOCK_WIRE_CUT(BlockWireCutC2SPacket.class, BlockWireCutC2SPacket::new),
    BLOCK_WIRE_ATTACH(BlockWireAttachC2SPacket.class, BlockWireAttachC2SPacket::new),
    ENDPOINT_TRACKING(EndpointTrackingC2SPacket.class, EndpointTrackingC2SPacket::new),
    MULTIMETER_DATA(MultimeterDataC2SPacket.class, MultimeterDataC2SPacket::new),
    UPDATE_COMPONENT(UpdateComponentBiPacket.class, UpdateComponentBiPacket::new);

    public static final ResourceLocation CHANNEL_NAME;
    private static NetworkChannel channel;
    private final PacketType<?> type;

    private <T extends SimplePacket> ModdedPackets(Class<T> type, Function<FriendlyByteBuf, T> factory) {
        this.type = new PacketType<SimplePacket>(type, SimplePacket::encode, factory, SimplePacket::handle);
    }

    private ModdedPackets(Class<ElectroZapperS2CPacket> type, Function<FriendlyByteBuf, ElectroZapperS2CPacket> factory, boolean dummy) {
        this.type = new PacketType<ElectroZapperS2CPacket>(type, SimplePacketBase::write, factory, ElectroZapperS2CPacket::handle);
    }

    public static void registerPackets() {
        channel = NetworkChannel.create((ResourceLocation)CHANNEL_NAME);
        for (ModdedPackets packet : ModdedPackets.values()) {
            packet.type.register();
        }
    }

    public static NetworkChannel getChannel() {
        return channel;
    }

    public static <T> void sendToServer(T packet) {
        channel.sendToServer(packet);
    }

    public static <T> void sendToClient(T packet, ServerPlayer player) {
        channel.sendToPlayer(player, packet);
    }

    public static <T> void sendToClients(T packet, Iterable<ServerPlayer> players) {
        channel.sendToPlayers(players, packet);
    }

    public static <T> void sendToClientsTracking(T packet, BlockEntity be) {
        channel.sendToPlayers(PlayerLookup.tracking(be), packet);
    }

    public static <T> void sendToClientsTracking(T packet, Entity e) {
        channel.sendToPlayers(PlayerLookup.tracking(e), packet);
    }

    public static <T> void sendToClientsAround(T packet, ServerLevel world, Vec3 position, double radius) {
        channel.sendToPlayers(PlayerLookup.around(world, position, radius), packet);
    }

    public static <T> void sendToClientsAround(T packet, ServerLevel world, Vec3i position, double radius) {
        channel.sendToPlayers(PlayerLookup.around(world, position, radius), packet);
    }

    static {
        CHANNEL_NAME = PowerGrid.asResource("main");
    }

    public static class PacketType<T> {
        private final BiConsumer<T, FriendlyByteBuf> encoder;
        private final Function<FriendlyByteBuf, T> decoder;
        private final BiConsumer<T, Supplier<NetworkManager.PacketContext>> handler;
        private final Class<T> type;

        private PacketType(Class<T> type, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> handler) {
            this.encoder = encoder;
            this.decoder = decoder;
            this.handler = handler;
            this.type = type;
        }

        private void register() {
            ModdedPackets.getChannel().register(this.type, this.encoder, this.decoder, this.handler);
        }
    }
}

