/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.patryk3211.powergrid.electricity.sim.PerformanceCounter;
import org.patryk3211.powergrid.utility.NumberFormats;

public class PerformanceCommand {
    public static PerformanceCounterArgument argument() {
        return PerformanceCounterArgument.INSTANCE;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"performance").then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"counter_name", (ArgumentType)PerformanceCommand.argument()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            PerformanceCounter counter = (PerformanceCounter)ctx.getArgument("counter_name", PerformanceCounter.class);
            source.m_243053_((Component)Component.m_237113_((String)("Performance counter '" + counter.getName() + "':")).m_130940_(ChatFormatting.GRAY));
            source.m_243053_((Component)Component.m_237113_((String)"  Last measurement: ").m_7220_((Component)Component.m_237113_((String)counter.getTimestamp()).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            source.m_243053_((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237113_((String)"Min").m_130940_(ChatFormatting.GRAY)).m_130946_(" / ").m_7220_((Component)Component.m_237113_((String)"Max").m_130940_(ChatFormatting.GRAY)).m_130946_(" / ").m_7220_((Component)Component.m_237113_((String)"Avg").m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
            source.m_243053_((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237113_((String)(NumberFormats.formatConstant(counter.getMin()) + "\u00b5s")).m_130940_(ChatFormatting.AQUA)).m_130946_(" / ").m_7220_((Component)Component.m_237113_((String)(NumberFormats.formatConstant(counter.getMax()) + "\u00b5s")).m_130940_(ChatFormatting.AQUA)).m_130946_(" / ").m_7220_((Component)Component.m_237113_((String)(NumberFormats.formatConstant(counter.getAvg()) + "\u00b5s")).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.DARK_GRAY));
            return 1;
        })))).then(Commands.m_82127_((String)"period").then(Commands.m_82129_((String)"counter_name", (ArgumentType)PerformanceCommand.argument()).then(Commands.m_82129_((String)"ms_period", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            PerformanceCounter counter = (PerformanceCounter)ctx.getArgument("counter_name", PerformanceCounter.class);
            Integer period = (Integer)ctx.getArgument("ms_period", Integer.class);
            source.m_243053_((Component)Component.m_237113_((String)("Performance counter '" + counter.getName() + "' measurement period set to " + period + "ms")).m_130940_(ChatFormatting.GRAY));
            counter.setMeasurementTime(period);
            return 1;
        }))));
    }

    public static class PerformanceCounterArgument
    implements ArgumentType<PerformanceCounter> {
        public static final PerformanceCounterArgument INSTANCE = new PerformanceCounterArgument();

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return CompletableFuture.supplyAsync(() -> {
                for (PerformanceCounter counter : PerformanceCounter.COUNTERS) {
                    builder.suggest(counter.getName());
                }
                return builder.build();
            });
        }

        public PerformanceCounter parse(StringReader reader) throws CommandSyntaxException {
            int start = reader.getCursor();
            while (reader.canRead() && (StringReader.isAllowedInUnquotedString((char)reader.peek()) || reader.peek() == ':')) {
                reader.skip();
            }
            String name = reader.getString().substring(start, reader.getCursor());
            PerformanceCounter prev = null;
            boolean cleanup = false;
            for (PerformanceCounter counter : PerformanceCounter.COUNTERS) {
                if (!name.equals(counter.getName())) continue;
                if (prev != null) {
                    cleanup = true;
                }
                prev = counter;
            }
            if (cleanup) {
                Iterator<PerformanceCounter> iter = PerformanceCounter.COUNTERS.iterator();
                while (iter.hasNext()) {
                    PerformanceCounter counter;
                    counter = iter.next();
                    if (!name.equals(counter.getName()) || counter == prev) continue;
                    iter.remove();
                }
            }
            if (prev != null) {
                return prev;
            }
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Performance counter '" + name + "' doesn't exist!")).m_130940_(ChatFormatting.RED)).create();
        }
    }
}

