/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.config;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.config.WireValues;
import org.patryk3211.powergrid.electricity.wire.WireItem;

public class CWire
extends ConfigBase
implements WireValues.Provider {
    private static final int VERSION = 1;
    private static final Object2DoubleMap<ResourceLocation> DEFAULT_VALUES = new Object2DoubleOpenHashMap();
    protected final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> values = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(".").push("wire");
        DEFAULT_VALUES.forEach((id, value) -> this.values.put((ResourceLocation)id, (ForgeConfigSpec.ConfigValue<Double>)builder.define(id.m_135815_(), value)));
        builder.pop();
    }

    public String getName() {
        return "wires-v1";
    }

    @Nullable
    public DoubleSupplier get(WireItem item, String suffix) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_266382_("." + suffix);
        ForgeConfigSpec.ConfigValue<Double> entry = this.values.get(id);
        return entry == null ? null : () -> entry.get();
    }

    @Override
    @Nullable
    public DoubleSupplier resistance(WireItem wire) {
        return this.get(wire, "resistance");
    }

    @Override
    @Nullable
    public DoubleSupplier maxLength(WireItem wire) {
        return this.get(wire, "max-length");
    }

    @Override
    @Nullable
    public DoubleSupplier thermalMass(WireItem wire) {
        return this.get(wire, "thermal-mass");
    }

    @Override
    @Nullable
    public DoubleSupplier dissipationFactor(WireItem wire) {
        DoubleSupplier pR = this.get(wire, "resistance");
        DoubleSupplier pI = this.get(wire, "max-current");
        if (pR == null || pI == null) {
            return null;
        }
        return () -> {
            double R = pR.getAsDouble();
            double I = pI.getAsDouble();
            double P = R * I * I;
            return P / 150.0;
        };
    }

    private static void add(ItemBuilder<?, ?> builder, String suffix, double value) {
        ResourceLocation id = PowerGrid.asResource(builder.getName()).m_266382_("." + suffix);
        DEFAULT_VALUES.put((Object)id, value);
    }

    public static <I extends WireItem, P> NonNullUnaryOperator<ItemBuilder<I, P>> set(double resistance, double maxLength, double thermalMass, double maxCurrent) {
        return builder -> {
            CWire.assertFromPowerGrid(builder);
            CWire.add(builder, "resistance", resistance);
            CWire.add(builder, "max-length", maxLength);
            CWire.add(builder, "thermal-mass", thermalMass);
            CWire.add(builder, "max-current", maxCurrent);
            return builder;
        };
    }

    private static void assertFromPowerGrid(ItemBuilder<?, ?> builder) {
        if (!builder.getOwner().getModid().equals("powergrid")) {
            throw new IllegalStateException("Non-Power Grid blocks cannot be added to Power Grid's config.");
        }
    }
}

