/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity;

import com.google.common.collect.Sets;
import io.netty.util.collection.IntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.GraphedElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.NetworkGraph;
import org.patryk3211.powergrid.electricity.sim.PerformanceCounter;
import org.patryk3211.powergrid.electricity.sim.node.ICouplingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.JunctionWireEndpoint;
import org.patryk3211.powergrid.network.packets.TransmissionLineManagementS2CPacket;
import org.patryk3211.powergrid.network.packets.TransmissionLineStateS2CPacket;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class WorldNetworks
extends SavedData
implements NetworkGraph.IGraphModifyHooks {
    public final Level world;
    public final NetworkGraph globalGraph = new NetworkGraph();
    protected final PerformanceCounter perf;
    public final List<ElectricalNetwork> subnetworks = new ArrayList<ElectricalNetwork>();
    public final Map<Integer, TransmissionLine> transmissionLines = new IntObjectHashMap();
    public final Map<IWireEndpoint, OwnedFloatingNode> globalExternalNodes = new HashMap<IWireEndpoint, OwnedFloatingNode>();
    private final Map<ChunkPos, CheckChunk> expectedInChunks = new ConcurrentHashMap<ChunkPos, CheckChunk>();
    private final Map<ChunkPos, CheckChunk> checkForExistence = new ConcurrentHashMap<ChunkPos, CheckChunk>();
    private final Map<PartId, TransmissionLinePart> lineParts = new HashMap<PartId, TransmissionLinePart>();
    private final Map<OwnedFloatingNode, Set<TransmissionLinePart>> partNodeMap = new HashMap<OwnedFloatingNode, Set<TransmissionLinePart>>();
    private final Map<IWireEndpoint, Set<ServerPlayer>> trackers = new HashMap<IWireEndpoint, Set<ServerPlayer>>();
    private final Set<IWireEndpoint> updatedEndpoints = new HashSet<IWireEndpoint>();
    private final Set<TransmissionLinePart> deferredRewireEntities = new HashSet<TransmissionLinePart>();
    protected final Set<ElectricalNetwork> islandDiscoveryQueue = new HashSet<ElectricalNetwork>();
    private int syncTicks = 0;

    public WorldNetworks(Level world) {
        this.world = world;
        this.globalGraph.hooks = this;
        this.perf = new PerformanceCounter(world.m_220362_().m_135782_().toString());
    }

    public WorldNetworks(Level world, CompoundTag nbt) {
        this(world);
        this.readNbt(nbt);
    }

    @Override
    public void lineConnected(TransmissionLine line) {
        TransmissionLine line2;
        int id = line.getId();
        this.transmissionLines.put(id, line);
        this.updatedEndpoints.add(line.getEndpoint1());
        this.updatedEndpoints.add(line.getEndpoint2());
        this.updatedEndpoints.add(line.getNode1().endpoint);
        this.updatedEndpoints.add(line.getNode2().endpoint);
        TransmissionLine line1 = this.findLineMiddle(line.getNode1());
        if (line1 != null) {
            line1.splitAt(line.getNode1());
        }
        if ((line2 = this.findLineMiddle(line.getNode2())) != null) {
            line2.splitAt(line.getNode2());
        }
        this.m_77762_();
    }

    @Override
    public void lineDisconnected(TransmissionLine line) {
        this.transmissionLines.remove(line.getId());
        this.islandDiscoveryQueue.add(line.getNetwork());
        this.updatedEndpoints.add(line.getEndpoint1());
        this.updatedEndpoints.add(line.getEndpoint2());
        this.updatedEndpoints.add(line.getNode1().endpoint);
        this.updatedEndpoints.add(line.getNode2().endpoint);
        this.m_77762_();
    }

    private void traceIsland(OwnedFloatingNode first) {
    }

    private void runIslandDiscoveryFor(ElectricalNetwork network) {
        HashSet visited = new HashSet();
    }

    public void tick() {
        this.deferredRewireEntities.removeIf(part -> {
            part.refreshEndpointNodes();
            return true;
        });
        JunctionWireEndpoint.processNewNodes(this.world);
        for (ElectricalNetwork network : this.islandDiscoveryQueue) {
            this.runIslandDiscoveryFor(network);
        }
        this.islandDiscoveryQueue.clear();
        this.perf.start();
        Iterator<ElectricalNetwork> iter = this.subnetworks.iterator();
        while (iter.hasNext()) {
            ElectricalNetwork network;
            network = iter.next();
            if (network.isEmpty()) {
                iter.remove();
                continue;
            }
            network.calculate();
        }
        this.perf.end();
        Level level = this.world;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            Iterator<Map.Entry<ChunkPos, CheckChunk>> checkIter = this.checkForExistence.entrySet().iterator();
            while (checkIter.hasNext()) {
                Map.Entry<ChunkPos, CheckChunk> entry = checkIter.next();
                ChunkPos chunk = (ChunkPos)entry.getKey();
                if (!this.world.m_7232_(chunk.f_45578_, chunk.f_45579_)) {
                    if (this.expectedInChunks.containsKey(chunk)) {
                        this.expectedInChunks.get(chunk).addAll(((CheckChunk)entry.getValue()).entities);
                        continue;
                    }
                    ((CheckChunk)entry.getValue()).ticks = 0;
                    this.expectedInChunks.put(chunk, (CheckChunk)entry.getValue());
                    continue;
                }
                boolean remove = ((CheckChunk)entry.getValue()).ticks++ >= 10;
                Iterator<PartId> entityIter = ((CheckChunk)entry.getValue()).entities.iterator();
                while (entityIter.hasNext()) {
                    PartId id = entityIter.next();
                    if (id.getEntity(serverWorld) == null) {
                        TransmissionLinePart part2;
                        if (!remove || (part2 = this.lineParts.get(id)) == null) continue;
                        TransmissionLine line = part2.getLine();
                        if (line != null) {
                            line.remove();
                            continue;
                        }
                        part2.remove();
                        continue;
                    }
                    entityIter.remove();
                }
                if (!remove && !((CheckChunk)entry.getValue()).entities.isEmpty()) continue;
                checkIter.remove();
            }
            for (IWireEndpoint endpoint : this.updatedEndpoints) {
                Set<ServerPlayer> players = this.trackers.get(endpoint);
                if (players == null) continue;
                Collection<TransmissionLine> lines = this.globalGraph.getConnectedLines(endpoint.getNode(this.world));
                ModdedPackets.sendToClients(new TransmissionLineManagementS2CPacket(endpoint, lines), players);
            }
            this.updatedEndpoints.clear();
            Iterator<TransmissionLine> iter2 = this.transmissionLines.values().iterator();
            ArrayList<TransmissionLine> removed = new ArrayList<TransmissionLine>();
            while (iter2.hasNext()) {
                Collection<ServerPlayer> players;
                TransmissionLine line = iter2.next();
                if (line.segments.isEmpty()) {
                    PowerGrid.LOGGER.warn("Empty transmission line {} dropped during tick", (Object)line);
                    removed.add(line);
                    iter2.remove();
                    continue;
                }
                if ((double)Math.abs(line.current()) < 1.0E-5 || (players = PlayerUtilities.partialTracking(serverWorld, line)).isEmpty()) continue;
                try {
                    TransmissionLineStateS2CPacket packet = new TransmissionLineStateS2CPacket(line);
                    ModdedPackets.sendToClients(packet, players);
                }
                catch (RuntimeException e) {
                    PowerGrid.LOGGER.error("Failed to send a transmission line packet", (Throwable)e);
                }
            }
            removed.forEach(TransmissionLine::remove);
            if (this.syncTicks++ >= 40) {
                for (ElectricalNetwork network : this.subnetworks) {
                    for (INode node : network.getNodes()) {
                        BlockWireEndpoint bwe;
                        ElectricBehaviour behaviour;
                        if (!(node instanceof OwnedFloatingNode)) continue;
                        OwnedFloatingNode owned = (OwnedFloatingNode)node;
                        IWireEndpoint iWireEndpoint = owned.endpoint;
                        if (!(iWireEndpoint instanceof BlockWireEndpoint) || (behaviour = (bwe = (BlockWireEndpoint)iWireEndpoint).getElectricBehaviour(this.world)) == null) continue;
                        behaviour.blockEntity.sendData();
                    }
                }
                this.syncTicks = 0;
            }
        }
    }

    public ElectricalNetwork newNetwork() {
        GraphedElectricalNetwork network = new GraphedElectricalNetwork(this.globalGraph, true);
        network.maxIterations = hooks -> hooks != false ? (Integer)ModdedConfigs.common().solverComplexMaxIterations.get() : (Integer)ModdedConfigs.common().solverSimpleMaxIterations.get();
        this.subnetworks.add(network);
        return network;
    }

    public void add(IWireEndpoint endpoint) {
        OwnedFloatingNode node = endpoint.getNode(this.world);
        this.globalGraph.addNode(node);
        this.addAndMigrateNode(endpoint);
    }

    public int connectionCount(IWireEndpoint endpoint) {
        return this.globalGraph.connectionCount(endpoint.getNode(this.world));
    }

    @Nullable
    public TransmissionLine findLineMiddle(OwnedFloatingNode node) {
        Set<TransmissionLinePart> parts = this.partNodeMap.get(node);
        if (parts == null) {
            return null;
        }
        for (TransmissionLinePart part1 : parts) {
            for (TransmissionLinePart part2 : parts) {
                if (part1 == part2 || part1.getLine() != part2.getLine() || part1.getLine() == null) continue;
                return part1.getLine();
            }
        }
        return null;
    }

    @Deprecated
    public void assignTransmissionLine(OwnedFloatingNode node, @Nullable TransmissionLine line) {
        this.updatedEndpoints.add(node.endpoint);
    }

    @Nullable
    public ElectricalNetwork prepareForConnection(IWireEndpoint endpoint1, IWireEndpoint endpoint2) {
        ElectricalNetwork network;
        TransmissionLine line2;
        OwnedFloatingNode node2;
        OwnedFloatingNode node1 = endpoint1.getNode(this.world);
        if (node1 == (node2 = endpoint2.getNode(this.world))) {
            return null;
        }
        if (node1 == null || node2 == null) {
            return null;
        }
        this.add(endpoint1);
        this.add(endpoint2);
        TransmissionLine line1 = this.findLineMiddle(node1);
        if (line1 != null) {
            line1.splitAt(node1);
        }
        if ((line2 = this.findLineMiddle(node2)) != null) {
            line2.splitAt(node2);
        }
        ElectricalNetwork net1 = node1.getNetwork();
        ElectricalNetwork net2 = node2.getNetwork();
        if (net1 == null && net2 == null) {
            network = this.newNetwork();
            endpoint1.joinNetwork(this.world, network);
            endpoint2.joinNetwork(this.world, network);
        } else if (net1 == null) {
            network = net2;
            endpoint1.joinNetwork(this.world, network);
        } else if (net2 == null) {
            network = net1;
            endpoint2.joinNetwork(this.world, network);
        } else if (net1 != net2) {
            if (net1.size() >= net2.size()) {
                network = net1;
                network.merge(net2);
            } else {
                network = net2;
                network.merge(net1);
            }
        } else {
            network = net1;
        }
        return network;
    }

    @Nullable
    public ElectricalNetwork prepareForConnection(@NotNull OwnedFloatingNode node1, @NotNull OwnedFloatingNode node2) {
        ElectricalNetwork network;
        TransmissionLine line2;
        IWireEndpoint endpoint1 = node1.endpoint;
        IWireEndpoint endpoint2 = node2.endpoint;
        if (node1 == node2) {
            return null;
        }
        this.add(endpoint1);
        this.add(endpoint2);
        TransmissionLine line1 = this.findLineMiddle(node1);
        if (line1 != null) {
            line1.splitAt(node1);
        }
        if ((line2 = this.findLineMiddle(node2)) != null) {
            line2.splitAt(node2);
        }
        ElectricalNetwork net1 = node1.getNetwork();
        ElectricalNetwork net2 = node2.getNetwork();
        if (net1 == null && net2 == null) {
            network = this.newNetwork();
            endpoint1.joinNetwork(this.world, network);
            endpoint2.joinNetwork(this.world, network);
        } else if (net1 == null) {
            network = net2;
            endpoint1.joinNetwork(this.world, network);
        } else if (net2 == null) {
            network = net1;
            endpoint2.joinNetwork(this.world, network);
        } else if (net1 != net2) {
            if (net1.size() >= net2.size()) {
                network = net1;
                network.merge(net2);
            } else {
                network = net2;
                network.merge(net1);
            }
        } else {
            network = net1;
        }
        return network;
    }

    @Nullable
    protected TransmissionLinePart tryGrabUnloadedPart(IWireEndpoint endpoint1, IWireEndpoint endpoint2, BaseWireEntity forEntity, PartId id) {
        this.resolveTree(endpoint1);
        this.resolveTree(endpoint2);
        TransmissionLinePart existingPart = this.lineParts.get(id);
        if (existingPart != null) {
            existingPart.grab(forEntity, id);
            return existingPart;
        }
        return null;
    }

    private boolean makeTransmissionLine(TransmissionLinePart linePart) {
        TransmissionLine curLine;
        AbstractElectricWire wire;
        IWireEndpoint endpoint2;
        if (linePart.getLine() != null) {
            return true;
        }
        IWireEndpoint endpoint1 = linePart.getEndpoint1();
        ElectricalNetwork network = this.prepareForConnection(endpoint1, endpoint2 = linePart.getEndpoint2());
        if (network == null) {
            return false;
        }
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("Creating a transmission line for {}", (Object)linePart);
        }
        OwnedFloatingNode node1 = endpoint1.getNode(this.world);
        OwnedFloatingNode node2 = endpoint2.getNode(this.world);
        this.movePartMap(linePart.getNode1(), node1, linePart);
        linePart.setNode1(node1);
        this.movePartMap(linePart.getNode2(), node2, linePart);
        linePart.setNode2(node2);
        int nConns1 = this.connectionCount(endpoint1);
        int nConns2 = this.connectionCount(endpoint2);
        IElectricNode connected1 = nConns1 == 1 ? this.globalGraph.getConnectedNodes(node1).get(0) : null;
        IElectricNode connected2 = nConns2 == 1 ? this.globalGraph.getConnectedNodes(node2).get(0) : null;
        TransmissionLine line1 = null;
        TransmissionLine line2 = null;
        if (nConns1 == 1 && (wire = this.globalGraph.getFirstWire(node1, connected1)) instanceof TransmissionLine) {
            line1 = curLine = (TransmissionLine)wire;
        }
        if (nConns2 == 1 && (wire = this.globalGraph.getFirstWire(node2, connected2)) instanceof TransmissionLine) {
            line2 = curLine = (TransmissionLine)wire;
            if (line1 != null) {
                if (line1 != line2) {
                    linePart.setLine(line1);
                    if (ModdedConfigs.logsEnabled()) {
                        PowerGrid.LOGGER.debug("{}: Extending line at end by wire {}, terminating node is now {}", new Object[]{line1, linePart, node2});
                    }
                    if (line1.getNode2() != node1) {
                        line1.flip();
                    }
                    line1.addLastSegment(linePart);
                    if (ModdedConfigs.logsEnabled()) {
                        PowerGrid.LOGGER.debug("{}: Merging transmission lines between {} and {}", new Object[]{line1, node1, node2});
                    }
                    if (curLine.getNode1() != line1.getNode2()) {
                        curLine.flip();
                    }
                    line1.merge(curLine);
                } else {
                    line2 = null;
                }
                line1 = null;
            } else {
                linePart.setLine(line2);
                if (ModdedConfigs.logsEnabled()) {
                    PowerGrid.LOGGER.debug("{}: Extending line at beginning by wire {}, starting node is now {}", new Object[]{line2, linePart, node1});
                }
                if (line2.getNode1() != node2) {
                    line2.flip();
                }
                line2.addFirstSegment(linePart);
            }
        }
        if (line1 != null) {
            linePart.setLine(line1);
            if (ModdedConfigs.logsEnabled()) {
                PowerGrid.LOGGER.debug("{}: Extending line at end by wire {}, terminating node is now {}", new Object[]{line1, linePart, node2});
            }
            if (line1.getNode2() != node1) {
                line1.flip();
            }
            line1.addLastSegment(linePart);
        }
        if (line1 == null && line2 == null) {
            TransmissionLine line = new TransmissionLine(linePart.getResistance(), endpoint1, endpoint2, this);
            linePart.setLine(line);
            line.segments.add(linePart);
            network.addWire(line);
            if (ModdedConfigs.logsEnabled()) {
                PowerGrid.LOGGER.debug("{}: New transmission line between {} and {}", new Object[]{line, node1, node2});
            }
        }
        this.m_77762_();
        return true;
    }

    @Nullable
    public ElectricWire makeTransmissionLine(IWireEndpoint endpoint1, IWireEndpoint endpoint2, BaseWireEntity forEntity, PartId id) {
        this.add(endpoint1);
        this.add(endpoint2);
        TransmissionLinePart linePart = this.tryGrabUnloadedPart(endpoint1, endpoint2, forEntity, id);
        if (linePart != null && linePart.getLine() != null) {
            return linePart;
        }
        if (linePart == null) {
            linePart = TransmissionLinePart.uniquePart(forEntity.getResistance(), endpoint1, endpoint2, forEntity, this, id);
        }
        if (this.makeTransmissionLine(linePart)) {
            return linePart;
        }
        return null;
    }

    public List<TransmissionLinePart> findConnectedWires(ElectricBehaviour behaviour) {
        ArrayList<TransmissionLinePart> wires = new ArrayList<TransmissionLinePart>();
        for (OwnedFloatingNode node : behaviour.getExternalNodes()) {
            Set<TransmissionLinePart> parts = this.partNodeMap.get(node);
            if (parts == null) continue;
            wires.addAll(parts);
        }
        return wires;
    }

    public void deferredRewire(Collection<TransmissionLinePart> wires) {
        this.deferredRewireEntities.addAll(wires);
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        ListTag partList = new ListTag();
        for (TransmissionLinePart part : this.lineParts.values()) {
            partList.add((Object)part.toNbt());
        }
        nbt.m_128365_("Parts", (Tag)partList);
        return nbt;
    }

    protected void readNbt(CompoundTag nbt) {
        ListTag partList = nbt.m_128437_("Parts", 10);
        for (Tag entryGeneric : partList) {
            CompoundTag partEntry = (CompoundTag)entryGeneric;
            TransmissionLinePart.uniquePart(partEntry, this);
        }
    }

    public void nodeHolderUnloaded(@NotNull OwnedFloatingNode ownedNode) {
        Collection<TransmissionLine> lines;
        while ((lines = this.globalGraph.getConnectedLines(ownedNode)).size() == 1) {
            TransmissionLine line = lines.iterator().next();
            OwnedFloatingNode removeNode = ownedNode;
            if (line.getNode1() == ownedNode) {
                ownedNode = line.getNode2();
            } else {
                assert (line.getNode2() == ownedNode);
                ownedNode = line.getNode1();
            }
            line.unresolve();
            this.m_77762_();
            if (removeNode.getNetwork() != null) {
                removeNode.getNetwork().removeNode(removeNode);
            }
            this.globalExternalNodes.remove(removeNode.endpoint);
        }
    }

    public void nodeHolderRemoved(@NotNull OwnedFloatingNode ownedNode) {
        Set<TransmissionLinePart> parts = this.partNodeMap.remove(ownedNode);
        if (parts != null && !parts.isEmpty()) {
            for (TransmissionLinePart part : parts) {
                if (part.owner != null) {
                    part.owner.m_6074_();
                    continue;
                }
                part.remove();
            }
        }
        if (ownedNode.getNetwork() != null) {
            ownedNode.getNetwork().removeNode(ownedNode);
        }
        this.globalExternalNodes.remove(ownedNode.endpoint);
    }

    private boolean traceTree(IWireEndpoint endpoint, Set<IWireEndpoint> visited) {
        if (!visited.add(endpoint)) {
            return false;
        }
        List<TransmissionLinePart> parts = (List<TransmissionLinePart>)((Object)this.partNodeMap.get(this.globalExternalNodes.get(endpoint)));
        if (parts == null) {
            return false;
        }
        parts = List.copyOf(parts);
        boolean continueResolving = false;
        for (TransmissionLinePart part : parts) {
            if (part.getLine() != null) {
                continueResolving = true;
            }
            if (parts.size() == 1) {
                if (ModdedConfigs.logsEnabled()) {
                    PowerGrid.LOGGER.debug("Found edge line at {}", (Object)endpoint);
                }
                if (part.getEndpoint1().equals(endpoint)) {
                    if (!part.getEndpoint2().isValid(this.world)) break;
                    this.makeTransmissionLine(part);
                    return true;
                }
                if (!part.getEndpoint2().equals(endpoint) || !part.getEndpoint1().isValid(this.world)) break;
                this.makeTransmissionLine(part);
                return true;
            }
            if (ModdedConfigs.logsEnabled()) {
                PowerGrid.LOGGER.debug("Continuing line trace through {}", (Object)endpoint);
            }
            if (part.getEndpoint1().equals(endpoint)) {
                if (!this.traceTree(part.getEndpoint2(), visited)) continue;
                this.makeTransmissionLine(part);
                continueResolving = true;
                continue;
            }
            if (!part.getEndpoint2().equals(endpoint) || !this.traceTree(part.getEndpoint1(), visited)) continue;
            this.makeTransmissionLine(part);
            continueResolving = true;
        }
        return continueResolving;
    }

    private void resolveTree(@NotNull IWireEndpoint endpoint) {
        Set<TransmissionLinePart> unresolvedLines = this.partNodeMap.get(this.globalExternalNodes.get(endpoint));
        if (unresolvedLines == null) {
            return;
        }
        HashSet<IWireEndpoint> visited = new HashSet<IWireEndpoint>();
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("Starting line trace at {}", (Object)endpoint);
        }
        this.traceTree(endpoint, visited);
    }

    public void addAndMigrateNode(IWireEndpoint endpoint) {
        OwnedFloatingNode newNode = endpoint.getNode(this.world);
        if (newNode == null) {
            return;
        }
        this.addAndMigrateNode(newNode);
    }

    public void addAndMigrateNode(OwnedFloatingNode newNode) {
        IWireEndpoint endpoint = newNode.endpoint;
        OwnedFloatingNode oldNode = this.globalExternalNodes.put(endpoint, newNode);
        this.addAndMigrateNode(oldNode, newNode);
    }

    public void addAndMigrateNode(IWireEndpoint oldEndpoint, OwnedFloatingNode newNode) {
        IWireEndpoint endpoint = newNode.endpoint;
        OwnedFloatingNode oldNode = this.globalExternalNodes.put(endpoint, newNode);
        this.addAndMigrateNode(oldNode, newNode);
        this.updatedEndpoints.add(oldEndpoint);
        OwnedFloatingNode oldNode2 = this.globalExternalNodes.remove(oldEndpoint);
        this.addAndMigrateNode(oldNode2, newNode);
        TransmissionLine line = this.findLineMiddle(newNode);
        if (line != null) {
            line.splitAt(newNode);
        }
    }

    public void addAndMigrateNode(OwnedFloatingNode oldNode, OwnedFloatingNode newNode) {
        IWireEndpoint endpoint = newNode.endpoint;
        this.updatedEndpoints.add(endpoint);
        if (oldNode != null && oldNode != newNode) {
            Set<TransmissionLinePart> parts;
            if (ModdedConfigs.logsEnabled()) {
                PowerGrid.LOGGER.debug("Migrating external node from {} to {}", (Object)oldNode, (Object)newNode);
            }
            if ((parts = this.partNodeMap.remove(oldNode)) != null) {
                for (TransmissionLinePart part : parts) {
                    Object line;
                    if (ModdedConfigs.logsEnabled()) {
                        PowerGrid.LOGGER.debug("Migrating node for part {}", (Object)part);
                    }
                    if (part.getEndpoint1().equals(endpoint) || part.getNode1() == oldNode) {
                        part.setNode1(newNode);
                        if (ModdedConfigs.logsEnabled()) {
                            PowerGrid.LOGGER.debug("Part {} has had its node migrated", (Object)part);
                        }
                        if ((line = part.getLine()) != null && ((TransmissionLine)line).getNode1() == oldNode) {
                            this.inNetwork(((AbstractElectricWire)line).getNetwork(), newNode);
                            ((TransmissionLine)line).setNode1(newNode);
                            if (ModdedConfigs.logsEnabled()) {
                                PowerGrid.LOGGER.debug("Line {} has had its node migrated", line);
                            }
                        }
                    }
                    if (part.getEndpoint2().equals(endpoint) || part.getNode2() == oldNode) {
                        part.setNode2(newNode);
                        if (ModdedConfigs.logsEnabled()) {
                            PowerGrid.LOGGER.debug("Part {} has had its node migrated", (Object)part);
                        }
                        if ((line = part.getLine()) != null && ((TransmissionLine)line).getNode2() == oldNode) {
                            this.inNetwork(((AbstractElectricWire)line).getNetwork(), newNode);
                            ((TransmissionLine)line).setNode2(newNode);
                            if (ModdedConfigs.logsEnabled()) {
                                PowerGrid.LOGGER.debug("Line {} has had its node migrated", line);
                            }
                        }
                    }
                    this.partNodeMap.computeIfAbsent(newNode, $ -> new HashSet()).add(part);
                }
            }
            if (oldNode.getNetwork() != null) {
                this.inNetwork(oldNode.getNetwork(), newNode);
                ElectricalNetwork unified = oldNode.getNetwork();
                List<TransmissionLine> lines = List.copyOf(this.globalGraph.getConnectedLines(oldNode));
                for (TransmissionLine line : lines) {
                    if (line.getNode1() == oldNode) {
                        line.setNode1(newNode);
                        if (!ModdedConfigs.logsEnabled()) continue;
                        PowerGrid.LOGGER.debug("Line {} has had its node migrated", (Object)line);
                        continue;
                    }
                    if (line.getNode2() != oldNode) continue;
                    line.setNode2(newNode);
                    if (!ModdedConfigs.logsEnabled()) continue;
                    PowerGrid.LOGGER.debug("Line {} has had its node migrated", (Object)line);
                }
                unified.removeNode(oldNode);
            } else {
                TransmissionLine line = this.findLineMiddle(oldNode);
                if (line != null) {
                    for (TransmissionLinePart segment : line.segments) {
                        if (segment.getNode1() == oldNode || segment.getEndpoint1().equals(endpoint)) {
                            this.movePartMap(segment.getNode1(), newNode, segment);
                            segment.setNode1(newNode);
                            if (!ModdedConfigs.logsEnabled()) continue;
                            PowerGrid.LOGGER.debug("Line {} has had its internal node migrated", (Object)line);
                            continue;
                        }
                        if (segment.getNode2() != oldNode && !segment.getEndpoint2().equals(endpoint)) continue;
                        this.movePartMap(segment.getNode2(), newNode, segment);
                        segment.setNode2(newNode);
                        if (!ModdedConfigs.logsEnabled()) continue;
                        PowerGrid.LOGGER.debug("Line {} has had its internal node migrated", (Object)line);
                    }
                }
            }
        }
    }

    public void nodeHolderAdded(@NotNull OwnedFloatingNode ownedNode, boolean hasInternals) {
        TransmissionLine line;
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("Node holder added, {}", (Object)ownedNode);
        }
        this.addAndMigrateNode(ownedNode.endpoint);
        this.resolveTree(ownedNode.endpoint);
        if (hasInternals && (line = this.findLineMiddle(ownedNode)) != null) {
            line.splitAt(ownedNode);
        }
    }

    public void prepareUnpaused(OwnedFloatingNode node) {
        TransmissionLine line;
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("Preparing node for unpaused internal connections");
        }
        if ((line = this.findLineMiddle(node)) != null) {
            line.splitAt(node);
        }
    }

    public void bounty(PartId entityId, ChunkPos lastKnownChunk) {
        if (this.world.m_7232_(lastKnownChunk.f_45578_, lastKnownChunk.f_45579_)) {
            this.checkForExistence.computeIfAbsent(lastKnownChunk, $ -> new CheckChunk()).add(entityId);
            return;
        }
        this.expectedInChunks.computeIfAbsent(lastKnownChunk, $ -> new CheckChunk()).add(entityId);
    }

    public void tracking(ServerPlayer tracker, IWireEndpoint endpoint, boolean end) {
        if (!end) {
            this.trackers.computeIfAbsent(endpoint, $ -> new HashSet()).add(tracker);
            Collection<TransmissionLine> lines = this.globalGraph.getConnectedLines(endpoint.getNode(this.world));
            ModdedPackets.sendToClient(new TransmissionLineManagementS2CPacket(endpoint, lines), tracker);
        } else {
            Set<ServerPlayer> list = this.trackers.get(endpoint);
            if (list == null) {
                return;
            }
            list.remove(tracker);
            if (list.isEmpty()) {
                this.trackers.remove(endpoint);
            }
        }
    }

    @NotNull
    public Set<ServerPlayer> getTrackers(IWireEndpoint endpoint) {
        Set<ServerPlayer> set = this.trackers.get(endpoint);
        if (set == null) {
            return Set.of();
        }
        return set;
    }

    public void chunkLoaded(ChunkPos chunkPos) {
        CheckChunk set = this.expectedInChunks.remove(chunkPos);
        if (set != null) {
            if (this.checkForExistence.containsKey(chunkPos)) {
                this.checkForExistence.get(chunkPos).addAll(set.entities);
            } else {
                this.checkForExistence.put(chunkPos, set);
            }
        }
    }

    public OwnedFloatingNode holderOrPlaceholderNode(@NotNull IWireEndpoint endpoint) {
        OwnedFloatingNode node = this.globalExternalNodes.get(endpoint);
        if (node != null) {
            return node;
        }
        node = endpoint.isValid(this.world) ? endpoint.getNode(this.world) : new OwnedFloatingNode(endpoint);
        this.globalExternalNodes.put(endpoint, node);
        return node;
    }

    public void registerPart(PartId persistentOwnerId, TransmissionLinePart part) {
        this.lineParts.put(persistentOwnerId, part);
        this.partNodeMap.computeIfAbsent(part.getNode1(), $ -> new HashSet()).add(part);
        this.partNodeMap.computeIfAbsent(part.getNode2(), $ -> new HashSet()).add(part);
        this.m_77762_();
    }

    public void unregisterPart(PartId persistentOwnerId, TransmissionLinePart part) {
        this.lineParts.remove(persistentOwnerId);
        Set<TransmissionLinePart> set = this.partNodeMap.get(part.getNode1());
        if (set != null) {
            set.remove(part);
            if (set.isEmpty()) {
                this.partNodeMap.remove(part.getNode1());
            }
        }
        if ((set = this.partNodeMap.get(part.getNode2())) != null) {
            set.remove(part);
            if (set.isEmpty()) {
                this.partNodeMap.remove(part.getNode2());
            }
        }
        this.m_77762_();
    }

    @Nullable
    public TransmissionLinePart getPart(PartId persistentOwnerId) {
        return this.lineParts.get(persistentOwnerId);
    }

    public void inNetwork(@Nullable ElectricalNetwork network, @NotNull OwnedFloatingNode node) {
        if (network == null) {
            return;
        }
        if (node.getNetwork() != null) {
            if (node.getNetwork() != network) {
                network.merge(node.getNetwork());
            }
        } else {
            node.endpoint.joinNetwork(this.world, network);
        }
    }

    public void movePartMap(OwnedFloatingNode oldNode, OwnedFloatingNode newNode, TransmissionLinePart part) {
        if (oldNode == newNode || oldNode == null || newNode == null) {
            return;
        }
        Set<TransmissionLinePart> parts = this.partNodeMap.get(oldNode);
        if (parts == null) {
            return;
        }
        if (parts.remove(part)) {
            if (parts.isEmpty()) {
                this.partNodeMap.remove(oldNode);
            }
            this.partNodeMap.computeIfAbsent(newNode, $ -> new HashSet()).add(part);
        }
    }

    public void removeFromNetwork(OwnedFloatingNode node) {
        HashSet<IElectricNode> checked = new HashSet<IElectricNode>();
        ArrayList<IElectricNode> toCheck = new ArrayList<IElectricNode>();
        toCheck.add(node);
        while (!toCheck.isEmpty()) {
            IElectricNode check = (IElectricNode)toCheck.remove(0);
            if (!checked.add(check)) continue;
            List<IElectricNode> nodes = this.globalGraph.getConnectedNodes(check);
            Collection<ICouplingNode> couplings = this.globalGraph.getCouplings(node);
            couplings.forEach(INode::remove);
            for (IElectricNode connected : nodes) {
                Collection<AbstractElectricWire> wires = this.globalGraph.getWires(node, connected);
                for (AbstractElectricWire wire : wires) {
                    wire.remove();
                }
                toCheck.add(connected);
            }
            node.remove();
        }
    }

    private static class CheckChunk {
        public final Set<PartId> entities = Sets.newConcurrentHashSet();
        public int ticks = 0;

        private CheckChunk() {
        }

        public void add(PartId id) {
            this.entities.add(id);
            this.ticks = 0;
        }

        public void addAll(Set<PartId> ids) {
            this.entities.addAll(ids);
            this.ticks = 0;
        }
    }

    public static interface PartId {
        public BaseWireEntity getEntity(ServerLevel var1);
    }

    public record ComplexId(UUID id, int sub) implements PartId
    {
        @Override
        public BaseWireEntity getEntity(ServerLevel level) {
            Entity entity = level.m_8791_(this.id);
            if (entity instanceof BaseWireEntity) {
                BaseWireEntity wire = (BaseWireEntity)entity;
                return wire;
            }
            return null;
        }
    }

    public record SimpleId(UUID id) implements PartId
    {
        @Override
        public BaseWireEntity getEntity(ServerLevel level) {
            Entity entity = level.m_8791_(this.id);
            if (entity instanceof BaseWireEntity) {
                BaseWireEntity wire = (BaseWireEntity)entity;
                return wire;
            }
            return null;
        }
    }
}

